from mininet.topo import Topo

class externProbe(Topo):
    def __init__(self):
        "Create P2P topology."

        # Initialize topology
        Topo.__init__(self)

        # Add hosts and switches
        h1 = self.addHost('h1', ip='10.0.0.1/24')
        h2 = self.addHost('h2', ip='10.0.0.2/24')
        
        h34 = self.addHost('h34', ip='10.0.0.34/24')
        h42 = self.addHost('h42', ip='10.0.0.42/24')
        
        s1 = self.addSwitch('s1')
        s2 = self.addSwitch('s2')
        s3 = self.addSwitch('s3')
        s4 = self.addSwitch('s4')

        # Add links
        self.addLink(h1, s1)
        self.addLink(h2, s2)

        self.addLink(s1, s2)
        self.addLink(s2, s3)
        self.addLink(s1, s3)
        self.addLink(s3, s4)

        self.addLink(h34, s3)
        self.addLink(h42, s4)
        
topos = {
        'externprobe': (lambda: externProbe())
}
