#!/usr/bin/env python3
# Copyright (C) 2015 Barbora Frankova
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import os
import OpenDaylight
import socket
sys.path.append(os.path.join(os.path.dirname(__file__)))
from OpenDaylight import newIntercept
from Topology import getTopology
from Topology import getLoopFreeTopo
from OpenDaylight import getProbePosition
from Flows import getFlows
from OpenDaylight import getAllActiveIntercepts
from OpenDaylight import saveGraphFile
from OpenDaylight import getInterceptsPerProbe

def insertSDNIntercept(interceptString):
    intercept = []
    topo_url = OpenDaylight.URL + ":" + OpenDaylight.PORT + '/restconf/operational/network-topology:network-topology/topology/flow:1'
    flow_url = OpenDaylight.URL + ":" + OpenDaylight.PORT + '/restconf/operational/opendaylight-inventory:nodes/node'
    G, switches, hosts = getTopology(topo_url)
    # get spanning tree and edge weights
    getLoopFreeTopo(G, flow_url, switches)
    # get probe position from configuration file
    probes = getProbePosition(G, switches, hosts)
    saveGraphFile(G, switches, hosts, probes)
    getFlows(flow_url, switches)
    getInterceptsPerProbe(switches, probes)
    flows, activeIntercepts, usedProbes, outports, usedSwitches = getAllActiveIntercepts(switches)
    print(interceptString)
    intmsg = "insert:"
    # 192.168.1.91
    if('tcp' not in interceptString and 'udp' not in interceptString):
        intercept.append(interceptString)
        intmsg += interceptString
    # tcp3:10.0.0.1_4112
    elif('tcp3' in interceptString or 'udp3' in interceptString):
        proto, rest = interceptString.split(':')
        if 'tcp3' in proto:
            proto = 'TCP'
        else:
            proto = 'UDP'
        rest = rest.strip('(').strip(')')
        ip, port = rest.split('_')
        intercept.append(ip)
        intercept.append(port)
        intercept.append(proto)
        intmsg += ip + "," + port + "," + proto
    # tcp:(10.0.0.1, 4112, 83.11.26.4, 80)
    elif('tcp' in interceptString or 'udp' in interceptString):
        if 'tcp' in interceptString:
            proto = 'TCP'
        else:
            proto = 'UDP'
        proto, rest = interceptString.split(':')
        rest = rest.strip('(').strip(')')
        ip1, ip2, port1 , port2 = rest.split(', ')
        intercept.append(ip1)
        intercept.append(port1)
        intercept.append(ip2)
        intercept.append(port2)
        intercept.append(proto)
        intmsg += ip1 + "," + port1 + "," + ip2 + "," + port2 + "," + proto


    if intercept in activeIntercepts:
        print("Intercept ", intercept, " already active")
    else:
        status = newIntercept(G, OpenDaylight.URL + ":" + OpenDaylight.PORT + '/restconf/config/opendaylight-inventory:nodes/node', switches, hosts, probes, intercept)
        if(status == 0):
            print("Intercept not inserted")
        else:
            if os.path.exists( "/tmp/odl_deamon" ):
                client = socket.socket( socket.AF_UNIX, socket.SOCK_DGRAM )
                client.connect( "/tmp/odl_deamon" )
                client.send(intmsg.encode('ascii'))
                client.close()
            print("Intercept inserted, probe: " + str(status[0]) + ", VLAN tag: " + str(status[1]))
            return(str(status[0]).strip('probe:'))
    return(0)

def main():
    if len(sys.argv) == 2:
        intmsg = sys.argv[1]
    elif len(sys.argv) == 4:
        if sys.argv[3] == 'TCP':
            intmsg = 'tcp3:' + sys.argv[1] + '_' + sys.argv[2]
        else:
            intmsg = 'udp3:' + sys.argv[1] + '_' + sys.argv[2]
    elif len(sys.argv) == 6:
        if sys.argv[5] == 'TCP':
            intmsg = 'tcp:(' + sys.argv[1] + ', ' + sys.argv[2] + ', ' + sys.argv[3] + ', ' + sys.argv[4] + ')'
        else:
            intmsg = 'udp:(' + sys.argv[1] + ', ' + sys.argv[2] + ', ' + sys.argv[3] + ', ' + sys.argv[4] + ')'
    #else:
    #    sys.exit()
    insertSDNIntercept(intmsg)

if __name__ == "__main__":
    main()
