#!/usr/bin/env python3
# Copyright (C) 2015 Barbora Frankova
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import time
import sys
import requests
import json
import networkx as nx
sys.path.append(os.path.join(os.path.dirname(__file__)))
import Node
import logging
logging.getLogger("requests").setLevel(logging.WARNING)

LOGIN = "admin"
PASSWD = "admin"
headers = {'Content-Type': 'application/xml'}

def connectToController(url):
    """ Connect to SDN Opendaylight controller and use REST API to get list of active hosts, nodes or edges."""
    global LOGIN, PASSWD
    r = requests.get(url, auth=(LOGIN, PASSWD))
    if r.status_code != 200:
        print('Opendaylight module: failed to connect to controller, exiting. Status code ' + str(r.status_code))
        #raise Exception()
        return(str(r.status_code))
    return(json.loads(r.text))

def getTopology(hosts_url, edges_url, nodes_url):
	# get nodes, edges and hosts from controller
    nodes = connectToController(nodes_url)
    odlNodes = nodes['nodeProperties']
    edges = connectToController(edges_url)
    odlEdges = edges['edgeProperties']
    hosts = connectToController(hosts_url)

    hosts = []
    switches = []
    # create topology graph
    G = nx.Graph()
    # add nodes
    for node in odlNodes:
        G.add_node(node['node']['id'])
        switches.append(node['node']['id'])
    # add edges
    for edge in odlEdges:
        G.add_edge(edge['edge']['headNodeConnector']['node']['id'], edge['edge']['tailNodeConnector']['node']['id'])
    for host in hosts['hostConfig']:
        G.add_node(host['networkAddress'])
        G.add_edge(host['networkAddress'], host['nodeId'])
        hosts.append(host['networkAddress'])
    return(G, switches, hosts)

def getTopology(restconf_url):
    hosts = []
    switches = []
    nodes = connectToController(restconf_url)
    G = nx.Graph()
    odlNodes = nodes['topology']
    # parse json
    for node in odlNodes:
        for odlType in node:
            if(odlType == 'node'):
                for innerNodes in node['node']:
                    # hosts
                    if 'host' in innerNodes['node-id']:
                        # get node addresses
                        if 'host-tracker-service:addresses' in innerNodes:
                            for address in innerNodes['host-tracker-service:addresses']:
                                ip = address['ip']
                                mac = address['mac']
                        if 'host-tracker-service:attachment-points' in innerNodes:
                            for point in innerNodes['host-tracker-service:attachment-points']:
                                name, number, interface = point['tp-id'].split(':')
                                datapath = name + ":" + number
                            #print(innerNodes['host-tracker-service:attachment-points'])
                        nodeId = innerNodes['node-id']
                        #G.add_node(innerNodes['node-id'])
                        host = Node.Host(nodeId, ip, mac, datapath, interface)
                        hosts.append(host)
                    # switches
                    else:
                        switch = Node.Switch(innerNodes['node-id'])
                        switches.append(switch)
                        #G.add_node(innerNodes['node-id'])
    for node in odlNodes:
        for odlType in node:
            # links
            if(odlType == 'link'):
                for link in node['link']:
                    #print(link)
                    ip = ""
                    if link['destination']['dest-node'] not in G.nodes():
                        G.add_node(link['destination']['dest-node'])
                    if link['source']['source-node'] not in G.nodes():
                        G.add_node(link['source']['source-node'])
                    # add edge to graph
                    G.add_edge(link['destination']['dest-node'], link['source']['source-node'])
                    G[link['destination']['dest-node']][link['source']['source-node']]['weight'] = 1
                    # update detailed info
                    if link['link-id'].find('host') != -1:
                        for host in hosts:
                            if host.hostId == link['source']['source-node']:
                                ip = host.ipAddress
                                for curr in switches:
                                    if curr.switchId == link['destination']['dest-node']:
                                        name, number, interface = link['destination']['dest-tp'].split(':')
                                        curr.interfaces[ip] = interface
                        # find source host
                    else:
                        for curr in switches:
                            if curr.switchId == link['destination']['dest-node']:
                                name, number, interface = link['destination']['dest-tp'].split(':')
                                curr.interfaces[link['source']['source-node']] = interface
    #for switch in switches:
    #    print(switch.interfaces)
    #print('-----')
    #for host in hosts:
    #    print(host)
    #print("------")
    #for edge in nx.generate_edgelist(G):
    #    print(edge)
    #print("DONE")
    return(G, switches, hosts)

def getLoopFreeTopo(G, url, switches):
    #print(switches)
    #print(url)
    for switch in switches:
        #print(url + "/" + switch.switchId)
        for key in switch.interfaces:
            if "probe" not in key:
                #print(url + "/" + switch.switchId + "/node-connector/" + switch.switchId + ":" + switch.interfaces[key])
                data = connectToController(url + "/" + switch.switchId + "/node-connector/" + switch.switchId + ":" + switch.interfaces[key])
                while data is "404":
                    data = connectToController(url + "/" + switch.switchId + "/node-connector/" + switch.switchId + ":" + switch.interfaces[key])
                #print(data)
                #print(data["node-connector"])
                for item in data["node-connector"]:
                    if "stp-status-aware-node-connector:status" in item:
                        #print(key)
                        #print(item["stp-status-aware-node-connector:status"])
                        if item["stp-status-aware-node-connector:status"] == "forwarding" and G[switch.switchId][key]['weight'] == 1:
                            G[switch.switchId][key]['weight'] = 5
