#!/usr/bin/env python3
# Copyright (C) 2015 Barbora Frankova
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import time
import sys

sys.path.append(os.path.join(os.path.dirname(__file__)))

class Switch:
    def __init__(self, switchId):
        self.switchId = switchId
        self.interfaces = {}
        self.flows = {}
        self.flows[0] = {}
        self.flows[1] = {}

    def __repr__(self):
        return("Switch " + str(self.switchId) + ", interfaces: " + str(self.interfaces))
    
    def getNextFlowId(self, table):
        maxId = 0
        #print(self.flows[table])
        for i in range(3, 256):
            if i not in self.flows[table]:
                return(i)
        #for key in self.flows[table]:
        #    if self.flows[table][key].Id > maxId:
        #        maxId = self.flows[table][key].Id
        print("Too many flows in table " + str(table) + ". Can not add more.")
        return(0)

class Host:
    def __init__(self, hostId, ipAddress, macAddress, attachementSwitch, attachementSwitchInterface):
        self.hostId = hostId
        self.ipAddress = ipAddress
        self.macAddress = macAddress
        self.attachementSwitch = attachementSwitch
        self.attachementSwitchInterface = attachementSwitchInterface

    def getAttachementSwitch(self):
        return(self.attachementSwitch)
    
    def getAttachementSwitchInterface(self):
        return(self.attachementSwitchInterface)
        
    def displayHost(self):
        print("Host ID: ", self.hostId)
    
    def __repr__(self):
        return("Host " + str(self.hostId) + ", IP: " + str(self.ipAddress))

class Probe:
    def __init__(self, probeId, vlanTag, switch1, switch1Interface, switch2, switch2Interface):
        self.probeId = probeId
        self.vlanTag = vlanTag
        self.switch1 = switch1
        self.switch2 = switch2
        self.switch1Interface = switch1Interface
        self.switch2Interface = switch1Interface
        self.numOfIntercepts = 0
    
    def displayProbe(self):
        print("Probe VLAN tag: ", self.switchId)
    
    def __repr__(self):
        return("ID " + str(self.probeId) + ", tag: " + str(self.vlanTag) + ", attachement switch1: " + self.switch1 + ", attachement switch2: " + (self.switch2 if (self.switch2 is not None) else "-") + ", nIntercepts: " + str(self.numOfIntercepts))
    
    def __eq__(self, other): 
        return (self.probeId == other.probeId and self.vlanTag == other.vlanTag and self.switch1 == other.switch1)
