#!/usr/bin/env python
# Copyright (C) 2015 Barbora Frankova
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import OpenDaylight
from OpenDaylight import newIntercept
from Topology import getTopology
from Topology import getLoopFreeTopo
from OpenDaylight import getProbePosition
from Flows import getFlows
from OpenDaylight import getAllActiveIntercepts
from OpenDaylight import saveGraphFile
from OpenDaylight import getInterceptsPerProbe
from OpenDaylight import getStats as gs

def getStats():
    topo_url = 'http://localhost' + ":" + OpenDaylight.PORT + '/restconf/operational/network-topology:network-topology/topology/flow:1'
    flow_url = 'http://localhost' + ":" + OpenDaylight.PORT + '/restconf/operational/opendaylight-inventory:nodes/node'
    G, switches, hosts = getTopology(topo_url)
    # get spanning tree and edge weights
    getLoopFreeTopo(G, flow_url, switches)
    # get probe position from configuration file
    probes = getProbePosition(G, switches, hosts)
    getFlows(flow_url, switches)
    getInterceptsPerProbe(switches, probes)
    gs(switches, probes)
    saveGraphFile(G, switches, hosts, probes)

def main():
    getStats()

if __name__ == "__main__":
    main()
