#!/usr/bin/env python3
# Copyright (C) 2015 Barbora Frankova
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import time
import sys
import requests
import logging
sys.path.append(os.path.join(os.path.dirname(__file__)))
import Flow
import Node
from Topology import connectToController

LOGIN = "admin"
PASSWD = "admin"
headers = {'Content-Type': 'application/xml'}

logging.getLogger("requests").setLevel(logging.WARNING)

def deleteFlow(url, switch, table, flow):
    tempUrl = url + '/' + switch + '/table/' + str(table) + '/flow/' + str(flow)
    #print(tempUrl)
    r = requests.delete(tempUrl, auth=(LOGIN, PASSWD), headers=headers)
    if r.status_code != 200:
        print("Failed to delete flow " + str(flow) + " from table " + str(table) + " (" + switch + ") - error " + str(r.status_code))
    #print(r)

def addFlow(url, switch, table, flow, data):
    tempUrl = url + '/' + switch + '/table/' + str(table) + '/flow/' + str(flow)
    #print(tempUrl)
    #print(data)
    r = requests.put(tempUrl, auth=(LOGIN, PASSWD), headers=headers, data=data)
    #print(r)
    if r.status_code != 200:
        print("Failed to add flow " + str(flow) + " in table " + str(table) + " (" + switch + ") - error " + str(r.status_code))
    #print(r)


def getFlows(restconf_url, switches):
    for switch in switches:
        for table in range(2):
            try:
                allFlows = connectToController(restconf_url + '/' + switch.switchId + '/table/' + str(table) + '/')
                allFlows = allFlows['flow-node-inventory:table']
                for flowEntry in allFlows:
                    if 'flow' not in flowEntry:
                        continue
                    for flow in flowEntry['flow']:
                        #print flow
                        vlanId = 0
                        flowId = 0
                        match = ""
                        ip = ''
                        outport = ''
                        goto_table = ''
                        push_vlan = ''
                        pop_vlan = ''
                        if 'id' in flow:
                            flowId = flow['id']
                        if 'flow-name' in flow:
                            print("tady")
                            vlanId = int(flow['flow-name'])
                        if '#UF$TABLE' in flowId or flowId == 0:
                            continue
                        #print(flow)
                        #if 'priority' in flow:
                            #print('prio:' + str(flow['priority']))
                        if 'match' in flow:
                            #print(flow['match'])
                            if 'udp-destination-port' in flow['match'] and 'udp-source-port' not in flow['match']:
                                match = (',port:' + str(flow['match']['udp-destination-port']) + ',' + 'proto:UDP')
                            if 'udp-source-port' in flow['match'] and 'udp-destination-port' not in flow['match']:
                                match = (',port:' + str(flow['match']['udp-source-port']) + ',' + 'proto:UDP')
                            if 'tcp-destination-port' in flow['match'] and 'tcp-source-port' not in flow['match']:
                                match = (',port:' + str(flow['match']['tcp-destination-port']) + ',' + 'proto:TCP')
                            if 'tcp-source-port' in flow['match'] and 'tcp-destination-port' not in flow['match']:
                                match = (',port:' + str(flow['match']['tcp-source-port']) + ',' + 'proto:TCP')
                            if 'udp-destination-port' in flow['match'] and 'udp-source-port' in flow['match']:
                                match = (',src-port:' + str(flow['match']['udp-source-port']) + ',dest-port:' + str(flow['match']['udp-destination-port']) + ',proto:UDP')
                            if 'tcp-destination-port' in flow['match'] and 'tcp-source-port' in flow['match']:
                                match = (',src-port:' + str(flow['match']['tcp-source-port']) + ',dest-port:' + str(flow['match']['tcp-destination-port']) + ',proto:TCP')
                            if 'ipv4-destination' in flow['match']:
                                if ip != "":
                                    ip = ip + ","
                                ip += "dest-ip:"
                                ip2, mask = flow['match']['ipv4-destination'].split('/')
                                ip += ip2
                            if 'ipv4-source' in flow['match']:
                                if ip != "":
                                    ip = ip + ","
                                ip += "src-ip:"
                                ip2, mask = flow['match']['ipv4-source'].split('/')
                                ip += ip2
                            if 'ipv4-source' in flow['match'] and 'ipv4-destination' in flow['match']:
                                ip1, mask = flow['match']['ipv4-source'].split('/')
                                ip2, mask = flow['match']['ipv4-destination'].split('/')
                                ip = "src-ip:" + ip1 + ",dest-ip:" + ip2
                            if flow['match'] == {}:
                                match += "*"
                            #if 'ethernet-match' in flow['match']:
                                #print(flow['match']['ethernet-match'])
                                #if 'ethernet-type' in flow['match']['ethernet-match']:
                                    #print(flow['match']['ethernet-match']['ethernet-type'])
                                    #if flow['match']['ethernet-match']['ethernet-type']['type'] == 33024:
                                        #match += ("type:vlan")
                            if 'vlan-match' in flow['match']:
                                #print(flow['match'])
                                if 'vlan-id' in flow['match']['vlan-match']:
                                    if 'vlan-id' in flow['match']['vlan-match']['vlan-id']:
                                        if str(flow['match']['vlan-match']['vlan-id']['vlan-id']) == '0':
                                            match += ("type:vlan")
                                        else:
                                            match += ("vlan:vlan" + str(flow['match']['vlan-match']['vlan-id']['vlan-id']))
                                            vlanId = flow['match']['vlan-match']['vlan-id']['vlan-id']
                        if 'instructions' in flow:
                            #print(flow['instructions'])
                            if 'instruction' in flow['instructions']:
                                #print(flow['instructions']['instruction'])
                                for instruction in flow['instructions']['instruction']:
                                    if 'apply-actions' in instruction:
                                        if 'action' in instruction['apply-actions']:
                                            #print(instruction['apply-actions']['action'])
                                            for apply_action in instruction['apply-actions']['action']:
                                                if 'set-field' in apply_action:
                                                    if 'vlan-match' in apply_action['set-field']:
                                                        if 'vlan-id' in apply_action['set-field']['vlan-match']:
                                                            if 'vlan-id' in apply_action['set-field']['vlan-match']['vlan-id']:
                                                                vlanId = apply_action['set-field']['vlan-match']['vlan-id']['vlan-id']
                                                if 'output-action' in apply_action:
                                                    if 'output-node-connector' in apply_action['output-action']:
                                                        outport = ("outport:" + str(apply_action['output-action']['output-node-connector']))
                                                if 'push-vlan-action' in apply_action:
                                                    push_vlan = ("push:vlan" + str(vlanId))
                                                if 'pop-vlan-action' in apply_action:
                                                    #print(instruction['apply-actions']['action']['pop-vlan-action'])
                                                    pop_vlan = ("pop:vlan" + str(vlanId))
                                    if 'go-to-table' in instruction:
                                        goto_table += ("go-to:table" + str(instruction['go-to-table']['table_id']))
                        final_match = ""
                        #print(match)
                        #print(ip)
                        #print(goto_table)
                        if(match is not "" and ip is not ""):
                            #print(ip + match)
                            final_match = ip + match
                        if(ip is not "" and match is ""):
                            final_match = ip
                        if(match is not "" and ip is ""):
                            final_match = match
                        final_action = ""
                        if(push_vlan != "" and outport != "" and pop_vlan != "" and goto_table != ""):
                            final_action = (push_vlan + "," + outport + "," + pop_vlan + "," + goto_table)
                        if(outport != "" and pop_vlan != "" and push_vlan == ""):
                            final_action = (pop_vlan + "," + outport)
                        if(outport != "" and pop_vlan == ""):
                            final_action = outport
                        if(push_vlan == "" and outport == "" and pop_vlan == "" and goto_table != ""):
                            final_action = goto_table
                        if(push_vlan == "" and pop_vlan == "" and outport != "" and goto_table != ""):
                            final_action = outport + "," + goto_table
                        #print final_action
                        flow = Flow.Flow(flow['id'], switch.switchId, table, str(flow['priority']), final_match, final_action)
                        switch.flows[table][int(flowId)] = flow
                        #print("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++")
            except:
                print("Flows not available yet. Try again.")
    #for switch in switches:
    #    print(switch.flows[0])

def createInitFlow(url, switch, table, flow):
    data = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><flow xmlns="urn:opendaylight:flow:inventory">\
    <strict>true</strict>\
    <instructions>\
        <instruction>\
            <order>0</order>\
            <go-to-table>\
                <table_id>2</table_id>\
            </go-to-table>\
        </instruction>\
    </instructions>\
    <table_id>' + str(table) + '</table_id>\
    <id>' + str(flow) + '</id>\
    <cookie_mask>10</cookie_mask>\
    <installHw>false</installHw>\
    <match/>\
    <hard-timeout>0</hard-timeout>\
    <cookie>10</cookie>\
    <idle-timeout>0</idle-timeout>\
    <flow-name>flow-instruction-go-to-table</flow-name>\
    <priority>2</priority>\
    <barrier>false</barrier></flow>'
    addFlow(url, switch, table, flow, data)
    
def createInterceptFlow(url, switch, table, flow, intercept, actions, vlan, outPort, ipMatchType):
    if 'push:vlan' in actions:
        instructions = '\
        <instruction>\
            <order>0</order>\
            <apply-actions>\
                <action>\
                    <push-vlan-action>\
                        <ethernet-type>33024</ethernet-type>\
                    </push-vlan-action>\
                    <order>0</order>\
                </action>\
                <action>\
                    <set-field>\
                        <vlan-match>\
                            <vlan-id>\
                                <vlan-id>' + str(vlan) +'</vlan-id>\
                                <vlan-id-present>true</vlan-id-present>\
                            </vlan-id>\
                        </vlan-match>\
                    </set-field>\
                    <order>1</order>\
                </action>\
                <action>\
                    <output-action>\
                        <output-node-connector>' + str(outPort) + '</output-node-connector>\
                    </output-action>\
                    <order>2</order>\
                </action>\
                <action>\
                    <pop-vlan-action/>\
                    <order>3</order>\
                </action>\
            </apply-actions>\
        </instruction>'
    else:
        instructions = '\
        <instruction>\
            <order>0</order>\
            <apply-actions>\
                <action>\
                    <output-action>\
                        <output-node-connector>' + str(outPort) + '</output-node-connector>\
                    </output-action>\
                    <order>0</order>\
                </action>\
            </apply-actions>\
        </instruction>'
        
    # intercept targeted only to IP address
    if ipMatchType is "destination":
        ipMatch = '<ipv4-destination>' + str(intercept[0]) + '/32</ipv4-destination>'
    else:
        ipMatch = '<ipv4-source>' + str(intercept[0]) + '/32</ipv4-source>'
    # intercept targeted to IP address, port, transport protocol
    if len(intercept) is 3:
        # protocol TCP
        if intercept[2] == "TCP":
            if ipMatchType is "destination":
                ipMatch = ipMatch + "<ip-match><ip-protocol>6</ip-protocol></ip-match>" + '<tcp-destination-port>' + str(intercept[1]) + '</tcp-destination-port>'
            else:
                ipMatch = ipMatch + "<ip-match><ip-protocol>6</ip-protocol></ip-match>" + '<tcp-source-port>' + str(intercept[1]) + '</tcp-source-port>'
        # protocol UDP
        if intercept[2] == "UDP":
            if ipMatchType is "destination":
                ipMatch = ipMatch + "<ip-match><ip-protocol>17</ip-protocol></ip-match>" + '<udp-destination-port>' + str(intercept[1]) + '</udp-destination-port>'
            else:
                ipMatch = ipMatch + "<ip-match><ip-protocol>17</ip-protocol></ip-match>" + '<udp-source-port>' + str(intercept[1]) + '</udp-source-port>'
    if len(intercept) is 5:
        # protocol TCP
        if intercept[4] == "TCP" or intercept[4] == "tcp":
            ipMatch = '<ipv4-source>' + str(intercept[0]) + '/32</ipv4-source>' + '<ipv4-destination>' + str(intercept[1]) + '/32</ipv4-destination>'
            ipMatch = ipMatch + "<ip-match><ip-protocol>6</ip-protocol></ip-match>" + '<tcp-source-port>' + str(intercept[2]) + '</tcp-source-port>'
            ipMatch = ipMatch + '<tcp-destination-port>' + str(intercept[3]) + '</tcp-destination-port>'
        # protocol UDP
        if intercept[4] == "UDP" or intercept[4] == "udp":
            ipMatch = '<ipv4-source>' + str(intercept[0]) + '/32</ipv4-source>' + '<ipv4-destination>' + str(intercept[1]) + '/32</ipv4-destination>'
            ipMatch = ipMatch + "<ip-match><ip-protocol>17</ip-protocol></ip-match>" + '<udp-source-port>' + str(intercept[2]) + '</udp-source-port>'
            ipMatch = ipMatch + '<udp-destination-port>' + str(intercept[3]) + '</udp-destination-port>'
    #print(intercept)
    #print(ipMatch)
        
    data = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><flow xmlns="urn:opendaylight:flow:inventory">\
    <strict>true</strict>\
    <instructions>' + instructions + '\
        <instruction>\
            <order>1</order>\
            <go-to-table>\
                <table_id>2</table_id>\
            </go-to-table>\
        </instruction>\
    </instructions>\
    <table_id>' + str(table) + '</table_id>\
    <id>' + str(flow) + '</id>\
    <cookie_mask>10</cookie_mask>\
    <installHw>false</installHw>\
    <match>\
        <ethernet-match>\
            <ethernet-type>\
                <type>2048</type>\
            </ethernet-type>\
        </ethernet-match>' + ipMatch + '</match>\
    <hard-timeout>0</hard-timeout>\
    <cookie>10</cookie>\
    <idle-timeout>0</idle-timeout>\
    <flow-name>' + str(vlan) + '</flow-name>\
    <priority>5</priority>\
    <barrier>false</barrier>\
    </flow>'
    #print(data)
    addFlow(url, switch, table, flow, data)

def createVlanGotoTableFlow(url, switch, table, flow):
    data = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><flow xmlns="urn:opendaylight:flow:inventory">\
    <strict>true</strict>\
    <instructions>\
        <instruction>\
            <order>0</order>\
            <go-to-table>\
                <table_id>1</table_id>\
            </go-to-table>\
        </instruction>\
    </instructions>\
    <table_id>' + str(table) + '</table_id>\
    <id>' + str(flow) + '</id>\
    <cookie_mask>10</cookie_mask>\
    <installHw>false</installHw>\
    <match>\
      <vlan-match>\
            <vlan-id>\
                <vlan-id>0</vlan-id>\
                <vlan-id-present>true</vlan-id-present>\
            </vlan-id>\
      </vlan-match>\
    </match>\
    <hard-timeout>0</hard-timeout>\
    <cookie>10</cookie>\
    <idle-timeout>0</idle-timeout>\
    <flow-name>xxx</flow-name>\
    <priority>10</priority>\
    <barrier>false</barrier>\
    </flow>'
    addFlow(url, switch, table, flow, data)

def setVlanTagRemoveFlow(url, switch, table, flow, vlan, outport):
    data = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><flow xmlns="urn:opendaylight:flow:inventory">\
    <strict>true</strict>\
    <instructions>\
        <instruction>\
            <order>0</order>\
            <apply-actions>\
                <action>\
                    <pop-vlan-action/>\
                    <order>0</order>\
                </action>\
                <action>\
                    <output-action>\
                        <output-node-connector>' + str(outport) + '</output-node-connector>\
                    </output-action>\
                    <order>1</order>\
                </action>\
            </apply-actions>\
        </instruction>\
    </instructions>\
    <table_id>' + str(table) + '</table_id>\
    <id>' + str(flow) + '</id>\
    <cookie_mask>10</cookie_mask>\
    <installHw>false</installHw>\
    <match>\
      <vlan-match>\
            <vlan-id>\
                <vlan-id>' + str(vlan) + '</vlan-id>\
                <vlan-id-present>true</vlan-id-present>\
            </vlan-id>\
      </vlan-match>\
    </match>\
    <hard-timeout>0</hard-timeout>\
    <cookie>10</cookie>\
    <idle-timeout>0</idle-timeout>\
    <flow-name>xxx</flow-name>\
    <priority>10</priority>\
    <barrier>false</barrier>\
    </flow>'
    addFlow(url, switch, table, flow, data)
    
    
def createVlanForwardFlow(url, switch, table, flow, vlan, outPort):
    data = '<?xml version="1.0" encoding="UTF-8" standalone="no"?><flow xmlns="urn:opendaylight:flow:inventory">\
    <strict>true</strict>\
    <instructions>\
        <instruction>\
            <order>0</order>\
            <apply-actions>\
                <action>\
                    <output-action>\
                        <output-node-connector>' + str(outPort) + '</output-node-connector>\
                    </output-action>\
                    <order>0</order>\
                </action>\
            </apply-actions>\
        </instruction>\
    </instructions>\
    <table_id>' + str(table) + '</table_id>\
    <id>' + str(flow) + '</id>\
    <cookie_mask>10</cookie_mask>\
    <installHw>false</installHw>\
    <match>\
        <vlan-match>\
            <vlan-id>\
                <vlan-id>' + str(vlan) + '</vlan-id>\
                <vlan-id-present>true</vlan-id-present>\
            </vlan-id>\
        </vlan-match>\
    </match>\
    <hard-timeout>0</hard-timeout>\
    <cookie>10</cookie>\
    <idle-timeout>0</idle-timeout>\
    <flow-name>xxx</flow-name>\
    <priority>10</priority>\
    <barrier>false</barrier>\
    </flow>'
    addFlow(url, switch, table, flow, data)
