#!/usr/bin/env python3
# Copyright (C) 2015 Barbora Frankova
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import os
import socket

sys.path.append(os.path.join(os.path.dirname(__file__)))
import OpenDaylight
import Node
from Topology import getTopology
from Flows import getFlows
from OpenDaylight import deleteInterceptFlow
from OpenDaylight import getAllActiveIntercepts
from OpenDaylight import getProbePosition

def deleteSDNIntercept(interceptString):
    intercept = []

    topo_url = OpenDaylight.URL + ":" + OpenDaylight.PORT + '/restconf/operational/network-topology:network-topology/topology/flow:1'
    flow_url = OpenDaylight.URL + ":" + OpenDaylight.PORT + '/restconf/operational/opendaylight-inventory:nodes/node'
    delete_flow_url = OpenDaylight.URL + ":" + OpenDaylight.PORT + '/restconf/config/opendaylight-inventory:nodes/node'
    G, switches, hosts = getTopology(topo_url)
    # get probe position from configuration file
    probes = getProbePosition(G, switches, hosts)
    getFlows(flow_url, switches)
    flows, activeIntercepts, usedProbes, outports, usedSwitches = getAllActiveIntercepts(switches)

    intmsg = "delete:"
    # 192.168.1.91
    if('tcp' not in interceptString and 'udp' not in interceptString):
        intercept.append(interceptString)
        intmsg += interceptString
    # tcp3:10.0.0.1_4112
    elif('tcp3' in interceptString or 'udp3' in interceptString):
        proto, rest = interceptString.split(':')
        if 'tcp3' in proto:
            proto = 'TCP'
        else:
            proto = 'UDP'
        rest = rest.strip('(').strip(')')
        ip, port = rest.split('_')
        intercept.append(ip)
        intercept.append(port)
        intercept.append(proto)
        intmsg += ip + "," + port + "," + proto
    # tcp:(10.0.0.1, 4112, 83.11.26.4, 80)
    elif('tcp' in interceptString or 'udp' in interceptString):
        pass

    #print(intercept)
    
    if intercept in activeIntercepts:
        status = deleteInterceptFlow(delete_flow_url, switches, intercept)
        if status != 0:
            print("Intercept deleted, VLAN tag: " + str(status))
            if os.path.exists( "/tmp/odl_deamon" ):
                client = socket.socket( socket.AF_UNIX, socket.SOCK_DGRAM )
                client.connect( "/tmp/odl_deamon" )
                client.send(intmsg.encode('ascii'))
                client.close()
        return(str(status))
    else:
        print("Intercept not active")

def main():
    deleteSDNIntercept(sys.argv[1])

if __name__ == "__main__":
    main()

