# -*- coding: utf-8 -*-
# Class describing CID identifier
#
# Copyright (C) 2011 Matěj Grégr, Michal Kajan, Libor Polčák, Vladimír Veselý
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import time
from ..tools.time import periodToStructTime

class CID(object):

    def __init__(self, noid, nid, cin, dcc):
        """ Constructor

        noid - unique operator ID, LEA assigned
        nid NID of the intercept - ip address, radius login
        cin - identifier for intercept
        dcc - delivery country code
        """
        self.__noid = noid
        self.__nid = nid
        self.__cin = cin
        self.__dcc = dcc

    def increaseCIN(self):
        if self.__cin == None:
            self.__cin = 0
        self.__cin = int(self.__cin) + 1

    # Getters
    def getnoid(self):
        return self.__noid

    def getCIN(self):
        return self.__cin

    def setCIN(self, cin):
        self.__cin = cin

    def getNID(self):
        return self.__nid

    def getDCC(self):
        return self.__dcc

    def __repr__(self):
        return "CID('%s', '%s', '%s', '%s')" % (self.__noid, \
            self.__nid, self.__cin, self.__dcc)

    def __str__(self):
        return repr(self)

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        return self.__noid == other.__noid and \
            self.__nid == other.__nid and \
            str(self.__cin) == str(other.__cin) and \
            self.__dcc == other.__dcc

    def __hash__(self):
        return hash(repr(self))
