/*
 * Soubor:  ymsg.h
 * Datum:   06.08.2012
 * Autor:   Stanislav Bárta, xbarta29@stud.fit.vutbr.cz
 * Projekt: IM modul
 * Popis:   hlavickovy soubor pro funkce zpracovavajici protokol YMSG
 */

#ifndef _YMSG_
#define _YMSG_

#include <stdio.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "my_string.h"
#include "my_xml.h"
#include "zpracovany_packet.h"
#include "iri.h"
#include "sprava.h"

#define YMSG_HEADER_LENGTH 20

struct ymsg_header
{
	uint32_t id;
	uint32_t version;
	uint16_t data_length;
	uint16_t service;
	uint32_t status;
	uint32_t session_ID;
};

struct ymsg_hodnoty_polozka
{
	int id;
	char *value;
};

struct ymsg_hodnoty
{
	int pocet;
	struct ymsg_hodnoty_polozka **hodnoty;
};

void zpracuj_ymsg(struct data_packetu *zprava, struct sezeni *Sezeni);
void ukonci_ymsg(struct data_packetu *zprava, struct sezeni *Sezeni);
struct ymsg_hodnoty *analyzuj_ymsg_obsah(char *obsah);
struct ymsg_hodnoty_polozka *pridej_hodnotu_do_seznamu(struct ymsg_hodnoty *seznam);
void nova_hodnota(struct ymsg_hodnoty_polozka **hodnota);
void smaz_seznam_hodnot(struct ymsg_hodnoty *seznam);

#endif
