# -*- coding: utf-8 -*-
# Class describing interception transferred through INI1c
#
# Copyright (C) 2011 Matěj Grégr, Michal Kajan, Libor Polčák, Vladimír Veselý
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import time
from ..tools.time import periodToStructTime

class INI1CIntercept(object):

    def __init__(self, liid, lea, period, cc):
        """ Constructor

        liid LIID of the intercept
        lea A string that uniquely identifies LEA
        period 2-tuple of starting and ending time (number of seconds) of the interception
        cc Boolean that determines if CC should be also present
        """
        #FIXME configuration of LEMF interfaces
        # (note: Added LEA to make MF able to separate PCAPs to different LEA directories)
        self.__liid = liid
        self.__lea = lea
        self.__start, self.__end = periodToStructTime(period)
        self.__cc = cc

    # Getters
    def getLIID(self):
        return self.__liid
        
    def getLEA(self):
        return self.__lea

    def getInterceptionPeriod(self):
        return (self.__start, self.__end)

    def getInterceptCC(self):
        return self.__cc

    def __repr__(self):
        return "INI1CIntercept('%s', '%s', (%s, %s), %s)" % (self.__liid, self.__lea, \
            time.mktime(self.__start), time.mktime(self.__end), repr(self.__cc))

    def __str__(self):
        return repr(self)

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        return self.__liid == other.__liid and \
                self.__start == other.__start and \
                self.__cc == other.__cc
