import pyretic.vendor

from ryu.lib.packet import *
from ryu.lib import addrconv

from pyretic.core.packet import *
from pyretic.core.packet import ProtocolValidator, EthertypeValidator, Processor
import pytest

udp_payload_srcmac="\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x01\x08\x00\x45\x00\x01\x48\x04\x46\x00\x00\x80\x11\xb4\x03\xc0\xa8\x00\x01\xc0\xa8\x00\x0a\x00\x43\x00\x44\x01\x34\xdf\xdb\x02\x01\x06\x00\x00\x00\x3d\x1e\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xa8\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x82\x01\xfc\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x82\x53\x63\x35\x01\x05\x3a\x04\x00\x00\x07\x08\x3b\x04\x00\x00\x0c\x4e\x33\x04\x00\x00\x0e\x10\x36\x04\xc0\xa8\x00\x01\x01\x04\xff\xff\xff\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
udp_payload="\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x02\x08\x00\x45\x00\x01\x48\x04\x46\x00\x00\x80\x11\xb4\x03\xc0\xa8\x00\x01\xc0\xa8\x00\x0a\x00\x43\x00\x44\x01\x34\xdf\xdb\x02\x01\x06\x00\x00\x00\x3d\x1e\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xa8\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x82\x01\xfc\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x82\x53\x63\x35\x01\x05\x3a\x04\x00\x00\x07\x08\x3b\x04\x00\x00\x0c\x4e\x33\x04\x00\x00\x0e\x10\x36\x04\xc0\xa8\x00\x01\x01\x04\xff\xff\xff\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"

udp_pkt     = packet.Packet(udp_payload)
udp_pyr = { 'raw': udp_payload, 'inport': 12, 'outport': 14, 'dstip': '192.168.0.12' }

arp_payload="\xff\xff\xff\xff\xff\xff\x00\x16\xce\x6e\x8b\x24\x08\x06\x00\x01\x08\x00\x06\x04\x00\x01\x00\x16\xce\x6e\x8b\x24\xc0\xa8\x00\x72\x00\x00\x00\x00\x00\x00\xc0\xa8\x00\x01"
arp_pkt     = packet.Packet(arp_payload)
arp_pyr = { 'raw': arp_payload, 'inport': 12, 'outport': 14, 'dstip': '192.168.0.12', 'srcip': '192.168.0.234', 'protocol': 12 }

vlan_payload="\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x02\x81\x00\x45\x55\x08\x00\x45\x00\x01\x48\x04\x46\x00\x00\x80\x11\xb4\x03\xc0\xa8\x00\x01\xc0\xa8\x00\x0a\x00\x43\x00\x44\x01\x34\xdf\xdb\x02\x01\x06\x00\x00\x00\x3d\x1e\x00\x00\x00\x00\x00\x00\x00\x00\xc0\xa8\x00\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x82\x01\xfc\x42\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x63\x82\x53\x63\x35\x01\x05\x3a\x04\x00\x00\x07\x08\x3b\x04\x00\x00\x0c\x4e\x33\x04\x00\x00\x0e\x10\x36\x04\xc0\xa8\x00\x01\x01\x04\xff\xff\xff\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
vlan_pkt     = packet.Packet(vlan_payload)
vlan_pyr = { 'raw': vlan_payload, 'inport': 12, 'outport': 14, 'dstip': '192.168.0.12' }


def test_class_being_available_as_field_when_decorated_with_of_field():
    @of_field("ipv4.src", "testfield")
    class TestAvailableField(object):
        pass

    assert "TestAvailableField" in of_fields()

    of_fields().pop("TestAvailableField", None)

def test_field_encode():
    @of_field("ipv4.src", "srcip")
    class IpField(object):
        pass

    assert IpField().decode(udp_pkt) == "192.168.0.1"

    of_fields().pop("IpField", None)

def test_field_decode():
    @of_field("ipv4.dst", "dstip")
    class IpField(object):
        pass

    pkt = packet.Packet(IpField().encode(udp_pyr)['raw'])
    assert IpField().decode(pkt) == "192.168.0.12"
    of_fields().pop("IpField", None)

def test_validators():
    assert ProtocolValidator(12) != ProtocolValidator(11)
    assert ProtocolValidator(12) == ProtocolValidator(12)
    assert EthertypeValidator(0x0800) != EthertypeValidator(0x86dd)
    assert EthertypeValidator(0x0800) == EthertypeValidator(0x0800)

def test_udp_dst_port():
    field = of_fields()["UdpDstPort"]()
    assert field.is_valid(udp_pkt)
    assert field.decode(udp_pkt) == 68


def test_udp_src_port():
    field = of_fields()["UdpSrcPort"]()
    assert field.is_valid(udp_pkt)
    assert field.decode(udp_pkt) == 67

def test_tcp_src_port():
    field = of_fields()["TcpSrcPort"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

def test_tcp_dst_port():
    field = of_fields()["TcpDstPort"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

def test_icmp_code():
    field = of_fields()["IcmpCode"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

def test_icmp_type():
    field = of_fields()["IcmpType"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

def test_arp_opcode():
    field = of_fields()["ArpOpcode"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

    assert field.is_valid(arp_pkt) == True
    assert field.decode(arp_pkt) == 1

    pkt = packet.Packet(field.encode(arp_pyr)['raw'])
    assert pkt.protocols[-1].opcode == 12

def test_arp_src_ip():
    field = of_fields()["ArpSrcIp"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

    assert field.is_valid(arp_pkt) == True
    assert field.decode(arp_pkt) == "192.168.0.114"

    pkt = packet.Packet(field.encode(arp_pyr)['raw'])
    assert pkt.protocols[-1].src_ip == "192.168.0.234"

def test_arp_dst_ip():
    field = of_fields()["ArpDstIp"]()
    assert field.is_valid(udp_pkt) == False
    assert field.decode(udp_pkt) == None

    assert field.is_valid(arp_pkt) == True
    assert field.decode(arp_pkt) == "192.168.0.1"

    pkt = packet.Packet(field.encode(arp_pyr)['raw'])
    assert pkt.protocols[-1].dst_ip == "192.168.0.12"


def test_processor_packing():
    pro = Processor().compile()
    func = pro.unpack

    assert func(udp_payload) == {'dstip': '192.168.0.10', 'protocol': 17, 'srcmac': '00:00:00:00:00:02', 'tos': 0, 'dstmac': '00:00:00:00:00:01', 'ethtype': 2048, 'srcip': '192.168.0.1', 'dstport': 68, 'srcport': 67, 'header_len': 14, 'payload_len': len(udp_payload)}
    
    assert func(udp_pkt) == {'dstip': '192.168.0.10', 'protocol': 17, 'srcmac': '00:00:00:00:00:02', 'tos': 0, 'dstmac': '00:00:00:00:00:01', 'ethtype': 2048, 'srcip': '192.168.0.1', 'dstport': 68, 'srcport': 67, 'header_len': 14, 'payload_len': len(udp_payload)}

    assert func(arp_pkt) == {'dstip': '192.168.0.1', 'protocol': 1, 'srcmac': '00:16:ce:6e:8b:24', 'ethtype': 2054, 'srcip': '192.168.0.114', 'dstmac': 'ff:ff:ff:ff:ff:ff', 'header_len': 14, 'payload_len': len(arp_payload)}

    assert func(vlan_pkt) == {'dstip': '192.168.0.10', 'protocol': 17, 'srcmac': '00:00:00:00:00:02', 'tos': 0, 'vlan_pcp': 2, 'dstmac': '00:00:00:00:00:01', 'ethtype': 2048, 'srcip': '192.168.0.1', 'dstport': 68, 'srcport': 67, 'vlan_id': 1365, 'header_len': 14, 'payload_len': len(vlan_payload)}

def test_empty_raw_packet():
    from pyretic.core.packet import build_empty_packet

    q = build_empty_packet(2048, 17)
    assert udp.udp in q
    assert ipv4.ipv4 in q

def test_processor_unpacking():
    pro = Processor().compile()
    func = pro.pack

    res = func({'dstip': '192.168.0.10', 'protocol': 17, 'srcmac': '00:00:00:00:00:02', 'tos': 0, 'dstmac': '00:00:00:00:00:01', 'ethtype': 2048, 'srcip': '192.168.0.1', 'dstport': 68, 'srcport': 67, 'raw': udp_payload, 'vlan_id': 1365, 'vlan_pcp': 2})

    pkt = packet.Packet(res)

    assert vlan.vlan in pkt
    assert res == vlan_payload

    res = func({'dstip': '192.168.0.10', 'protocol': 17, 'srcmac': '00:00:00:00:00:02', 'tos': 0, 'dstmac': '00:00:00:00:00:01', 'ethtype': 2048, 'srcip': '192.168.0.1', 'dstport': 68, 'srcport': 67, 'raw': vlan_payload})

    pkt = packet.Packet(res)

    assert not vlan.vlan in pkt
    assert res == udp_payload

