----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 04/07/2015 01:52:40 PM
-- Design Name: 
-- Module Name: p_v - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;

entity p_v is
    Generic(
        FRAME_WIDTH  : integer := 1920
    );
    Port ( aclk : in STD_LOGIC;
           resetn : in STD_LOGIC;
           valid_in : in std_logic;
           in_d : in STD_LOGIC_VECTOR (15 downto 0);
           in_s : in STD_LOGIC_VECTOR (15 downto 0);
           out_d : out STD_LOGIC_VECTOR (15 downto 0);
           out_s : out STD_LOGIC_VECTOR (15 downto 0));
end p_v;

architecture Behavioral of p_v is

constant WIDTH    : integer := (FRAME_WIDTH+4)/2;

type array_linex16b is array (0 to WIDTH-1) of std_logic_vector(15 downto 0);

signal ram : array_linex16b := (others => (others =>'0'));
signal ram_buff : std_logic_vector(15 downto 0) := (others =>'0');
signal buff_s : std_logic_vector(15 downto 0) := (others =>'0');

signal index : integer range 0 to WIDTH-1 := 0;

begin

sync: process(aclk)
    variable temp: std_logic_vector(16 downto 0);
begin
    if aclk'event and aclk= '1' then
        if resetn = '0' then
            index <= 0;
        elsif valid_in = '1' then   
            temp := (in_s(15) & in_s) + buff_s;
            out_d <= in_d - temp(16 downto 1);            
            out_s <= buff_s;
            buff_s <= ram_buff;
            if index = (WIDTH-1) then
                index <= 0;
            else
                index <= index + 1;
            end if;
        end if;
    end if;
end process;

bram: process(aclk)
begin
    if(aclk'event and aclk = '1') then
        if(valid_in = '1') then
            ram(index) <= in_s;
        end if;                    
        ram_buff <= ram(index);
    end if;
end process;

end Behavioral;
