----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 04/07/2015 12:14:16 PM
-- Design Name: 
-- Module Name: pred - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;

entity p_h is
    Port ( aclk     : in STD_LOGIC;
           resetn   : in STD_LOGIC;
           valid_in : in std_logic;
           in_d     : in STD_LOGIC_VECTOR (15 downto 0);
           in_s     : in STD_LOGIC_VECTOR (15 downto 0);
           out_d    : out STD_LOGIC_VECTOR (15 downto 0);
           out_s    : out STD_LOGIC_VECTOR (15 downto 0));
end p_h;

architecture Behavioral of p_h is

signal buff_s : std_logic_vector(15 downto 0) := X"0000";

begin

sync: process(aclk)
    variable temp: std_logic_vector(16 downto 0);
begin
    if aclk'event and aclk= '1' then
        if valid_in = '1' then
            temp := (in_s(15) & in_s) + buff_s;
            out_d <= in_d - temp(16 downto 1);            
            out_s <= buff_s;
            buff_s  <= in_s;
        end if;
    end if;
end process;

end Behavioral;
