----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 03/27/2015 06:12:17 PM
-- Design Name: 
-- Module Name: kernel - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_SIGNED.ALL;


entity kernel2 is
    Generic(
       FRAME_WIDTH  : integer := 3840
   );
    Port ( 
    
        aclk : in STD_LOGIC;
        resetn : in STD_LOGIC;
        
        in_00  : in std_logic_vector(15 downto 0);
        in_01  : in std_logic_vector(15 downto 0);
        in_10  : in std_logic_vector(15 downto 0);
        in_11  : in std_logic_vector(15 downto 0);
        in_valid   : std_logic;
        
        out_00  : out std_logic_vector(15 downto 0);
        out_01  : out std_logic_vector(15 downto 0);
        out_10  : out std_logic_vector(15 downto 0);
        out_11  : out std_logic_vector(15 downto 0);
        out_valid  : out std_logic   
           
           );
end kernel2;

architecture Behavioral of kernel2 is


component H2 is
    Port ( 
        aclk     : in STD_LOGIC;
        resetn   : in STD_LOGIC;
        valid_in : in std_logic;
        in_d     : in STD_LOGIC_VECTOR (15 downto 0);
        in_s     : in STD_LOGIC_VECTOR (15 downto 0);
        out_d    : out STD_LOGIC_VECTOR (15 downto 0);
        out_s    : out STD_LOGIC_VECTOR (15 downto 0)       
       );
end component;

component V2 is
    Generic(
       FRAME_WIDTH  : integer := 1920
    );
    Port ( 
        aclk     : in STD_LOGIC;
        resetn   : in STD_LOGIC;
        valid_in : in std_logic;
        in_d     : in STD_LOGIC_VECTOR (15 downto 0);
        in_s     : in STD_LOGIC_VECTOR (15 downto 0);
        out_d    : out STD_LOGIC_VECTOR (15 downto 0);
        out_s    : out STD_LOGIC_VECTOR (15 downto 0)       
       );
end component;


-----------------------------------------------------------------------

type array_4x16b is array (3 downto 0) of std_logic_vector(15 downto 0);

signal input    : array_4x16b;
signal horiz    : array_4x16b;
signal verti    : array_4x16b;


signal next_valid_in    : std_logic_vector(1 downto 1);

begin

sync: process(aclk)
begin
    if aclk'event and aclk = '1' then
        next_valid_in(1) <= in_valid;
        out_valid <= next_valid_in(1);
    end if;
end process;

input(0) <= in_00;
input(1) <= in_01;
input(2) <= in_10;
input(3) <= in_11;

out_00  <= verti(0);
out_01  <= verti(1);
out_10  <= verti(2);
out_11  <= verti(3);

H2_map: H2 Port map( 
        aclk     => aclk,
        resetn   => resetn,
        valid_in => in_valid,
        in_d     => input(0),
        in_s     => input(1),
        out_d    => horiz(0),
        out_s    => horiz(1)   
       );
       
H2_map2: H2 Port map( 
       aclk     => aclk,
       resetn   => resetn,
       valid_in => in_valid,
       in_d     => input(2),
       in_s     => input(3),
       out_d    => horiz(2),
       out_s    => horiz(3)   
      );
      
V2_map: V2 
generic map(
    FRAME_WIDTH => FRAME_WIDTH
)
Port map( 
      aclk     => aclk,
      resetn   => resetn,
      valid_in => next_valid_in(1),
      in_d     => horiz(0),
      in_s     => horiz(2),
      out_d    => verti(0),
      out_s    => verti(2)   
     );
     
V2_map2: V2 
generic map(
    FRAME_WIDTH => FRAME_WIDTH
)
Port map( 
     aclk     => aclk,
     resetn   => resetn,
     valid_in => next_valid_in(1),
     in_d     => horiz(1),
     in_s     => horiz(3),
     out_d    => verti(1),
     out_s    => verti(3)   
    );

end Behavioral;
