%%%
% Simple test of our method using 9 lines.
%%%

startup;

%% GROUND TRUTH camera pose for the below 9 lines
% camera position: x:5.4114 y:5.0692 z:-23.875
camX_GT =   5.4114;
camY_GT =   5.0692;
camZ_GT = -23.8750;
t_GT = getTranslationVector(camX_GT, camY_GT, camZ_GT);

% camera orientation: alfa:-2.8405 beta:0 gamma:-0.81804 [rad]
camRotX_GT = -2.8405;
camRotY_GT =  0;
camRotZ_GT = -0.81804;
R_GT = getRotationMatrix(camRotX_GT, camRotY_GT, camRotZ_GT);

%% INPUT

line3DEndPts = [ ...
	-0.20515		-2.6821			-1.0371 		1; ...
	 2.0508			 0.58559		 2.5663 		1; ...
	 4.9548			 4.6243			 0.35067		1; ...
	 4.6387			-3.8437			-4.4855 		1; ...
	-1.9565			 0.80192		 0.30964		1; ...
	 4.0121			 0.4055			-0.68019		1; ...
	 0.42667		 2.1241			-4.8333 		1; ...
	 3.0092			-3.5749			-0.21526		1; ...
	-2.4316			-1.3091			 1.6176 		1; ...
	-3.3039			-2.2122			-3.0178 		1; ...
	-3.0493			-1.7316			 3.8034 		1; ...
	-0.28898		-0.96031		-3.2077 		1; ...
	 4.6892			-0.92544		 3.4449 		1; ...
	 1.1533			-1.2339			 3.7718 		1; ...
	 2.8485			-0.35046		 3.1398 		1; ...
	 3.9844			-0.70761		-1.6567 		1; ...
	 0.96647		 4.0199			 2.0207 		1; ...
	-1.2254			 2.3496			 4.541  		1 ...
]';

line2DEndPts = [...
	-0.073874			-0.089508		1; ...
	-0.036249			 0.095685		1; ...
	-0.00053754		 0.28196		1; ...
	-0.29165			-0.029618		1; ...
	 0.075238			-0.029277		1; ...
	-0.10457			 0.12219		1; ...
	 0.063366			 0.012622		1; ...
	-0.18764			-0.012086		1; ...
	 0.025864			-0.075711		1; ...
	 0.027674			-0.19939		1; ...
	 0.027693			-0.071778		1; ...
	-0.022676			-0.080192		1; ...
	-0.14133			 0.13421		1; ...
	-0.059048			 0.039048		1; ...
	-0.080253			 0.097904		1; ...
	-0.14276			 0.080341		1; ...
	 0.087743			 0.15045		1; ...
	 0.087638			 0.069587		1 ...
]';

%% CAMERA POSE ESTIMATION
[R_estim, t_estim] = linePoseEstim( line3DEndPts, line2DEndPts );

%% OUTPUT COMPARISON
disp('Ground truth [R|t]');
disp([R_GT    t_GT   ]);

disp('Estimated pose [R|t]');
disp([R_estim t_estim]);
