/*
*3DSMAX_ASCIIEXPORT	200
*COMMENT "AsciiExport Version  2,00 - Mon May 07 01:36:29 2007"
*SCENE {
	*SCENE_FILENAME "island_palm.max"
	*SCENE_FIRSTFRAME 0
	*SCENE_LASTFRAME 100
	*SCENE_FRAMESPEED 30
	*SCENE_TICKSPERFRAME 160
	*SCENE_BACKGROUND_STATIC 0.000	0.000	0.000
	*SCENE_AMBIENT_STATIC 0.745	0.745	0.745
}
*/

// light @ -82.657,	62.696,	225.598

#include "../UberLame_src/gles2/GLES20Emu.h"
#include "../UberLame_src/gles2/Shader.h"
#include "../UberLame_src/gles2/BufferObjects.h"
#include "../UberLame_src/gles2/Texture.h"
#include "../UberLame_src/gles2/TextureUtil.h"
#include "../UberLame_src/Vector.h"
#include "../UberLame_src/lml/PolyMesh.h"

class CGLIslandScene {
public:
	struct TGLIslandShader : public CGLESShader {
		int n_mvp_uniform;
		int n_texture_uniform;

		bool Compile()
		{
			const char *p_s_vertex_shader =
				"precision mediump float;\n"
				"\n"
				"attribute vec3 v_pos;\n"
				"attribute vec2 v_tex;\n"
				"\n"
				"uniform mat4 t_mvp;\n"
				"\n"
				"varying vec2 v_texcoord;\n"
				"varying vec3 v_position;\n"
				"\n"
				"void main()\n"
				"{\n"
				"	gl_Position = t_mvp * vec4(v_position = v_pos, 1.0);\n"
				"	v_texcoord = v_tex;\n"
				"}\n";

			const char *p_s_fragment_shader =
				"precision mediump float;\n"
				"\n"
				"varying vec2 v_texcoord;\n"
				"varying vec3 v_position;\n"
				"\n"
				"uniform sampler2D n_tex;\n"
				"\n"
				"void main()\n"
				"{\n"
				"    float y = v_position.y;\n"
				"    gl_FragColor = mix(texture2D(n_tex, v_texcoord), vec4(.12, .2, .5, 1.0),\n"
				"        smoothstep(.1, 30.0, -y));\n" // simulate depth of water (simple fog)
				//"    gl_FragColor = texture2D(n_tex, v_texcoord);\n"
				"}\n";

			const char *p_s_config =
				"vertex {\n"
				"	v_pos: 0;\n"
				"	v_tex: 1;\n"
				"}\n";

			std::string p_log[3];
			if(!CGLESShader::CompileConfigureLink(p_s_vertex_shader, p_s_fragment_shader, p_s_config,
			   p_log[0], p_log[1], p_log[2], true))
				return false;

			n_mvp_uniform = n_Get_Uniform_Location("t_mvp");
			n_texture_uniform = n_Get_Uniform_Location("n_tex");

			CGLESShader::Bind();
			Uniform1i(n_texture_uniform, 0);

			return true;
		}

		void Bind(const Matrix4f &r_t_mvp)
		{
			CGLESShader::Bind();
			UniformMatrix4fv(n_mvp_uniform, 1, false, &r_t_mvp[0][0]);
		}
	};

	struct TGLIslandUnderWaterShader : public CGLESShader {
		int n_mvp_uniform, n_mv_uniform;
		int n_texture_uniform;

		bool Compile()
		{
			const char *p_s_vertex_shader =
				"precision mediump float;\n"
				"\n"
				"attribute vec3 v_pos;\n"
				"attribute vec2 v_tex;\n"
				"\n"
				"uniform mat4 t_mvp, t_mv;\n"
				"\n"
				"varying vec2 v_texcoord;\n"
				"varying vec4 v_view_, v_pos_;\n"
				"\n"
				"void main()\n"
				"{\n"
				"    gl_Position = t_mvp * (v_pos_ = vec4(v_pos, 1.0));\n"
				"    v_texcoord = v_tex;\n"
				"    v_view_ = -(t_mv * vec4(v_pos, 1.0));\n" // eyespace view vector (camera is at origin)
				"}\n";

			const char *p_s_fragment_shader =
				"precision mediump float;\n"
				"\n"
				"varying vec2 v_texcoord;\n"
				"varying vec4 v_view_, v_pos_;\n"
				"\n"
				"uniform sampler2D n_tex;\n"
				"\n"
				"void main()\n"
				"{\n"
				"    vec3 v_view = v_view_.xyz / v_view_.w;\n"
				"    float y = v_pos_.y;\n"
				"    gl_FragColor = mix(texture2D(n_tex, v_texcoord), vec4(.12, .2, .5, 1.0),\n"
				"        step(y, .01) * smoothstep(.1, 30.0, length(v_view)));\n" // simulate view distance underwater (simple fog)
				"}\n";

			const char *p_s_config =
				"vertex {\n"
				"	v_pos: 0;\n"
				"	v_tex: 1;\n"
				"}\n";

			std::string p_log[3];
			if(!CGLESShader::CompileConfigureLink(p_s_vertex_shader, p_s_fragment_shader, p_s_config,
			   p_log[0], p_log[1], p_log[2], true))
				return false;

			n_mvp_uniform = n_Get_Uniform_Location("t_mvp");
			n_mv_uniform = n_Get_Uniform_Location("t_mv");
			n_texture_uniform = n_Get_Uniform_Location("n_tex");

			CGLESShader::Bind();
			Uniform1i(n_texture_uniform, 0);

			return true;
		}

		void Bind(const Matrix4f &r_t_mvp, const Matrix4f &r_t_mv)
		{
			CGLESShader::Bind();
			UniformMatrix4fv(n_mvp_uniform, 1, false, &r_t_mvp[0][0]);
			UniformMatrix4fv(n_mv_uniform, 1, false, &r_t_mv[0][0]);
		}
	};

protected:
	CGLArrayBufferObject m_vertex_buffer;
	CGLElementArrayBufferObject m_index_buffer;
	CGLVertexArrayObject m_vao;
	size_t m_n_index_num;
	TGLIslandShader m_shader;
	TGLIslandUnderWaterShader m_uw_shader;
	CGLTexture_2D_Loadable<false> m_texture;

public:
	CGLIslandScene();

	bool b_Status() const
	{
		return m_vao.b_Status() && m_vertex_buffer.b_Status() &&
			m_index_buffer.b_Status() && m_n_index_num;
	}

	void Draw(const Matrix4f &r_t_mvp)
	{
		m_texture.Bind();
		m_shader.Bind(r_t_mvp);
		m_vao.Bind();
		glDrawElements(GL_TRIANGLES, m_n_index_num, GL_UNSIGNED_INT, m_index_buffer.p_OffsetPointer(0));
		CGLVertexArrayObject::Release();
	}

	void Draw_UW(const Matrix4f &r_t_mvp, const Matrix4f &r_t_mv)
	{
		m_texture.Bind();
		m_uw_shader.Bind(r_t_mvp, r_t_mv);
		m_vao.Bind();
		glDrawElements(GL_TRIANGLES, m_n_index_num, GL_UNSIGNED_INT, m_index_buffer.p_OffsetPointer(0));
		CGLVertexArrayObject::Release();
	}
};
