#include "../UberLame_src/CallStack.h"
#include "../UberLame_src/NewFix.h"
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <signal.h>
#include <stdio.h>
#include <math.h>
#include <vector>
#if defined(_WIN32) || defined(_WIN64)
#include "ftd2xx.h"
#else // _WIN32 || _WIN64
#include "ftd2xx_linux.h"
#endif // _WIN32 || _WIN64
#include "../UberLame_src/MinMax.h"
#include "../UberLame_src/Base64.h"
#include "../UberLame_src/Dir.h" // PRIsizeB
#include "../UberLame_src/UniConv.h"

static bool b_quit = false;

void SigInt_Handler(int n_signal)
{
	printf("\ninterrupted\n");
	b_quit = true;
}

#if !defined(_WIN32) && !defined(_WIN64)
#include <time.h>
void Sleep(int n_milliseconds)
{
	struct timespec tim;
	tim.tv_sec = n_milliseconds / 1000;
	tim.tv_nsec = (n_milliseconds % 1000) * 1000000;
	nanosleep(&tim, 0);
}
#endif // !_WIN32 && !_WIN64

#include "NMEA.h"
#include "SIRF_Binary.h"

#if defined(_MSC_VER) && !defined(__MWERKS__)
#if defined(_M_X64) || defined(_M_AMD64) || defined(_M_IA64) || defined(__x86_64) || defined(__amd64) || defined(__ia64)
#pragma comment(lib, "ftd2xx_x64.lib")
#else // _M_X64 || _M_AMD64 || _M_IA64 || __x86_64 || __amd64 || __ia64
#pragma comment(lib, "ftd2xx.lib")
#endif // _M_X64 || _M_AMD64 || _M_IA64 || __x86_64 || __amd64 || __ia64
// tell the compiler about the .lib in windows
#endif // _MSC_VER && !__MWERKS__

template <class CProtocolSanitizer>
class CBaudRateNegotiator {
public:
	int n_chosen_bit_num;
	int n_chosen_stop_bit_num;
	int n_chosen_parity;
	int n_chosen_baud_rate;
	const bool b_verbose;

public:
	inline CBaudRateNegotiator(bool _b_verbose)
		:n_chosen_bit_num(-1), n_chosen_stop_bit_num(-1),
		n_chosen_parity(-1), n_chosen_baud_rate(-1), b_verbose(_b_verbose)
	{}

	bool operator ()(FT_HANDLE h_device, int n_guess_baudrate = 0)
	{
		static const int p_baudrate_list[] = {57600, 38400, 4800, // more likely
			9600, 14400, 19200, 115200, 230400, 460800, 921600, 300, 600, 1200, 2400}; // less likely baudrates
		const size_t n_baudrate_num = sizeof(p_baudrate_list) / sizeof(p_baudrate_list[0]);
		static const int p_bit_num_list[] = {8, 7}; // 8 bits more likely
		const size_t n_bit_num_num = sizeof(p_bit_num_list) / sizeof(p_bit_num_list[0]);
		static const int p_stop_bits_list[] = {FT_STOP_BITS_1, FT_STOP_BITS_2};
		const size_t n_stop_bits_num = sizeof(p_stop_bits_list) / sizeof(p_stop_bits_list[0]);
		static const int p_parity_list[] = {FT_PARITY_NONE, FT_PARITY_ODD, FT_PARITY_EVEN};
		const size_t n_parity_num = sizeof(p_parity_list) / sizeof(p_parity_list[0]);

		for(size_t n_bits_idx = 0; n_bits_idx < n_bit_num_num; ++ n_bits_idx) {
			const int n_bit_num = p_bit_num_list[n_bits_idx];
			for(size_t n_stop_bits_idx = 0; n_stop_bits_idx < n_stop_bits_num; ++ n_stop_bits_idx) {
				const int n_stop_bits = p_stop_bits_list[n_stop_bits_idx]; // enum
				const int n_stop_bit_num = (n_stop_bits == FT_STOP_BITS_1)? 1 : 2;
				for(size_t n_parity_idx = 0; n_parity_idx < n_parity_num; ++ n_parity_idx) {
					const int n_parity = p_parity_list[n_parity_idx];
					for(size_t n_baudrate_idx = (n_guess_baudrate > 0)? size_t(-1) : 0;
					   n_baudrate_idx != n_baudrate_num; ++ n_baudrate_idx) {
						const int n_baud_rate = (n_baudrate_idx == size_t(-1))? n_guess_baudrate :
							p_baudrate_list[n_baudrate_idx];

						if(b_verbose) {
							printf("debug: trying %d baud, %d bits, %d stop bits, %s parity\n",
								n_baud_rate, n_bit_num, n_stop_bit_num, (n_parity == FT_PARITY_NONE)?
								"no" : (n_parity == FT_PARITY_ODD)? "odd" : "even");
						}
						// debug - print what we do now

						FT_STATUS n_result;
						n_result = FT_ResetDevice(h_device);
						n_result = FT_SetTimeouts(h_device, 1100, 1100); // set 1.1 sec timeout
						n_result = FT_SetBaudRate(h_device, n_baud_rate); // set default GPS baud rate
						n_result = FT_SetDataCharacteristics(h_device, n_bit_num, n_stop_bits, n_parity);
						n_result = FT_SetFlowControl(h_device, FT_FLOW_NONE, 0, 0);
						n_result = FT_Purge(h_device, FT_PURGE_RX | FT_PURGE_TX);
						// set the serial port

						if(CProtocolSanitizer::b_Validate(h_device, n_baud_rate,
						   n_bit_num, n_stop_bit_num, n_parity)) {
							n_chosen_baud_rate = n_baud_rate;
							n_chosen_bit_num = n_bit_num;
							n_chosen_stop_bit_num = n_stop_bit_num;
							n_chosen_parity = n_parity;

							return true;
						}
						// see if this works
					}
				}
			}
		}

		return false;
	}
};

void PrintHelp()
{
	printf("gps_recorder [-h|--help] [--verbose|-v|--quiet|-q]\n"
		"\t[--device|-d <device-index>] [--binary-log|-bl <logfile.xml>]\n");
}

int main(int n_arg_num, const char **p_arg_list)
{
	/*setlocale(LC_ALL, "");
	//wprintf(L"about to wide ... (sizeof wchar_t is %d)\n", int(sizeof(wchar_t)));
	printf("about to ...\n");
	std::string s_latlon;
	std::basic_string<wchar_t> s_latlon_w;
	stl_ut::FormatW(s_latlon_w, L"lat: %02d\xB0%02d\x2032%06.3f\x2033%c, lon: %02d\xB0%02d\x2032%06.3f\x2033%c", // avoid xml argument delimiters
	//stl_ut::FormatW(s_latlon_w, L"lat: %02d-%02d-%06.3f-%c, lon: %02d-%02d-%06.3f-%c", // avoid xml argument delimiters
		1, 2, 3.14, L'A', 1, 2, 3.14, L'S');
	//stl_ut::FormatW(s_latlon_w, L"lat: %02d-%02d-%06.3f-%s, lon: %02d-%02d-%06.3f-%s", // avoid xml argument delimiters
	//	1, 2, 3.14, L"A", 1, 2, 3.14, L"S");
	//stl_ut::FormatW(s_latlon_w, L"lat: %02d-%02d-%06.3f-, lon: %02d-%02d-%06.3f-", // avoid xml argument delimiters
	//	1, 2, 3.14, 1, 2, 3.14);
	if(sizeof(wchar_t) == 2)
		CUniConv::n_UTF16_to_UTF8(s_latlon_w.data(),
			s_latlon_w.length() * sizeof(wchar_t), s_latlon, false, false);
	else if(sizeof(wchar_t) == 4) {
		bool bfail = !CUniConv::UTF32_to_UTF8((const int*)s_latlon_w.data(),
			s_latlon_w.length() * sizeof(wchar_t), false, true, s_latlon, false);
		if(bfail)
			fprintf(stderr, "fail in encoding\n");
	}
	//wprintf(L"direct wide lat: %02d-%02d-%06.3f-%c, lon: %02d-%02d-%06.3f-%c\n", // avoid xml argument delimiters
	//	1, 2, 3.14, L'A', 1, 2, 3.14, L'S');
	//wprintf(L"wide %s\n", s_latlon_w.c_str());
	printf("%s\n", s_latlon.c_str());
	exit(0);*/
							
	bool b_verbose = true;
	int n_device = 0;
	const char *p_s_binary_logfile = 0;

	for(int i = 1; i < n_arg_num; ++ i) {
		if(!strcmp(p_arg_list[i], "--help") || !strcmp(p_arg_list[i], "-h")) {
			PrintHelp();
			return 0;
		} else if(!strcmp(p_arg_list[i], "--verbose") || !strcmp(p_arg_list[i], "-v"))
			b_verbose = true;
		else if(!strcmp(p_arg_list[i], "--quiet") || !strcmp(p_arg_list[i], "-q"))
			b_verbose = false;
		else if(i + 1 == n_arg_num) {
			fprintf(stderr, "error: argument \'%s\': missing value or an unknown argument\n", p_arg_list[i]);
			return -1;
		} else if(!strcmp(p_arg_list[i], "--device") || !strcmp(p_arg_list[i], "-d"))
			n_device = atol(p_arg_list[++ i]);
		else if(!strcmp(p_arg_list[i], "--binary-log") || !strcmp(p_arg_list[i], "-bl"))
			p_s_binary_logfile = p_arg_list[++ i];
		else {
			fprintf(stderr, "error: argument \'%s\': an unknown argument\n", p_arg_list[i]);
			return -1;
		}
	}
	// "parse" cmdline

	if(p_s_binary_logfile) {
		FILE *p_fr;
		if((p_fr = fopen(p_s_binary_logfile, "r"))) {
			fprintf(stderr, "error: the specified logfile \'%s\' already exists\n", p_s_binary_logfile);
			fclose(p_fr);
			return -1;
		}
	}
	// make sure the log will not be overwritten

	FT_STATUS ftStatus;
	uint32_t numDevs;

	ftStatus = FT_ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);
	for(uint32_t i = 0; i < numDevs; ++ i) {
		char p_s_dev_name[64];
		char p_s_dev_serial[64];
		ftStatus = FT_ListDevices((void*)i, p_s_dev_name, FT_LIST_BY_INDEX | FT_OPEN_BY_DESCRIPTION);
		ftStatus = FT_ListDevices((void*)i, p_s_dev_serial, FT_LIST_BY_INDEX | FT_OPEN_BY_SERIAL_NUMBER);

		printf("found device %d: \'%s\' (serial number: %s)\n", i, p_s_dev_name, p_s_dev_serial);
	}
	// list devices

	if(!numDevs) {
		fprintf(stderr, "error: no FTD2xx compatible devices found\n");
		return -1;
	}
	if(n_device < 0 || unsigned(n_device) >= numDevs) {
		fprintf(stderr, "error: the selected device was not found\n");
		return -1;
	}
	// no devices?

	signal(SIGINT, &SigInt_Handler);
	// it runs until you press ctrl+c for termination

	FT_HANDLE h_device;
	ftStatus = FT_Open(n_device, &h_device);
#if !defined(_WIN32) && !defined(_WIN64)
	if(ftStatus != FT_OK && system("exit `sudo lsmod | grep ftdi_sio | wc -l`")) {
		fprintf(stderr, "warning: another driver is loaded ... attempting to unload it\n");
		system("sudo rmmod ftdi_sio");
		system("sudo rmmod usbserial");
		ftStatus = FT_Open(n_device, &h_device); // try to repoen
	}
#endif // !_WIN32 && !_WIN64
	if(ftStatus != FT_OK) {
		fprintf(stderr, "error: the selected device could not be opened (status %d)\n", int(ftStatus));
		return -1;
	}
	// open a device

	FILE *p_fw = 0;
	if(p_s_binary_logfile) {
		if(!(p_fw = fopen(p_s_binary_logfile, "wb"))) {
			fprintf(stderr, "error: failed to open \'%s\' for writing\n", p_s_binary_logfile);
			return -1;
		}
		fprintf(p_fw, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<sirf>\r\n");
		if(ferror(p_fw))
			fprintf(stderr, "error: i/o error while writing binary log\n");
	}
	// open file for the binary log

	/*{
		ftStatus = FT_SetBitMode(h_device, 0xf, 1); // set asynchronous bit bang // todo - would synchronous be more appropriate here?
		ftStatus = FT_SetBaudRate(h_device, 8600); // set 1 kb / sec
		ftStatus = FT_SetTimeouts(h_device, 1000, 1000); // set 1 sec timeout
		char n_byte = 0;
		DWORD n_written;
		ftStatus = FT_Write(h_device, &n_byte, 1, &n_written);

		for(int i = 0; i < 1000000; ++ i) {
			int _i = (i / 2) % 200;
			int __i = abs(_i - 100);
			char p_packet[100], *p_ptr = p_packet;
			for(int j = 0; j < 100; ++ j)
				p_packet[j] = (j < __i)? 0xff : 0; // note - this would be done better by dithering (could reach much higher switching freq on midtones)
			// make a packet

			int n_remains = 100;
			while(n_remains > 0) {
				DWORD n_written;
				ftStatus = FT_Write(handle, p_ptr, n_remains, &n_written); // might block?
				p_ptr += n_written;
				n_remains -= n_written;
			}
			// write all of it
		}
	}*/
	// simple code to blink a led

	{
		/*ftStatus = FT_ResetDevice(h_device);
		ftStatus = FT_SetTimeouts(h_device, 1100, 1100); // set 1.1 sec timeout
		ftStatus = FT_SetBaudRate(h_device, FT_BAUD_4800); // set default GPS baud rate
		ftStatus = FT_SetDataCharacteristics(h_device, FT_BITS_8, FT_STOP_BITS_1, FT_PARITY_NONE);
		ftStatus = FT_SetFlowControl(h_device, FT_FLOW_NONE, 0, 0);
		ftStatus = FT_Purge(h_device, FT_PURGE_RX | FT_PURGE_TX);

		char p_s_init[] = "$PSRF100,1,4800,8,1,0*__\r\n"; // the checksum 0C is for FT_BAUD_9600, FT_BITS_8, FT_STOP_BITS_1, FT_PARITY_NONE, 1 = odd parity, 2 = even

		{
			_ASSERTE(p_s_init[0] == '$'); // make sure there is dollar sign at the beginning
			const char *p_begin = p_s_init + 1;
			const char *p_end = strchr(p_begin, '*');
			_ASSERTE(p_end && p_end > p_begin); // make sure there is the asterisk
			uint8_t n_parity = 0;
			for(; p_begin != p_end; ++ p_begin) {
				uint8_t n_char = *p_begin;
				n_parity ^= n_char;
			}
			char p_s_parity[3];
			_ASSERTE(int(n_parity) >= 0 && int(n_parity) < 0xff); // make sure it fits in two places
			sprintf(p_s_parity, "%02X", int(n_parity));
			char *p_dest = (char*)p_end + 1;
			_ASSERTE(p_dest[0] == '_' && p_dest[1] == '_' && p_dest[2] == '\r' &&
				p_dest[3] == '\n'); // make sure there is space left out for the parity at the end
			p_dest[0] = p_s_parity[0];
			p_dest[1] = p_s_parity[1];
		}
		// calculate parity for the message

		DWORD n_written;
		ftStatus = FT_Write(h_device, p_s_init, strlen(p_s_init) * sizeof(char), &n_written);*/

		/*{
			CBaudRateNegotiator<CNMEAProtocolSanitizer> negotiate_baudrate;
			negotiate_baudrate(h_device);
			// set baud-rate that the GPS is using, switch to NMEA

			for(int i = 0; i < 1000; ++ i) {
				char p_s_buffer[1024] = {0};
				DWORD n_read;
				FT_Read(h_device, p_s_buffer, sizeof(p_s_buffer) - sizeof(char), &n_read);
				if(!n_read) {
					printf("nothing read\r");
					continue;
				}
				printf("read \'%s\' \n", p_s_buffer);
				// note that buffer concatenation was not implemented here
			}
		}*/
		// simple NMEA demo

		{
			CBaudRateNegotiator<CSIRFProtocolSanitizer> negotiate_baudrate(b_verbose);
			negotiate_baudrate(h_device);
			// set baud-rate that the GPS is using, switch to SIRF

			SIRF_InitializeDataSource(h_device, reset_ClearEphemeris | reset_EnableNavLib | reset_EnableDebug);
			// want to receive all navlib messages

			SIRF_SetMessageRate(h_device, 0x1C, 1); // 0x1C (28) - Navigation Library Measurement Data
			SIRF_SetMessageRate(h_device, 0x1E, 1); // 0x1E (30) - Navigation Library SV State Data
			// SIRF set message rate

			const int n_desired_rate = 38400;//115200;
			if(negotiate_baudrate.n_chosen_baud_rate < n_desired_rate) {
				if(b_verbose)
					printf("debug: have SIRF\n");

				SIRF_ConfigureUART0(h_device, n_desired_rate);
				// switch to go really fast

				Sleep(2000);
				// wait for it to process that

				negotiate_baudrate(h_device, n_desired_rate);
				// renegotiate
			}

			if(b_verbose) {
				printf("debug: have SIRF with navlib, " PRIsizeB "B/sec\n",
					PRIsizeBparams(negotiate_baudrate.n_chosen_baud_rate));
			}

			std::vector<uint8_t> message_buffer;
			message_buffer.reserve(256);
			// reserve .25k message buffer (initially empty)

			std::string s_sideband, s_base64;

			while(!b_quit) { // until ctrl+c is pressed
				size_t n_size = message_buffer.size();
				message_buffer.resize(n_size + 128);
				// get .125k more space

				{
					DWORD n_read;
					uint8_t *p_dest = (uint8_t*)&message_buffer[0] + n_size;
					FT_STATUS n_result = FT_Read(h_device, p_dest, DWORD(message_buffer.size() - n_size), &n_read);
					n_size += n_read;
					//printf("debug: read %d B\n", int(n_read));
				}
				// read some more data

				message_buffer.resize(n_size);
				// contract the buffer

				if(message_buffer.empty())
					continue;
				// make sure there is something in the buffer

				const uint8_t *p_start_marker = &message_buffer.front(), *p_end = &message_buffer.back() + 1;
				while(p_start_marker = p_Find_SIRF_MessageStartMarker(p_start_marker, p_end)) {
					//printf("debug: found start marker at B %d\n", int(p_start_marker - &message_buffer.front()));

					uint16_t n_lenght;
					if(!b_Validate_SIRF_Message(n_lenght, p_start_marker, p_end)) {
						++ p_start_marker;
						//printf("debug: not a valid SIRF packet\n");
						continue;
					}
					// validate the message (checks markers, recalculates checksum)

					//printf("debug: found a valid SIRF packet\n");

					size_t n_offset = p_start_marker - &message_buffer.front();
					if(n_offset)
						fprintf(stderr, "warning: dropped %d B\n", int(n_offset));
					// see if there is an offset (means that there are unknown data between messages)

					uint16_t n_message_id = p_start_marker[4];//n_SIRF_GetWord(p_start_marker + 2, p_end);

					s_sideband.clear();
					if(n_message_id == 0x29) {
						const uint8_t *p_payload = p_start_marker + 4;
						int n_solution_invalid = n_SIRF_GetShort(p_payload + 1);
						int n_utc_year = n_SIRF_GetShort(p_payload + 11);
						int n_utc_month = *(p_payload + 13);
						int n_utc_day = *(p_payload + 14);
						int n_utc_hour = *(p_payload + 15);
						int n_utc_minute = *(p_payload + 16);
						int n_utc_millisecond = n_SIRF_GetShort(p_payload + 17);
						int32_t n_latitude = n_SIRF_GetInt(p_payload + 23); // x 10^7
						int32_t n_longitude = n_SIRF_GetInt(p_payload + 27); // x 10^7
						double f_latitude = n_latitude * 1e-7;
						double f_longitude = n_longitude * 1e-7;

						std::string s_latlon;
						std::basic_string<wchar_t> s_latlon_w;
						stl_ut::FormatW(s_latlon_w, L"lat: %02d\xB0%02d\x2032%06.3f\x2033%c, lon: %02d\xB0%02d\x2032%06.3f\x2033%c", // avoid xml argument delimiters
						//stl_ut::FormatW(s_latlon_w, L"lat: %02d-%02d-%06.3f-%s, lon: %02d-%02d-%06.3f-%s", // avoid xml argument delimiters
							int(floor(fabs(f_latitude))), int(floor(fmod(fabs(f_latitude * 60), 60))),
							fmod(fabs(f_latitude * 3600), 60), (f_latitude > 0)? L'N' : L'S',
							int(floor(fabs(f_longitude))), int(floor(fmod(fabs(f_longitude * 60), 60))),
							fmod(fabs(f_longitude * 3600), 60), (f_longitude > 0)? L'E' : L'W');
						CUniConv::n_UTF16_to_UTF8(s_latlon_w.data(),
							s_latlon_w.length() * sizeof(wchar_t), s_latlon, false, false);
							
						if(sizeof(wchar_t) == 2) {
							CUniConv::n_UTF16_to_UTF8(s_latlon_w.data(),
								s_latlon_w.length() * sizeof(wchar_t), s_latlon, false, false);
						} else if(sizeof(wchar_t) == 4) {
							CUniConv::UTF32_to_UTF8((const int*)s_latlon_w.data(),
								s_latlon_w.length() * sizeof(wchar_t), false, true, s_latlon, false);
						}
						// convert latlon to a nice string

						stl_ut::Format(s_sideband, "geodesic navigation data (invalid: %d, utc:"
							" %04d-%02d-%02dT%02d:%02d:%06.3f, %s)", n_solution_invalid, n_utc_year,
							n_utc_month, n_utc_day, n_utc_hour, n_utc_minute, n_utc_millisecond * 1e-3,
							s_latlon.c_str());
					} else if(n_message_id == 0x1C) {
						const uint8_t *p_payload = p_start_marker + 4;
						stl_ut::Format(s_sideband, "measurement data (channel: %d, satellite: %d, time tag: %d, time %g)",
							int(p_payload[1]), int(p_payload[6]), n_SIRF_GetInt(p_payload + 2),
							f_SIRF_GetDouble(p_payload + 7));
					} else if(n_message_id == 0x1E) {
						const uint8_t *p_payload = p_start_marker + 4;
						stl_ut::Format(s_sideband, "sv state data (satellite: %d, time %g, x: %g, y: %g, z: %g)",
							int(p_payload[1]), f_SIRF_GetDouble(p_payload + 2), f_SIRF_GetDouble(p_payload + 10),
							f_SIRF_GetDouble(p_payload + 18), f_SIRF_GetDouble(p_payload + 26));
					} else if(n_message_id == 0x04) {
						const uint8_t *p_payload = p_start_marker + 4;
						int n_time_of_week = n_SIRF_GetInt(p_payload + 3);
						int n_channel_num = p_payload[7];
						for(int i = 0; i < n_channel_num; ++ i) {
							const uint8_t *p_chan_data = p_payload + 8 + 15 * i;
							int n_SV_id = p_chan_data[0];
							float f_azimuth = p_chan_data[1] * 2.0f / 3;
							float f_elevation = p_chan_data[2] * 2.0f;
							int n_state = n_SIRF_GetShort(p_chan_data + 3);
							int C_N0_1 = p_chan_data[5]; // dB
							if(!C_N0_1)
								continue; // skip some fields
							stl_ut::Format(s_sideband, "tracker data (satellite: %d, time: %d, azimuth: %.2f deg,"
								" elevation: %.2f deg, state: 0x%04x, C/N0 1: %d dB)", n_SV_id,
								n_time_of_week / 100, f_azimuth, f_elevation, n_state, C_N0_1);
						}
					} else {
						if(b_verbose) {
							printf("received SIRF message 0x%02x (%d), payload %d bytes\n",
								int(n_message_id), int(n_message_id), int(n_lenght));
						}
						// say what kind of message was received
					}
					if(!s_sideband.empty())
						printf("debug: have %s\n", s_sideband.c_str());
					// see if we get measurement data

					if(p_fw) {
						CBase64::Encode(s_base64, int(n_lenght) + 8, p_start_marker);
						if(s_sideband.empty()) {
							fprintf(p_fw, "\t<packet id=\"0x%02x\" payload=\"%d\">%s</packet>\r\n",
								int(n_message_id), int(n_lenght), s_base64.c_str());
						} else {
							fprintf(p_fw, "\t<packet id=\"0x%02x\" payload=\"%d\" annotation=\"%s\">%s</packet>\r\n",
								int(n_message_id), int(n_lenght), s_sideband.c_str(), s_base64.c_str());
						}
						if(ferror(p_fw))
							fprintf(stderr, "error: i/o error while writing binary log\n");
					}
					// log received messages

					n_offset += n_lenght + 8; // include message payload + headers size
					message_buffer.erase(message_buffer.begin(), message_buffer.begin() + n_offset);
					// erase parsed data from the buffer

					if(message_buffer.empty())
						break;
					p_start_marker = &message_buffer.front();
					p_end = &message_buffer.back() + 1;
					// renew start / end pointers
				}
				// parse received messages

				if(message_buffer.size() > 16384) {
					fprintf(stderr, "warning: unable to synchronize SIRF packet "
						"in %d B: flushing the buffer\n", int(message_buffer.size()));
					message_buffer.clear();
				}
				// no messages? don't allocate memory forever
			}
			// receive some SIRF messages, does buffer concatenation (no message is dropped)

			if(b_verbose)
				printf("debug: buffer capacity %d B\n", int(message_buffer.capacity()));
		}
	}

	if(p_fw) {
		fprintf(p_fw, "</sirf>\r\n");
		if(ferror(p_fw))
			fprintf(stderr, "error: i/o error while writing binary log\n");
		fclose(p_fw);
	}

	FT_Close(h_device);

	return 0;
}
