////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 3.0
//  \   \         Application : 7 Series FPGAs Transceivers Wizard 
//  /   /         Filename : gtz_caui4_v3_0_rx_startup_fsm.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module gtz_caui4_v3_0_rx_startup_fsm
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`timescale 1ns / 1ps
`define DLY #1


//***********************************Entity Declaration************************
(* CORE_GENERATION_INFO = "gtz_caui4_v3_0,gtwizard_v3_0,{protocol_file=Start_from_scratch}" *)
module gtz_caui4_v3_0_rx_startup_fsm (
				     input  SYSCLK_IN,
				     input  RESET_IN,
				     input  RXRDY_IN,
				     input  RXRESETDONE_IN,
				     input  MMCM_LOCKED,
				     input  CTLE_TUNING_DONE_IN,
				     input  DATA_OK_IN, // Receive data are valid
				     output reg GTRXRESET_OUT,
				     output reg RXFIBRESET_OUT,
				     output reg RESETFSMDONE_OUT,
				     output reg CTLE_EN_OUT, // Enable CTLE tunning
				     output reg CTLE_INIT_OUT, 
				     output reg [7:0] fsm_state
				     );


   localparam [9:0]
     INIT_S                  = 10'b0000000001,
     ASSERT_RXRESET_S        = 10'b0000000010,
     WAIT_MMCM_S             = 10'b0000000100,     
     WAIT_RXRDY_S            = 10'b0000001000,
     WAIT_RXRESETDONE_S      = 10'b0000010000,
     START_CTLE_S            = 10'b0000100000,
     WAIT_CTLE_TUNING_DONE_S = 10'b0001000000,
     FIB_RESET_S             = 10'b0010000000,
     WAIT_DATA_OK_S          = 10'b0100000000,
     RESETFSM_DONE_S         = 10'b1000000000;

   reg [9:0] 				    state_r;
   reg [9:0] 				    state_c;

   reg 					    ctle_tuning_done_r;
   reg 					    ctle_tuning_done_r2;
   reg 					    ctle_tuning_done_posedge;
   reg 					    ctle_tuning_done_negedge;
   reg 					    rxdata_ok_r;
   reg 					    rxdata_ok_r2;

   reg 					    rxrdy_r;
   reg 					    rxrdy_r2;
   reg 					    rxrdy_r3;
   reg 					    rxrdy_posedge;

   reg 					    rxresetdone_r;
   reg 					    rxresetdone_r2;
   reg 					    rxresetdone_r3;
   reg 					    rxresetdone_posedge;

   reg 					    gtrxreset_c;
   reg 					    rxfibreset_c;
   reg 					    resetfsmdone_c;
   reg					    ctle_en_c;
   reg					    ctle_init_c;
   reg [9:0]			    cntr_r;
   reg					    timer_en;
   reg [30:0]			    timer_r;
   reg [3:0] 			    startup_cntr;
   reg					    startup_cntr_inc;   
   reg [3:0] 			    reset_cntr;
   reg					    reset_cntr_inc;
   

   // assign fsm_state = state_r;
   	     
   /*****************Synchronization flops*********************/
   always@(posedge SYSCLK_IN)
     begin
	rxrdy_r <= RXRDY_IN;
	rxrdy_r2 <= rxrdy_r;
	rxrdy_r3 <= rxrdy_r2;
	rxrdy_posedge <= ~rxrdy_r3 & rxrdy_r2;
     end

   always@(posedge SYSCLK_IN)
     begin
	rxresetdone_r <= RXRESETDONE_IN;
	rxresetdone_r2 <= rxresetdone_r;
	rxresetdone_r3 <= rxresetdone_r2;
	rxresetdone_posedge <= ~rxresetdone_r3 & rxresetdone_r2;
     end

   always@(posedge SYSCLK_IN)
     begin
	ctle_tuning_done_r <= CTLE_TUNING_DONE_IN;
	ctle_tuning_done_r2 <= ctle_tuning_done_r;
	ctle_tuning_done_posedge <= ~ctle_tuning_done_r2 & ctle_tuning_done_r;
	ctle_tuning_done_negedge <= ctle_tuning_done_r2 & ~ctle_tuning_done_r;
	rxdata_ok_r  <= DATA_OK_IN;
	rxdata_ok_r2 <= rxdata_ok_r;
     end
     
   /*****************Register assignments for next state and outputs*********************/
   always@(posedge SYSCLK_IN)
     begin
	if (RESET_IN)
	  begin
	     state_r <= INIT_S;
	     GTRXRESET_OUT <= 1'b0;
	     RXFIBRESET_OUT <= 1'b0;
	     RESETFSMDONE_OUT <= 1'b0;
	     CTLE_EN_OUT <= 1'b0;
	     CTLE_INIT_OUT <= 1'b0;
	     cntr_r  <= 10'd0;
	     startup_cntr <= 4'd0;
	  end
	else
	  begin
	     state_r <= state_c;
	     GTRXRESET_OUT <= gtrxreset_c;
	     RXFIBRESET_OUT <= rxfibreset_c;
	     RESETFSMDONE_OUT <= resetfsmdone_c;
	     CTLE_EN_OUT      <= ctle_en_c;
	     CTLE_INIT_OUT    <= ctle_init_c;
	     if (timer_en) begin
	        timer_r <= timer_r + 1'b1;
	     end
	     else begin
	        timer_r <= 31'b0;
	     end

	     if (gtrxreset_c) begin
	        cntr_r  <= 10'd0;
	     end else if (!cntr_r[6]) begin
	        cntr_r  <= cntr_r + 10'd1;
	     end
	     
	      if (startup_cntr_inc)
	        startup_cntr <= startup_cntr + 4'd1;
	        
	     if (gtrxreset_c)
	        reset_cntr <= 4'd0;
	     else if (reset_cntr_inc)
	        reset_cntr <= reset_cntr + 4'd1;
	     
	  end
     end

   always @ *
     begin
	case (state_r)
	  INIT_S:
	    begin
	       state_c <= ASSERT_RXRESET_S;
	       fsm_state <= 8'h0;
	       gtrxreset_c <= 1'b0;
	       resetfsmdone_c <= 1'b0;
	       rxfibreset_c <= 1'b0;
	       timer_en     <= 1'b0;
	       ctle_en_c    <= 1'b0;
	       ctle_init_c  <= 1'b0;
	       startup_cntr_inc <= 1'b0;
	       reset_cntr_inc <= 1'b0;
	    end

	  ASSERT_RXRESET_S:
	    begin
	       fsm_state <= 8'h1;
	       state_c <= WAIT_MMCM_S;
	       gtrxreset_c <= 1'b1;
	       resetfsmdone_c <= 1'b0;
	       rxfibreset_c <= 1'b0;
	       ctle_en_c    <= 1'b0;
	       ctle_init_c  <= 1'b0;
	       timer_en     <= 1'b0;
	       startup_cntr_inc <= 1'b0;
	       reset_cntr_inc <= 1'b0;
	    end
	    
	  WAIT_MMCM_S:
	    begin
	     fsm_state <= 8'h2;
	       if (MMCM_LOCKED && cntr_r[6]) // Wait for 16 cycles and for the MMCM lock
		 begin
		    state_c <= WAIT_RXRDY_S;
		 end
	       else
		 begin
		    state_c <= WAIT_MMCM_S;
		 end
	       gtrxreset_c <= 1'b0;
	       resetfsmdone_c <= 1'b0;
	       rxfibreset_c <= 1'b0;
	       ctle_en_c    <= 1'b0;
	       ctle_init_c  <= 1'b0;
	       timer_en     <= 1'b0;
	       startup_cntr_inc <= 1'b0;
	       reset_cntr_inc <= 1'b0;
	    end // case: WAIT_MMCM_S
	    	    

	  WAIT_RXRDY_S:
	    begin
	      fsm_state <= 8'h3;
	       if (rxrdy_r3) //(rxrdy_posedge)
		       begin
		       state_c <= WAIT_RXRESETDONE_S;
		       //gtrxreset_c <= 1'b0;
		       end
	       else
		       begin
		       state_c <= WAIT_RXRDY_S;
		       //gtrxreset_c <= 1'b1;
		       end
	       gtrxreset_c <= 1'b0;
	       resetfsmdone_c <= 1'b0;
	       rxfibreset_c <= 1'b0;
	       ctle_init_c  <= 1'b0;
	       ctle_en_c    <= 1'b0;
	       timer_en     <= 1'b0;
	       startup_cntr_inc <= 1'b0;
	       reset_cntr_inc <= 1'b0;
	    end // case: WAIT_RXRDY_S
	    
	  WAIT_RXRESETDONE_S:
	    begin
	     fsm_state <= 8'h4;
	       if (rxresetdone_posedge)
		 begin
		    state_c <= START_CTLE_S;
		    //rxfibreset_c <= 1'b0;
		 end
	       else
		 begin
		    state_c <= WAIT_RXRESETDONE_S;
		    //rxfibreset_c <= 1'b1;
		 end
	       gtrxreset_c <= 1'b0;
	       resetfsmdone_c <= 1'b0;
	       rxfibreset_c <= 1'b0;
	       ctle_init_c  <= 1'b0;
	       ctle_en_c    <= 1'b0;
	       timer_en     <= 1'b0;
	       startup_cntr_inc <= 1'b0;
	       reset_cntr_inc <= 1'b0;
	    end // case: WAIT_RXRESETDONE_S
	    
	  START_CTLE_S: // Wait for 50 us and then start CTLE tunning
	    begin
	     fsm_state <= 8'h5;
	     gtrxreset_c <= 1'b0;
	     resetfsmdone_c <= 1'b0;
	     rxfibreset_c <= 1'b0;
	     ctle_init_c  <= 1'b0;
	     ctle_en_c    <= 1'b0;
	     timer_en     <= 1'b1;
	     startup_cntr_inc <= 1'b0;
	     reset_cntr_inc <= 1'b0;
	     if (timer_r[13]) begin 
		    state_c      <= WAIT_CTLE_TUNING_DONE_S;
		    // Start the CTLE tunig process after 4 unsucessfull startups, 
		    // otherwise do the fast CTLE initialization only 
		    if (!startup_cntr[2]) begin
		       ctle_en_c    <= 1'b0;
		       ctle_init_c  <= 1'b1;
		    end else begin
		       ctle_en_c    <= 1'b1;
		       ctle_init_c  <= 1'b0;
		    end
		 end
		 else begin
		    state_c <= START_CTLE_S;
		 end
		end // case: START_CTLE_S
	  
	  WAIT_CTLE_TUNING_DONE_S:
	   begin
	     fsm_state <= 8'h6;
	     rxfibreset_c <= 1'b0;
	     startup_cntr_inc <= 1'b0;
	     if (!startup_cntr[2]) begin
		     ctle_en_c    <= 1'b0;
		     ctle_init_c  <= 1'b1;
		 end else begin
		     ctle_en_c    <= 1'b1;
		     ctle_init_c  <= 1'b0;
	     end
	     timer_en     <= 1'b0;
	     // if (ctle_tuning_done_r2)
	     if (CTLE_TUNING_DONE_IN)
		 begin
			    state_c      <= FIB_RESET_S;
			    rxfibreset_c <= 1'b1;
			    ctle_en_c    <= 1'b0;
			    ctle_init_c  <= 1'b0;
			    startup_cntr_inc <= 1'b1;
			 end
	    	   else
			 begin
			    state_c <= WAIT_CTLE_TUNING_DONE_S;
		 end
	     gtrxreset_c <= 1'b0;
	     resetfsmdone_c <= 1'b0;
	     reset_cntr_inc <= 1'b0;
	    end // case: WAIT_CTLE_TUNING_DONE_S
	    
	  FIB_RESET_S: 
	   begin
	     fsm_state      <= 8'h9;
	     timer_en       <= 1'b0;
	     resetfsmdone_c <= 1'b0;
	     startup_cntr_inc <= 1'b0;
	     reset_cntr_inc <= 1'b0;
	     ctle_en_c    <= 1'b0;
	     ctle_init_c  <= 1'b0;
	     gtrxreset_c  <= 1'b0;
	     rxfibreset_c <= 1'b0;
	     if (rxresetdone_posedge)
	        state_c <= WAIT_DATA_OK_S;
	     else
	        state_c <= FIB_RESET_S;
	    end 	// case: FIB_RESET_S

	  // Restart the whole startup sequence if the data doesn't become 
	  // valid within the 250 ms period
	  WAIT_DATA_OK_S: 
	   begin
	     fsm_state      <= 8'h7;
	     timer_en       <= 1'b1;
	     resetfsmdone_c <= 1'b1;
	     startup_cntr_inc <= 1'b0;
	     reset_cntr_inc <= 1'b0;
	     rxfibreset_c   <= 1'b0;
	     if (rxdata_ok_r2)
		 begin
		    state_c <= RESETFSM_DONE_S;
		 end
		 else begin
		 	if (timer_r[28]) begin // Wait for 2000 ms
		 		reset_cntr_inc <= 1'b1;
		 		timer_en <= 1'b0;
		 		if (!reset_cntr[2]) begin
		 		   rxfibreset_c <= 1'b1;
		 		   state_c <= FIB_RESET_S;
		 		end else
		 		   state_c <= INIT_S; // 4th unsuccessful attempt to start the interface - repeat the whole startup interface
		 	end else
		 	    state_c <= WAIT_DATA_OK_S;
		 end
	     ctle_en_c    <= 1'b0;
	     ctle_init_c  <= 1'b0;
	     gtrxreset_c  <= 1'b0;
	    end // case: WAIT_DATA_OK_S
	    
	  RESETFSM_DONE_S:
	    begin
	     fsm_state <= 8'h8;
	     rxfibreset_c <= 1'b0;
	       //if (!ctle_tuning_done_r2)
	       if (!CTLE_TUNING_DONE_IN)
		 begin
		    state_c <= WAIT_CTLE_TUNING_DONE_S;
		    resetfsmdone_c <= 1'b0;
		 end
	       else
	     if (!rxdata_ok_r2)
	     begin
		    // state_c <= INIT_S;     
		    state_c <= FIB_RESET_S;  // 
		    rxfibreset_c <= 1'b1;
		    resetfsmdone_c <= 1'b0;
	     end
	        else
		 begin
		    state_c <= RESETFSM_DONE_S;
		    resetfsmdone_c <= 1'b1;
		 end
	       gtrxreset_c  <= 1'b0;
           ctle_en_c    <= 1'b0;
	       ctle_init_c  <= 1'b0;
	       timer_en     <= 1'b0;
	       startup_cntr_inc <= 1'b0;
	       reset_cntr_inc <= 1'b0;
	    end // case: RESETFSM_DONE_S

         default:
	    begin
	     fsm_state <= 8'hff;
	     state_c <= INIT_S;
	     gtrxreset_c <= 1'b0;
	     rxfibreset_c <= 1'b0;
	     resetfsmdone_c <= 1'b0;
	     ctle_en_c    <= 1'b0;
	     ctle_init_c  <= 1'b0;
	     timer_en     <= 1'b0;	     
	     startup_cntr_inc <= 1'b0;
	     reset_cntr_inc   <= 1'b0;
	    end
 
	endcase // case (state_r)
     end // always @ *

endmodule // gtwizard_v2_4_rx_startup_fsm

