-- block_encode.vhd : 40/100GBASE-R PCS block encoder module
--
-- Copyright (C) 2011 CESNET
-- Author(s): Stepan Friedl <friedl@cesnet.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: $

library ieee;
use ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity block_encode is
   generic (
      NUM_LANES : natural := 4
   );
   port (
      RESET  : in std_logic;
      CLK    : in std_logic; -- TX clock, 156.25MHz
      BYPASS : in std_logic; -- Encoder bypass
      TXD    : in std_logic_vector(NUM_LANES*64-1 downto 0); -- XL(C)GMII data
      TXC    : in std_logic_vector(NUM_LANES*8-1 downto 0);  -- XL(C)GMII command
      --
      Q      : out std_logic_vector(66*NUM_LANES-1 downto 0)

   );
end block_encode;

-- ----------------------------------------------------------------------------
--             Architecture declaration  --  ComboLXT Top Level              --
-- ----------------------------------------------------------------------------
architecture behavioral of block_encode is

  signal reset_n       : std_logic;
  signal encoded_data  : std_logic_vector(66*NUM_LANES-1 downto 0);
--   signal txd_r0        : std_logic_vector(64*NUM_LANES-1 downto 0);
--   signal txc_r0        : std_logic_vector( 8*NUM_LANES-1 downto 0);
--   signal txd_r1        : std_logic_vector(64*NUM_LANES-1 downto 0);
--   signal txc_r1        : std_logic_vector( 8*NUM_LANES-1 downto 0);
--   signal txd_r2        : std_logic_vector(64*NUM_LANES-1 downto 0);
--   signal txc_r2        : std_logic_vector( 8*NUM_LANES-1 downto 0);
  signal txs           : std_logic_vector( 3*NUM_LANES-1 downto 0); -- TX encoder state
  signal txs_p         : std_logic_vector( 3*NUM_LANES-1 downto 0); -- previous lane encoder state
  signal txs_reg       : std_logic_vector( 2 downto 0); -- 

begin

reset_n <= not reset;

-- TMP_REGS: process(CLK) -- For simulation purposes only
-- begin
--    if clk'event and clk = '1' then
--       txd_r0  <= TXD;
--       txc_r0  <= TXC;
--       txd_r1  <= txd_r0;
--       txc_r1  <= txc_r0;
--       txd_r2  <= txd_r1;
--       txc_r2  <= txc_r1;
--    end if;
-- end process;

GEN_ENCODERS: for i in 0 to NUM_LANES-1 generate

   -- 10GBASE-R encoder from the Xilinx AppNote XAPP775
   ENCODE: entity work.encode
   port map (
      bypass_66encoder => BYPASS,
      clk156           => clk,
      rstb             => reset_n,
      txcontrol        => TXC( 8*(i+1)-1 downto i*8),
      txdata           => TXD(64*(i+1)-1 downto i*64),
      TXD_encoded      => encoded_data(66*(i+1)-1 downto i*66),
      TX_STATE         => txs(3*(i+1)-1 downto i*3),
      TX_STATE_PREV    => txs_p(3*(i+1)-1 downto i*3),
      txlf             => open
   );

end generate;

txs_p(2 downto 0) <= txs_reg;
GEN_STATE: for i in 0 to NUM_LANES-2 generate
   txs_p(3*(i+2)-1 downto 3*(i+1)) <= txs(3*(i+1)-1 downto 3*i);
end generate;

DEC_STATE_REGS: process(CLK)
begin
   if clk'event and clk = '1' then
      txs_reg <= txs(txs'high downto txs'high-2);
   end if;
end process;

Q <= encoded_data;

end behavioral;


