----------------------------------------------------
--  
--      VHDL code generated by Visual Elite
--
--  Design Unit:
--  ------------
--      Unit    Name  :  T_TYPE_Encode
--      Library Name  :  PCS_verilog
--  
--      Creation Date :  Tue Jul 13 15:25:58 2004
--      Version       :  3.5.1 build 43. Date: Feb 22 2004. License: 2004.2
--  
--  Options Used:
--  -------------
--      Target
--         Language   :  VHDL
--         Purpose    :  Synthesis
--         Vendor     :  Design Compiler
--  
--      Style
--         Use tasks                      :  No
--         Code Destination               :  1 File per Unit
--         Attach Packages                :  No
--         Generate Entity                :  Yes
--         Attach Directives              :  Yes
--         Structural                     :  No
--         Preserve spacing for free text :  Yes
--         Declaration alignment          :  No
--
----------------------------------------------------
----------------------------------------------------
--  
--  Library Name :  PCS_verilog
--  Unit    Name :  T_TYPE_Encode
--  Unit    Type :  Text Unit
--  
------------------------------------------------------

-- ---------------- Xilinx, CTD Systems & Apps  ------------------------
--  FileName: T_TYPE_Encode.v
--  Start of Coding Date: SUN April 22 2001 ( 2:00 pm)
--  File name: T_Type_Encode.v
--  Description: This file has the code for checking the validity of the
--               codes received from the XGMII and does the translation into
--               PCS codes. This function is part of the encodeing function
--               performed by the PCS.
--   Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
--               provided to you "as is". Xilinx and its licensors make, and you
--               receive no warranties or conditions, express, implied,
--               statutory or otherwise, and Xilinx specifically disclaims any
--               implied warranties of merchantability, non-infringement, or
--               fitness for a particular purpose. Xilinx does not warrant that
--               the functions contained in these designs will meet your
--               requirements, or that the operation of these designs will be
--               uninterrupted or error free, or that defects in the Designs
--               will be corrected. Furthermore, Xilinx does not warrant or
--               make any representations regarding use or the results of the
--               use of the designs in terms of correctness, accuracy,
--               reliability, or otherwise.
--               LIMITATION OF LIABILITY. In no event will Xilinx or its
--               licensors be liable for any loss of data, lost profits, cost
--               or procurement of substitute goods or services, or for any
--               special, incidental, consequential, or indirect damages
--               arising from the use or operation of the designs or
--               accompanying documentation, however caused and on any theory
--               of liability. This limitation will apply even if Xilinx
--               has been advised of the possibility of such damage. This
--               limitation shall apply not-withstanding the failure of the
--               essential purpose of any limited remedies herein.
--   Copyright  2002 Xilinx, Inc.
--   All rights reserved
--                        Revision History
-- -----------------------------------------------------------------
--  Date Modified             User Name            Full Name
--         Descrition of Changes
-- -----------------------------------------------------------------
--  $Log$
-- -----------------------------------------------------------------
--  NOTES:
-- -----------------------------------------------------------------
-- -----------------------------------------------------------------

--library SYNOPSYS;
--use SYNOPSYS.ATTRIBUTES.ALL;
 
 
library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;
 
 
entity T_TYPE_Encode is
  port (
        clk156 : in STD_LOGIC;
        rstb : in STD_LOGIC;
        coded_vec : out STD_LOGIC_VECTOR(65 downto 0 );
        txdata : in STD_LOGIC_VECTOR(63 downto 0 );
        txcontrol : in STD_LOGIC_VECTOR(7 downto 0 );
        T_TYPE : out STD_LOGIC_VECTOR(2 downto 0 )
        );
end T_TYPE_Encode;


architecture T_TYPE_Encode of T_TYPE_Encode is
 
  -- Functions for "||" translation
  function or_logic ( arg1, arg2  : boolean ) return std_logic
  is
  begin
    if arg1  or arg2
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  function or_logic ( arg1  : std_logic; arg2  : boolean  ) return std_logic
  is
  begin
    if (  arg1 = '1' or arg2 )
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  function or_logic ( arg1, arg2 : std_logic) return std_logic
  is
  begin
    if (  arg1 = '1' or arg2 = '1' )
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  -- End functions for "||" translation
 
  --
  function not_logic ( arg : std_logic) return std_logic
  is
  begin
    case (arg) is
      when 'X' | 'Z' => return 'X';
      when '1' => return '0';
      when others => return '1'; -- when '0'
    end case;
  end not_logic;
  --
 
  function conv_std_logic ( arg : boolean ) return std_logic is
  begin
    if arg
    then
      return '1';
    else
      return '0';
    end if;
  end;
  component XGMII_to_PCS
      port (
            in_code : in STD_LOGIC_VECTOR(7 downto 0 ) := "ZZZZZZZZ";
            out_code : out STD_LOGIC_VECTOR(6 downto 0 )
            );
  end component;
  signal tx_data : STD_LOGIC_VECTOR(63 downto 0 ) := X"0707070707070707";
  signal tx_data_0 : STD_LOGIC_VECTOR(63 downto 0 ) := X"0707070707070707";
  signal tx_control : STD_LOGIC_VECTOR(7 downto 0 ) := "11111111";  --  before leaving.
  signal tx_control_0 : STD_LOGIC_VECTOR(7 downto 0 ) := "11111111";
  signal C_7 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_6 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_5 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_4 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_3 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_2 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_1 : STD_LOGIC_VECTOR(6 downto 0 );
  signal C_0 : STD_LOGIC_VECTOR(6 downto 0 );
  signal err_7 : STD_LOGIC;
  signal err_6 : STD_LOGIC;
  signal err_5 : STD_LOGIC;
  signal err_4 : STD_LOGIC;
  signal err_3 : STD_LOGIC;
  signal err_2 : STD_LOGIC;
  signal err_1 : STD_LOGIC;
  signal err_0 : STD_LOGIC;
  signal err_7_0 : STD_LOGIC;
  signal err_6_0 : STD_LOGIC;
  signal err_5_0 : STD_LOGIC;
  signal err_4_0 : STD_LOGIC;
  signal err_3_0 : STD_LOGIC;
  signal err_2_0 : STD_LOGIC;
  signal err_1_0 : STD_LOGIC;
  signal err_0_0 : STD_LOGIC;
  signal PCS_Controls : STD_LOGIC_VECTOR(55 downto 0 ) := (others => '0');
begin
 
 
  Con_7: XGMII_to_PCS
    port map (
              tx_data_0(63 downto 56),
              C_7
              );
 
  Con_6: XGMII_to_PCS
                           --  for sync state machine
    port map (
              tx_data_0(55 downto 48),
              C_6
              );
 
  Con_5: XGMII_to_PCS
    port map (
              tx_data_0(47 downto 40),
              C_5
              );
 
  Con_4: XGMII_to_PCS
    port map (
              tx_data_0(39 downto 32),
              C_4
              );
 
  Con_3: XGMII_to_PCS
    port map (
              tx_data_0(31 downto 24),
              C_3
              );
 
  Con_2: XGMII_to_PCS
    port map (
              tx_data_0(23 downto 16),
              C_2
              );
 
  Con_1: XGMII_to_PCS
    port map (
              tx_data_0(15 downto 8),
              C_1
              );
 
  Con_0: XGMII_to_PCS
                           --  TX code select
    port map (
              tx_data_0(7 downto 0),
              C_0
              );
  err_7_0 <= and_reduce(C_7);
  err_6_0 <= and_reduce(C_6);
  err_5_0 <= and_reduce(C_5);
  err_4_0 <= and_reduce(C_4);
  err_3_0 <= and_reduce(C_3);
  err_2_0 <= and_reduce(C_2);
  err_1_0 <= and_reduce(C_1);
  err_0_0 <= and_reduce(C_0);
  process (clk156, rstb)
  begin
 
    if (rstb = '0') then
      err_7 <= transport '0';
      err_6 <= transport '0';
      err_5 <= transport '0';
      err_4 <= transport '0';
      err_3 <= transport '0';
      err_2 <= transport '0';
      err_1 <= transport '0';
      err_0 <= transport '0';
 
    elsif (clk156'event and clk156 = '1') then
      err_7 <= transport err_7_0;
      err_6 <= transport err_6_0;
      err_5 <= transport err_5_0;
      err_4 <= transport err_4_0;
      err_3 <= transport err_3_0;
      err_2 <= transport err_2_0;
      err_1 <= transport err_1_0;
      err_0 <= transport err_0_0;
 
    end if ;
  end process ;
  
  process (clk156)
  begin
 
    if (clk156'event and clk156 = '1') then
      tx_data_0 <= transport txdata;
      tx_control_0 <= transport txcontrol;
      tx_data <= transport tx_data_0;  --  For Encoder
      tx_control <= transport tx_control_0;
      PCS_Controls <= transport (C_7& C_6& C_5& C_4& C_3& C_2& C_1& C_0);
 
    end if ;
  end process ;  
 
  process (tx_data, tx_control, PCS_Controls, err_7, err_6, err_5, err_4, err_3,
    err_2, err_1, err_0)
 
  begin
    case tx_control is
      when "00000000" =>
        coded_vec <= (tx_data(63 downto 0)& "10");
        T_TYPE <= "011"; -- Data
 
      when "11111111" =>        
        if tx_data(7 downto 0) = "11111101" then  -- 0xFD
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4) = '1'
              or (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'  then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 7)& "0000000"& "10000111"& "01"
                         );
            T_TYPE <= "010";
 
          end if ;
 
        else -- data != 0xFD
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4) = '1'
              or (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'  or (err_0)
              = '1'  then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            if (PCS_Controls(55 downto 49) = "0011110") or (PCS_Controls(48
                downto 42) = "0011110") or (PCS_Controls(41 downto 35) = "0011110"
               ) or (PCS_Controls(34 downto 28) = "0011110") or (PCS_Controls(27
                downto 21) = "0011110") or (PCS_Controls(20 downto 14) = "0011110"
               ) or (PCS_Controls(13 downto 7) = "0011110") or (PCS_Controls(6
                downto 0) = "0011110") then
              -- `define  EBLOCK_R {`XGMII_error,`XGMII_error,`XGMII_error,`XGMII_error,`XGMII_error,`XGMII_error,`XGMII_error,`XGMII_error}
              -- `define  EBLOCK_T {`PCS_error,`PCS_error,`PCS_error,`PCS_error,`PCS_error,`PCS_error,`PCS_error,`PCS_error,`Type_1,`Sync_cont}
              -- data frame
              --  all control or terminate_0
              coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                           );
              T_TYPE <= "100";-- error
 
            else                                         -- 1E
              coded_vec <= (PCS_Controls(55 downto 0)& "00011110"& "01"); -- Idle
              T_TYPE <= "000";
 
            end if ;
 
          end if ;
 
        end if ;
      when "00011111" =>
        --  4-control with ordered_4 set   or 4-control with start_4
        if tx_data(39 downto 32) = "10011100" then
          if (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'  or (err_0) = '1'
              then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (tx_data(63 downto 40)& "0000"& PCS_Controls(27 downto
                         0)& "00101101"& "01");
            T_TYPE <= "000";
 
          end if ;
 
        else
          if tx_data(39 downto 32) = "01011100" then  --  This is an Fsig ordered set
            if (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'  or (err_0)
                = '1'  then
              coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                           );
              T_TYPE <= "100";-- error
 
            else
              coded_vec <= (tx_data(63 downto 40)& "1111"& PCS_Controls(27
                            downto 0)& "00101101"& "01");
              T_TYPE <= "000";
 
            end if ;
 
          else
            if tx_data(39 downto 32) = "11111011" then
              if (err_3) = '1'  or (err_2) = '1'  or (err_1) = '1'  or (err_0)
                  = '1'  then
                coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                             );
                T_TYPE <= "100";-- error
 
              else
                coded_vec <= (tx_data(63 downto 40)& "0000"& PCS_Controls(27
                              downto 0)& "00110011"& "01");
                T_TYPE <= "001";-- Start
 
              end if ;
 
            else
              coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                           );
              T_TYPE <= "100";-- error
 
            end if ;
 
          end if ;
        end if ;
      when "00010001" =>
        --  ordered_0 with start_4 or ordered_0 with ordered_4
        if tx_data(7 downto 0) = "10011100" then -- Sequence
          if tx_data(39 downto 32) = "10011100" then
            coded_vec <= (tx_data(63 downto 40)& "0000"& "0000"& tx_data(31
                          downto 8)& "01010101"& "01");
            T_TYPE <= "000"; -- Seq
 
          else
            if tx_data(39 downto 32) = "01011100" then
              coded_vec <= (tx_data(63 downto 40)& "1111"& "0000"& tx_data(31
                            downto 8)& "01010101"& "01");
              T_TYPE <= "000";
 
            else
              if tx_data(39 downto 32) = "11111011" then
                coded_vec <= (tx_data(63 downto 40)& "0000"& "0000"& tx_data(31
                              downto 8)& "01100110"& "01");
                T_TYPE <= "001";
 
              else
                coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                             );
                T_TYPE <= "100";-- error
 
              end if ;
 
            end if ;
          end if ;
 
        else
          if tx_data(7 downto 0) = "01011100" then
            if tx_data(39 downto 32) = "10011100" then
              coded_vec <= (tx_data(63 downto 40)& "0000"& "1111"& tx_data(31
                            downto 8)& "01010101"& "01");
              T_TYPE <= "000";
 
            else
              if tx_data(39 downto 32) = "01011100" then
                coded_vec <= (tx_data(63 downto 40)& "1111"& "1111"& tx_data(31
                              downto 8)& "01010101"& "01");
                T_TYPE <= "000";
 
              else
                if tx_data(39 downto 32) = "11111011" then
                  coded_vec <= (tx_data(63 downto 40)& "0000"& "1111"& tx_data(
                               31 downto 8)& "01100110"& "01");
                  T_TYPE <= "001";
 
                else
                  coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                               );
                  T_TYPE <= "100";-- error
 
                end if ;
 
              end if ;
            end if ;
 
          else
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          end if ;
        end if ;
      when "00000001" =>
        --  start_0 with data
        if tx_data(7 downto 0) = "11111011" then
          coded_vec <= (tx_data(63 downto 8)& "01111000"& "01");
          T_TYPE <= "001"; -- Start
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100"; -- error
 
        end if ;
      when "11110001" =>
        --  orderd_0 with control
        if tx_data(7 downto 0) = "10011100" then
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4) = '1'
              then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 28)& "0000"& tx_data(31 downto
                         8)& "01001011"& "01");
            T_TYPE <= "000";
 
          end if ;
 
        else
          if tx_data(7 downto 0) = "01011100" then
            if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4)
                = '1'  then
              coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                           );
              T_TYPE <= "100";-- error
 
            else
              coded_vec <= (PCS_Controls(55 downto 28)& "1111"& tx_data(31
                            downto 8)& "01001011"& "01");
              T_TYPE <= "000";
 
            end if ;
 
          else
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          end if ;
        end if ;
      when "11111110" =>
        --  terminate_1 with control
        if tx_data(15 downto 8) = "11111101" then
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4) = '1'
              or (err_3) = '1'  or (err_2) = '1'  then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 14)& "000000"& tx_data(7 downto
                         0)& "10011001"& "01");
            T_TYPE <= "010";
 
          end if ;
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when "11111100" =>
        --  terminate_2 with control
        if tx_data(23 downto 16) = "11111101" then
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4) = '1'
              or (err_3) = '1'  then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 21)& "00000"& tx_data(15 downto
                         0)& "10101010"& "01");
            T_TYPE <= "010";
 
          end if ;
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when "11111000" =>
        --  terminate_3 with control
        if tx_data(31 downto 24) = "11111101" then
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  or (err_4) = '1'
              then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 28)& "0000"& tx_data(23 downto
                         0)& "10110100"& "01");
            T_TYPE <= "010";
 
          end if ;
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when "11110000" =>
        --  terminate_4 with control
        if tx_data(39 downto 32) = "11111101" then
          if (err_7) = '1'  or (err_6) = '1'  or (err_5) = '1'  then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 35)& "000"& tx_data(31 downto 0
                         )& "11001100"& "01");
            T_TYPE <= "010";
 
          end if ;
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when "11100000" =>
        --  terminate_5 with control
        if tx_data(47 downto 40) = "11111101" then
          if (err_7) = '1'  or (err_6) = '1'  then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 42)& "00"& tx_data(39 downto 0)
                         & "11010010"& "01");
            T_TYPE <= "010";
 
          end if ;
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when "11000000" =>
        --  terminate_6 with control
        if tx_data(55 downto 48) = "11111101" then
          if (err_7)='1' then
            coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                         );
            T_TYPE <= "100";-- error
 
          else
            coded_vec <= (PCS_Controls(55 downto 49)& "0"& tx_data(47 downto 0)& "11100001"
                         & "01");
            T_TYPE <= "010";
 
          end if ;
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when "10000000" =>
        --  terminate_7
        if tx_data(63 downto 56) = "11111101" then
          coded_vec <= (tx_data(55 downto 0)& "11111111"& "01");
          T_TYPE <= "010";
 
        else
          coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                       );
          T_TYPE <= "100";-- error
 
        end if ;
      when others  =>
        --  error
        coded_vec <= STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                     );
        T_TYPE <= "100";-- error
 
                           --  case(tx_control)
    end case  ;
                           --  always @ (tx_data or tx_control or PCS_Controls or err_7 or err_6 or err_5 or err_4 or err_3 or err_2 or err_1 or err_0 )
    --  T_TYPE_Encode
  end process ;
 
 
end ;

