----------------------------------------------------
--  
--      VHDL code generated by Visual Elite
--
--  Design Unit:
--  ------------
--      Unit    Name  :  TX_FSM
--      Library Name  :  PCS_verilog
--  
--      Creation Date :  Tue Jul 13 15:26:04 2004
--      Version       :  3.5.1 build 43. Date: Feb 22 2004. License: 2004.2
--  
--  Options Used:
--  -------------
--      Target
--         Language   :  VHDL
--         Purpose    :  Synthesis
--         Vendor     :  Design Compiler
--  
--      Style
--         Use tasks                      :  No
--         Code Destination               :  1 File per Unit
--         Attach Packages                :  No
--         Generate Entity                :  Yes
--         Attach Directives              :  Yes
--         Structural                     :  No
--         Preserve spacing for free text :  Yes
--         Declaration alignment          :  No
--
----------------------------------------------------
----------------------------------------------------
--  
--  Library Name :  PCS_verilog
--  Unit    Name :  TX_FSM
--  Unit    Type :  Text Unit
--  
------------------------------------------------------

-- ---------------- Xilinx, CTD Systems & Apps  ------------------------
--  FileName: TX_FSM.v
--  Start of Coding Date: SAT April 21 2001 ( 2:00 pm)
--  File Name : TX_FSM.v
--  Description: This file has the code for the Transmit State Machine it is
--               part of the encoding function
--   Disclaimer: LIMITED WARRANTY AND DISCLAMER. These designs are
--               provided to you "as is". Xilinx and its licensors make, and you
--               receive no warranties or conditions, express, implied,
--               statutory or otherwise, and Xilinx specifically disclaims any
--               implied warranties of merchantability, non-infringement, or
--               fitness for a particular purpose. Xilinx does not warrant that
--               the functions contained in these designs will meet your
--               requirements, or that the operation of these designs will be
--               uninterrupted or error free, or that defects in the Designs
--               will be corrected. Furthermore, Xilinx does not warrant or
--               make any representations regarding use or the results of the
--               use of the designs in terms of correctness, accuracy,
--               reliability, or otherwise.
--               LIMITATION OF LIABILITY. In no event will Xilinx or its
--               licensors be liable for any loss of data, lost profits, cost
--               or procurement of substitute goods or services, or for any
--               special, incidental, consequential, or indirect damages
--               arising from the use or operation of the designs or
--               accompanying documentation, however caused and on any theory
--               of liability. This limitation will apply even if Xilinx
--               has been advised of the possibility of such damage. This
--               limitation shall apply not-withstanding the failure of the
--               essential purpose of any limited remedies herein.
--   Copyright  2002 Xilinx, Inc.
--   All rights reserved
--                        Revision History
-- -----------------------------------------------------------------
--  Date Modified             User Name            Full Name
--         Descrition of Changes
--   31-05-2013               Stepan Friedl  
--         Data FFs are not reset now
-- -----------------------------------------------------------------
--  $Log$
-- -----------------------------------------------------------------
--  NOTES:
-- -----------------------------------------------------------------
-- -----------------------------------------------------------------

--library SYNOPSYS;
--use SYNOPSYS.ATTRIBUTES.ALL;
 
 
library ieee;
use ieee.STD_LOGIC_1164.all;
use ieee.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_MISC.all;
use ieee.STD_LOGIC_UNSIGNED.all;
 
 
entity TX_FSM is
  port (
        clk156     : in STD_LOGIC;
        rstb       : in STD_LOGIC;
        T_TYPE     : in STD_LOGIC_VECTOR(2 downto 0 );
        STATE_PREV : in STD_LOGIC_VECTOR(2 downto 0 );  -- State of previous lane
        STATE      : out STD_LOGIC_VECTOR(2 downto 0 ); -- State of current lane
        coded_vec  : in STD_LOGIC_VECTOR(65 downto 0 );
        txdata     : in STD_LOGIC_VECTOR (63 downto 0); -- On output when the decoder is bypassed
        bypass_66encoder : in STD_LOGIC;
        TXD_encoded : out STD_LOGIC_VECTOR(65 downto 0 ) := X"000000000000001E" & "01";
        txlf        : out STD_LOGIC
        );
end TX_FSM;


architecture TX_FSM of TX_FSM is
 
  -- Functions for "||" translation
  function or_logic ( arg1, arg2  : boolean ) return std_logic
  is
  begin
    if arg1  or arg2
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  function or_logic ( arg1  : std_logic; arg2  : boolean  ) return std_logic
  is
  begin
    if (  arg1 = '1' or arg2 )
    then
      return '1';
    else
      return '0';
    end if;
  end or_logic;
  -- End functions for "||" translation
 
  --
  function not_logic ( arg : std_logic) return std_logic
  is
  begin
    case (arg) is
      when 'X' | 'Z' => return 'X';
      when '1' => return '0';
      when others => return '1'; -- when '0'
    end case;
  end not_logic;
  --
 
  function conv_std_logic ( arg : boolean ) return std_logic is
  begin
    if arg
    then
      return '1';
    else
      return '0';
    end if;
  end;
  
  constant INIT : std_logic_vector(2 downto 0):= "000";
  constant IDLE : std_logic_vector(2 downto 0):= "001";
  constant START : std_logic_vector(2 downto 0):= "010";
  constant DATA : std_logic_vector(2 downto 0):= "011"; 
  constant TERM : std_logic_vector(2 downto 0):= "100";
  constant ERROR: std_logic_vector(2 downto 0):= "101";
  
  constant T_SEQ   : std_logic_vector(2 downto 0) := "000";
  constant T_START : std_logic_vector(2 downto 0) := "001";
  constant T_DATA  : std_logic_vector(2 downto 0) := "011";
  constant T_TERM  : std_logic_vector(2 downto 0) := "010";
  
  signal Current_state : std_logic_vector(2 downto 0);
  signal Next_state    : std_logic_vector(2 downto 0);
  signal state_i       : std_logic_vector(2 downto 0);
  signal Code : STD_LOGIC_VECTOR(65 downto 0 ) := X"000000000000001E" & "01";
  signal t_type_reg : STD_LOGIC_VECTOR(2 downto 0 ) := "000";  
  
begin
 
  process (clk156, rstb)
  begin
 
    if (rstb = '0') then
      txlf <= transport '0';  --  for sync state machine
    elsif (clk156'event and clk156 = '1') then
      if Current_state = INIT then
        txlf <= transport '1';
      else
        txlf <= transport '0';
      end if ;
    end if ;
  end process ;

  process (clk156)
  begin
 

    if (clk156'event and clk156 = '1') then
      if (bypass_66encoder = '0') then
        t_type_reg <= transport T_TYPE;
        Code <= transport coded_vec;
        if Next_state = ERROR then -- error
          TXD_encoded <= transport STD_LOGIC_VECTOR'("001111000111100011110001111000111100011110001111000111100001111001"
                                   );
        else
          TXD_encoded <= transport Code;
        end if ;
 
      else
        TXD_encoded <= transport (txdata& "10");
      end if ;
 
    end if ;
  end process ;
  
  process (clk156, rstb)
  begin
 
    if (rstb = '0') then
      Current_state <= transport INIT;
    elsif (clk156'event and clk156 = '1') then
      if (bypass_66encoder = '0') then
        Current_state <= transport Next_state;
     end if ;
    end if ;
  end process ;  
  
  
next_state <= IDLE  when ((t_type_reg = T_SEQ)   and (STATE_PREV = IDLE or STATE_PREV = TERM or STATE_PREV = ERROR)) else -- 
              START when ((t_type_reg = T_START) and (STATE_PREV = IDLE or STATE_PREV = TERM)) else
              DATA  when ((t_type_reg = T_DATA)  and (STATE_PREV = START or STATE_PREV = DATA or STATE_PREV = ERROR)) else
              TERM  when ((t_type_reg = T_TERM)  and (STATE_PREV = DATA or STATE_PREV = ERROR)) else
              ERROR;
              
state_i <= IDLE  when (t_type_reg = T_SEQ) else
           START when (t_type_reg = T_START) else -- (next_type = T_START) and (STATE_PREV /= ERROR) else
           DATA  when (t_type_reg = T_DATA) else
           TERM  when (t_type_reg = T_TERM) else
           ERROR;
         
STATE     <= state_i;

end ;
