-- 100ge_phy_ent.vhd : The complete PHY for the 100GBASE-R (PCS+PMA) - entity 
--                    declaration
--
-- Copyright (C) 2012 CESNET
-- Author(s): Stepan Friedl <friedl@cesnet.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: $
--
-- NOTES:

library ieee;
use ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity phy_100ge_caui4_main is
   generic (
      SIMULATION : integer := 0      -- 1 speeds up simulation and disables the scrambler
   );
   port (
      RESET      : in std_logic; -- Async reset
      DRPCLK     : in std_logic; -- DRP clock, up to 125 MHz
      -- CGMII interface
      TXCLK      : out std_logic; -- CGMII RX clock output, 195.3125 MHz
      CGMII_TXD  : in std_logic_vector(511 downto 0); -- TX data
      CGMII_TXC  : in std_logic_vector( 63 downto 0); -- TX command
      RXCLK      : out std_logic; -- CGMII RX clock output, 195.3125 MHz
      CGMII_RXD  : out std_logic_vector(511 downto 0); -- RX data
      CGMII_RXC  : out std_logic_vector( 63 downto 0); -- RX command
      CLK_STABLE : out std_logic; -- TXCLK and RXCLK stable (MMCM locked)
      -- Transceiver reference clocks
      REFCLK_P   : in std_logic; -- GTZ quad 0 clock positive
      REFCLK_N   : in std_logic; -- GTZ quad 0 clock negative
      -- CAUI4 - GTZ serial ports 
      RXN        : in std_logic_vector(3 downto 0);
      RXP        : in std_logic_vector(3 downto 0);
      TXN        : out std_logic_vector(3 downto 0);
      TXP        : out std_logic_vector(3 downto 0);
      TXPOLARITY : in std_logic_vector(3 downto 0) := "0000"; -- Set to '1' to invert TX serial port polarity      
      RXPOLARITY : in std_logic_vector(3 downto 0) := "0000"; -- Set to '1' to invert RX serial port polarity       
      --
      SIGNAL_DET : in std_logic_vector(3 downto 0) := "1111";   -- Signal detect from the transcever/PMD
      -- Management (MI32)
      MI_CLK     : in std_logic;
      MI_DWR     : in std_logic_vector(31 downto 0) := X"00000000";
      MI_ADDR    : in std_logic_vector(31 downto 0) := X"00000000";
      MI_RD      : in std_logic := '0';
      MI_WR      : in std_logic := '0';
      MI_BE      : in std_logic_vector( 3 downto 0) := "0000";
      MI_DRD     : out  std_logic_vector(31 downto 0);
      MI_ARDY    : out  std_logic;
      MI_DRDY    : out  std_logic
   );
end phy_100ge_caui4_main;
