-- asfifo_ent.vhd
--!
--! \file
--! \brief Asynchronous fifo in BRAMs for 7series FPGAs
--! \author Vaclav Hummel <xhumme00@stud.fit.vutbr.cz>
--! \author Lukas Kekely <kekely@cesnet.cz>
--! \date 2013
--!
--! \section License
--!
--! Copyright (C) 2013 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
--! Package with log2 function.
use work.math_pack.all;

Library UNISIM;
use UNISIM.vcomponents.all;
library UNIMACRO;
use unimacro.Vcomponents.all;

--\name  Asfifo module
entity ASFIFO_BRAM_7SERIES_MAIN is
   generic(
      DEVICE                  : string := "7SERIES"; -- Target Device: "VIRTEX5", "VIRTEX6", "7SERIES" 
      DATA_WIDTH              : integer := 512;
      FIRST_WORD_FALL_THROUGH : boolean := true;
      ALMOST_FULL_OFFSET      : bit_vector(15 downto 0) := X"0080";
      ALMOST_EMPTY_OFFSET     : bit_vector(15 downto 0) := X"0080";
      -- There are some requirement for timing of RESET and RDEN to ensure.
      SAFE_RESET              : boolean := false
   );
   port(
      --! Write interface
      CLK_WR   : in  std_logic;
      RST_WR   : in  std_logic;
      DI       : in  std_logic_vector(DATA_WIDTH-1 downto 0);
      WR       : in  std_logic;
      AFULL    : out std_logic;
      FULL     : out std_logic;

      --! Read interface
      CLK_RD   : in  std_logic;
      RST_RD   : in  std_logic;
      DO       : out std_logic_vector(DATA_WIDTH-1 downto 0);
      RD       : in  std_logic;
      AEMPTY   : out std_logic;
      EMPTY    : out std_logic
   );
end entity ASFIFO_BRAM_7SERIES_MAIN;
