/*!
 * \file sze2write.h
 * \brief Sends data from pcap dump file to sze2 interface
 * \author Andrej Hank <xhanka00@liberouter.org>
 * \date 2008
 */
/*! Copyright (C) 2008 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */


#ifndef _SZE2WRITE_H_
#define _SZE2WRITE_H_

#define DUMP_FILE_SIZE	(1 << 12)

typedef enum sze_header_type { NIC, NIFIC, NIFIC4 } sze_header_t;

bool dump_file_open_and_increment(u_int *dump_file_cnt, FILE **file, char *dump_file_base_name);

void dump_packet_to_file(u_char *data, u_int32_t len, FILE * dump_file);

int dump2sze2packet(char *infilename, char *out_file_name);

uint32_t precached_got_next(unsigned char *data);

int dump2sze_read(char *file_name, unsigned char **data);

u_char * prepare_transformed(struct szedata *sze, bool COMPUTE_CRC, sze_header_t HEADER_TYPE, u_char *sw_data, u_int sw_len, u_int *packet_len, u_int nific_bitmap);

int send_burst_transformed(struct szedata *sze, bool COMPUTE_CRC, sze_header_t HEADER_TYPE, u_char *sw_data, u_int sw_len, u_short iface, u_int nific_bitmap);

u_int precached_prepare_burst(u_char *data, u_int buffer_size, u_int *buffer_packet_c);

void dump_packet(u_char *data, u_int sze_packet_len, u_int *dump_size, FILE **dump_file, u_int *dump_file_cnt, char *dump_file_base_name);

#endif /* _SZE2WRITE_H_ */

