/**
 * \file pcaplbr.h
 * \brief Library used in Liberouter project for common often repetitive tasks
 * \author Andrej Hank <xhanka00@liberouter.org>
 * \author Juraj Blaho <xblaho00@stud.fit.vutbr.cz>
 * \author Petr Springl <xsprin01@liberouter.org>
 * \date 2007
 */
/* Copyright (C) 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL) version 2 or later, in which case the provisions
 * of the GPL apply INSTEAD OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#include <pcap.h>


#define CL_PCAP_PRINT_CRC 	1	/*!< print last 4 bytes as CRC */
#define CL_PCAP_PRINT_BRIEF  	2	/*!< print only brief header data */
#define CL_PCAP_PRINT_RICH 	4	/*!< print detailed header data */
#define CL_PCAP_PRINT_CONTENT	8	/*!< print content of packet */

void cl_pcap_print_packet(const unsigned char *packet, struct pcap_pkthdr header, unsigned short print_options);

/*! \defgroup dump_file Working with pcap dump file
 * @{ */

/*! \defgroup high_level High level
 * @{ */
int cl_pcap_open_dump_file(char *infilename, struct pcap_file_header *file_hdr);
int cl_pcap_read_pkt(int inf, void *pkt_ptr, struct pcap_pkthdr *pkt_hdr);
int cl_pcap_close_dump_file(int inf);
/*! @} */

/*! \defgroup low_level Low level
 * @{ */
int cl_pcap_read_file_hdr(int fd, struct pcap_file_header *filehdr);
int cl_pcap_read_pkt_hdr(int fd, struct pcap_pkthdr *pkt_hdr);
int cl_pcap_read_pkt_data(int fd, void *pkt_ptr, u_int32_t pkt_len);
/*! @} */
/*! @} */
/*! @} */
