/*!
 * \file afilterctl_cfg.h
 * \brief Tool for controlling advanced filter - configuration of HW filter
 * \author Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
 * \date 2012
 *
 * Copyright (C) 2012 Brno University of Technology
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id: afilterctl_cfg.h 3122 2013-02-06 01:41:51Z xkekel00 $
 *
 */

#ifndef AFILTERCTL_CFG_H_INCLUDED
#define AFILTERCTL_CFG_H_INCLUDED

#include "hwio.h"

typedef struct {
    uint32_t items;
    uint8_t tables;
    uint8_t flags;
    uint8_t items_width;
} flt_rule_type_config;

#define FILTER_NOMATCH  0xFFFF

#define FLT_RULE_TYPE_FLAGS_ALL_FIELDS  0x3E
#define FLT_RULE_TYPE_FLAGS_SRCIP       0x20
#define FLT_RULE_TYPE_FLAGS_DSTIP       0x10
#define FLT_RULE_TYPE_FLAGS_SRCPORT     0x08
#define FLT_RULE_TYPE_FLAGS_DSTPORT     0x04
#define FLT_RULE_TYPE_FLAGS_PROTO       0x02
#define FLT_RULE_TYPE_FLAGS_IPV4_ONLY   0x01

typedef struct {
    int rule_types;
    int iv_number;
    flt_rule_type_config cfg[31];
    int rule_types_width;
} flt_config;


flt_config *flt_get_config(struct hwio_comp *comp);

#endif
