/*!
 * \file hfex.h
 * \brief Functions prototypes for configuring hfex
 * \author Daniel Ivanco <xivanc01@stud.fit.vutbr.cz>
 * \date 2008
 */
/*
 * hfexctl.c: Tool for controlling hfe
 * Copyright (C) 2008 CESNET
 * Author: Daniel Ivanco <xivanc01@stud.fit.vutbr.cz>
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_HFEX_H_
#define _LIBEROUTER_HFEX_H_

#include "../combosix.h"


typedef uint32_t hfex_row_t;

/*! HFE-X address window */
#define CS_HFEX_SIZE 	 	0x10000
/*! Stop Register */
#define CS_HFEX_STOP_REG 	0x00000000
/*! Register Working */
#define CS_HFEX_WORKING_REG 0x00000004
/*! FrameLink Rem */
#define CS_HFEX_FRAME_LINK_REM_REG 0x00000008
/*! Output Words Register */
#define CS_HFEX_OUT_WORDS_REG 0x0000000C
/*! BRAM Configuration */
#define CS_HFEX_BRAM_CONF_REG 0x00008000

/*!
 * \defgroup hfex_component HFEX component
 * \ingroup components 
 * \{
 *
 * \brief This module implements basic routines for manipulating HFEX component.
 *
 */
void 
cs_hfex_set_running(cs_device_t * dev, cs_space_t * space);

void 
cs_hfex_stop(cs_device_t * dev, cs_space_t * space);

int 
cs_hfex_init_bram(cs_device_t * dev, cs_space_t * space, hfex_row_t * rows, int count);

int 
cs_hfex_init_registers(cs_device_t * dev, cs_space_t * space, hfex_row_t * rows, int count);

int 
cs_hfex_read_rows_from_file(char *src_file_name, hfex_row_t ** rows);

int 
cs_hfex_init_from_file(cs_device_t * dev, cs_space_t * space, char *bram_file_name, char *registers_file_name);

/*! \} */

#endif
