/*!
 * \file hfe2.h
 * \brief Function prototypes for hfe2
 * \author Andrej Hank <xhanka00@liberouter.org>
 * \date 2006, 2007
 */
/*
 * Copyright (C) 2006, 2007 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_HFE2_H_
#define _LIBEROUTER_HFE2_H_

/*!
 * \defgroup hfe2_component HFE2 component
 * \ingroup components
 *
 * \brief Basic functions to work with hfe2 - stop, start, reset, fill
 * instruction cache
 * \{*/

#include <stdbool.h>

#include "../combosix.h"

/*! hfe2 size */
#define CS_HFE2_SIZE 		0x4000
/*! control register */
#define CS_HFE2_CTRL_REG 	0x0000
/*! status register */
#define CS_HFE2_STAT_REG 	0x0004
/*! instruction memory */
#define CS_HFE2_INST_MEM	0x2000

/*! how many times to check if core stopped */
#define CS_HFE2_CORE_STOP_CHECK_COUNT 		5
/*! interval between checks */
#define CS_HFE2_CORE_STOP_CHECK_INTERVAL	1000000

/*! hfe2 32b long row */
typedef u_int32_t cs_hfe2_row_t; 

int cs_hfe2_init_from_file(cs_device_t * dev, cs_space_t * space, char * src_file_name);
void cs_hfe2_init(cs_device_t *dev, cs_space_t *space, cs_hfe2_row_t *rows, int count);
int cs_hfe2_read_rows_from_file (char * src_file_name, cs_hfe2_row_t ** rows);

void cs_hfe2_set_running(cs_device_t *dev, cs_space_t *space);
void cs_hfe2_reset(cs_device_t *dev, cs_space_t *space);
void cs_hfe2_stop(cs_device_t *dev, cs_space_t *space, bool immediate);

/*! \}*/

#endif
