/*!
 * \file flstat.h
 * \brief Functions for controlling FLSTAT component.
 * \author Peter Stranak <stranak@liberouter.org>
 * \date 2010-2011
 *
 * Copyright (C) 20010-2011 CESNET
 *
 * LICENSE TERMS
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the Company nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * ALTERNATIVELY, provided that this notice is retained in full, this
 * product may be distributed under the terms of the GNU General Public
 * License (GPL), in which case the provisions of the GPL apply INSTEAD
 * OF those given above.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall the company or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 *
 * $Id$
 *
 */

#ifndef _LIBEROUTER_FLSTAT_H_
#define _LIBEROUTER_FLSTAT_H_

#include "../combo.h"

/*!
 * \defgroup flstat_component FLSTAT component
 * \ingroup components
 *
 * \brief FLSTAT (FrameLink Status) component control for reading status of framelink packets.
 *
 * \{
 */

/*!
 * \typedef cs_flstat_t
 * \brief Structure for storing data from FLSTAT
 */
typedef struct {
	/*! number of watched interfaces */
	int interfaces;
	/*! width of each counter in bits */
	int cntr_width;
	/*! data from control register */
	u_int32_t control_reg;
	/*! clock cycles */
	unsigned long long clock;
	/*! overflow of clock detected */
	char overflow;
	/*! array of structures for each interface */
	struct flstat_ifc {
		/*! source ready */
		unsigned long long src_ready;
		/*! destination ready */
		unsigned long long dst_ready;
		/*! both ready */
		unsigned long long both_ready;
	} *flstat_ifc;
} cs_flstat_t;

u_int32_t cs_flstat_read_control(cs_device_t *dev, cs_space_t *space);
void cs_flstat_enable(cs_device_t *dev, cs_space_t *space, int enable);
void cs_flstat_reset(cs_device_t *dev, cs_space_t *space);
void cs_flstat_sample(cs_device_t *dev, cs_space_t *space);

int cs_flstat_is_enabled(u_int32_t control);
int cs_flstat_is_sampling_available(u_int32_t control);

int cs_flstat_read(cs_device_t *dev, cs_space_t *space, cs_flstat_t *fl_comp);
void cs_flstat_free(cs_flstat_t *fl_comp);

/*! \} */

#endif /* _LIBEROUTER_FLSTAT_H_ */
