/*
 * network interface card registers
 *
 * Copyright (c) 2009 CESNET
 * Copyright (c) 2009 Petr Kastovsky <kastovsky@liberouter.org>
 *
 * Licensed under GPLv2
 */

#ifndef HW_H_FILE
#define HW_H_FILE

#define PAC_DIR_RX					0
#define PAC_DIR_TX					1

#define CV2ETH_HW_INTF          1 /* hw desc interrupt flag */
#define CV2ETH_HW_LFF           2 /* hw desc last fragment flag */
#define CV2ETH_HW_NDF           4 /* hw desc next desc flag */

#define PAC_HW_TX_TIMEOUT           0x00800000
#define PAC_HW_RX_TIMEOUT           0x00000004
/* ibuf/obuf */
#define CV2ETH_HW_IBUF_BASE			0x1000
#define CV2ETH_HW_IBUF_GAP			0x100
#define CV2ETH_HW_IBUF_REG_EN		0x20
#define CV2ETH_HW_IBUF_EN(ifc) \
	((CV2ETH_HW_IBUF_BASE) + (ifc)*(CV2ETH_HW_IBUF_GAP) +\
	(CV2ETH_HW_IBUF_REG_EN))

#define CV2ETH_HW_OBUF_BASE			0x2000
#define CV2ETH_HW_OBUF_GAP			0x100
#define CV2ETH_HW_OBUF_REG_EN		0x20
#define CV2ETH_HW_OBUF_EN(ifc) \
	((CV2ETH_HW_OBUF_BASE) + (ifc)*(CV2ETH_HW_OBUF_GAP) +\
	(CV2ETH_HW_OBUF_REG_EN))
    
/* io */
#define PAC_HW_GPTR_SIZE			8 			/* size of global pointer */
#define PAC_HW_IB_BASE				0x02000000  /* internal bus base adress */ 
#define PAC_HW_DMA_BASE				(PAC_HW_IB_BASE) | 0x00200000
#define PAC_HW_DESC_BASE   			(PAC_HW_DMA_BASE) 
#define PAC_HW_DESC_INIT_CHANNEL    (PAC_HW_DESC_BASE) | 0x0007F000
#define PAC_HW_DESC_INIT(ifc, dir) \
	        ((PAC_HW_DESC_INIT_CHANNEL) +\
	        (2*(ifc) + (dir)) * (PAC_HW_GPTR_SIZE))

#define PAC_HW_DESC_CHANNEL(ifc, dir) \
	        ((PAC_HW_DESC_BASE) +\
	        (2*(ifc) + (dir)) * (0x1000))


#define PAC_HW_LB_BASE				0x00000800  /* local bus base adress */ 
#define PAC_HW_REG_BASE				(PAC_HW_LB_BASE)
#define PAC_HW_REG_SIZE				0x4		/* size of register */
#define PAC_HW_REG_CHANNEL_SIZE		0x40

/* registers indexes */
#define PAC_HW_REG_CTRL				0x0   /* control register */
#define PAC_HW_REG_STATUS			0x1   /* status register */
// #define PAC_HW_REG_HEAD				0x2 /* not accessible from sw */
#define PAC_HW_REG_TAIL				0x3   /* tail register */
#define PAC_HW_REG_TOUT				0x4   /* timeout register */
#define PAC_HW_REG_SWCNT			0x5   /* rx sw cnt */

#define PAC_HW_REG_TXGL				0x6   /* tx global address low */
#define PAC_HW_REG_TXGH				0x7   /* tx global address high */

#define PAC_HW_CTRL_RUN				0x2   /* run */
#define PAC_HW_CTRL_PAU				0x1   /* pause */
#define PAC_HW_CTRL_STP				0x0   /* stop */

#define PAC_HW_STAT_RUN				0x2   /* running */
#define PAC_HW_STAT_PAU				0x1   /* paused */
#define PAC_HW_STAT_STP				0x0   /* stopped */

#define PAC_HW_REG(ifc, dir, reg_index) \
	((PAC_HW_REG_BASE) + (2*(ifc) + (dir))*(PAC_HW_REG_CHANNEL_SIZE) +\
    (PAC_HW_REG_SIZE)*(reg_index))

/* DMA IRQ status regs */
#define PAC_HW_IRQ_BASE		(PAC_HW_DMA_BASE) | 0x00080000
#define PAC_HW_RX_IRQ		(PAC_HW_IRQ_BASE)
#define PAC_HW_TX_IRQ		(PAC_HW_IRQ_BASE) | 0x00000008

#define PAC_TXUP_CNT_SIZE	0x4 /* size of tx packet counter */
#endif
