/*
 * combo6x.h: Interface to the Combo6 with PCI IP core
 * Copyright (C) 2006-2008 CESNET
 * Author(s): Jaroslav Kysela <perex@perex.cz>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef __COMBO6X_H
#define __COMBO6X_H

#include <linux/io.h>
#include <linux/types.h>

#include "combo6k.h"
#include "combo6pcr.h"

/*
 * h/w access primitives
 */
static inline void combo6_br_writeb(struct combo6 *combo6, u32 reg, u8 val)
{
	writeb(val, combo6->mem_virt + reg);
}

static inline u8 combo6_br_readb(struct combo6 *combo6, u32 reg)
{
	return readb(combo6->mem_virt + reg);
}

static inline void combo6_br_writel(struct combo6 *combo6, u32 reg, u32 val)
{
	writel(val, combo6->mem_virt + reg);
}

static inline u32 combo6_br_readl(struct combo6 *combo6, u32 reg)
{
	return readl(combo6->mem_virt + reg);
}

static inline void combo6_cpld_writeb(struct combo6 *combo6, u32 reg, u8 val)
{
	writeb(val, combo6->cmem_virt + reg);
}

static inline u8 combo6_cpld_readb(struct combo6 *combo6, u32 reg)
{
	return readb(combo6->cmem_virt + reg);
}

static inline void combo6_cpld_writel(struct combo6 *combo6, u32 reg, u32 val)
{
	writel(val, combo6->cmem_virt + reg);
}

static inline u32 combo6_cpld_readl(struct combo6 *combo6, u32 reg)
{
	return readl(combo6->cmem_virt + reg);
}

static inline void combo6x_dma_finish(struct combo6 *combo6)
{
	while (combo6_br_readl(combo6, PCR_DMA_CMD) & DMA_CMD_RUN)
		udelay(1);
}

static inline void combo6x_stop_pcippc(struct combo6 *combo6)
{
	if (combo6->u.two.pcippc_ok) {
		combo6_br_writel(combo6, PCR_PPC_CTRL, PPC_CTRL_RESET);
		combo6->u.two.pcippc_run = 0;
	}
}

#endif /* __COMBO6X_H */
