/*
 *  combo6pcr.h: Register definitions for Cesnet PCI bridge on Virtex
 *  Copyright (c) 2006 CESNET
 *  Author(s): Jachym Holecek <freza@liberouter.org>
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef __COMBO6_PCR_H
#define __COMBO6_PCR_H

/* PCI bridge registers, also shared with PowerPC's data space. */

/* Firmware revision info. Minor versions preserve API. */
#define PCR_IDENT		0x000000		/* ro */
#define PCR_ID_IDENT(val)	(((val) >> 16) & 0xffff)
#define PCR_ID_MAJOR(val)	(((val) >> 8) & 0xff)
#define PCR_ID_MINOR(val)	((val) & 0xff)

/* PCR_ID_IDENT, or "what's behind the PCI core?". XXX better name */
#define PCR_IDENT_FIRST	0xc610


/* Firmware build time. Nifty. */
#define PCR_BIRTH		0x000004		/* ro */
#define BIRTH_MINUTE(val)	((val) & 0xff)		/* 0..59 */
#define BIRTH_HOUR(val)	(((val) >> 8) & 0xff)	/* 0..24 */
#define BIRTH_DAY(val)		(((val) >> 16) & 0xff)	/* 1..31 */
#define BIRTH_MONTH(val)	(((val) >> 24) & 0x0f)	/* 1..12 */
#define BIRTH_YEAR(val)	(((val) >> 28) & 0x0f)	/* Since 2000 */


/* System reset, needs a 0-1-0 pulse. Kills BAR[12] + devices, DMA,
 * interrupts, PowerPC. During reset, the device is stone dead, do
 * not touch! (except for PCR_REST, obviously)
 */
#define PCR_RESET		0x000010	/* rw, 1bit */

/* Board diagnostic LED, InVeRtEd. */
#define PCR_LED		0x000020	/* rw, 3bit */

/* Interrupt control. Funky idea taken from a swedish chip. */
#define PCR_INTR_STAT		0x000040	/* Current status */
#define PCR_INTR_MASK		0x000044	/* Enable mask */
#define PCR_INTR_SET		0x000048	/* MASK bits set */
#define PCR_INTR_CLR		0x00004c	/* MASK bits clear */
#define PCR_PPC_INTR_MASK	0x000050	/* Same as above, PPC routing */
#define PCR_PPC_INTR_SET	0x000054
#define PCR_PPC_INTR_CLR	0x000058

#define PCR_INTR_USER_SET	0x000060	/* Raise USER interrupt(s) */
#define PCR_INTR_USER_ACK	0x000064	/* Acknowledge USER bits */

/* PCR_INTR_* bitfields. The only local intr implemented is 0 currently. */
#define INTR_LOCAL_MASK	0x00ff
#define INTR_USER_MASK		0xf000
#define INTR_LOCAL(n)		((1 << (n)) & 0xff)	/* Local bus, stat ro */
#define INTR_DMA		(1 << 8)		/* DMA, stat ro */
#define INTR_USER(n)		(1 << ((n) + 12))	/* PowerPC, stat rw */


/* Block mode DMA engine, to be driven by PowerPC. */
#define PCR_DMA_ADDR_SRC	0x000080
#define PCR_DMA_ADDR_DST	0x000084
#define PCR_DMA_COUNT		0x000088	/* Transfer size (bytes), 16b */
#define PCR_DMA_CMD		0x00008c	/* Command */

/* DMA command bitfields. Routing defaults to PCI<-->Localbus. */
#define DMA_CMD_RUN		0x00000001	/* Start, autoclears */
#define DMA_CMD_NOINTR		0x00000080	/* Disable+clear done-irq */
#define DMA_CMD_CLEAR		0x80000000	/* Clear interrupt */

/* Source & destination buses/spaces. */
#define PCR_DMA_LOC_TAG	0x01		/* Local bus */
#define PCR_DMA_PCI_TAG	0x02		/* PCI address */
#define PCR_DMA_PPC_TAG	0x04		/* PowerPC data area */
#define PCR_DMA_DIR(dst, src)	((((dst) & 0x07) << 4) | (((src) & 0x07) << 1))

/* On-chip PowerPC 405 core. CLK must run before deasserting RST. */
#define PCR_PPC_CTRL		0x008000
#define PPC_CTRL_CLOCK		0x00000001	/* Core clock enable. */
#define PPC_CTRL_RESET		0x80000000	/* Core reset enable. */

/* 22bit Program Counter relative to IMEM base. */
#define PCR_PPC_PCOFFS		0x008004
#define PPC_PC(val)		(((val) >> 3) & 0x3fffff)

/* PowerPC core JTAG connection. */
#define PCR_PPC_JTAG		0x008010
#define PPC_JTAG_TCK		0x01
#define PPC_JTAG_TMS		0x02
#define PPC_JTAG_TDI		0x04
#define PPC_JTAG_TDO		0x08		/* Writes have no effect */

/* PowerPC's "internal" memory. */
#define PCR_PPC_IBASE		0x020000	/* Instruction memory */
#define PCR_PPC_DBASE		0x040000	/* Data memory */
#define PCR_PPC_ISIZE		(16 * 1024)
#define PCR_PPC_DSIZE		(8 * 1024)
#define PCR_PPC_HSIZE		256

/* General purpose registers. */
#define PCR_GPR(n)		(0x060000 + (n)*4)
#define PCR_SET_GPR(n)		(0x060040 + (n)*4)
#define PCR_CLR_GPR(n)		(0x060080 + (n)*4)

#endif /* __COMBO6_PCR_H */
