/*
 * sze2cv3.h: Driver for the ComboV3 card - SZE2 Interface definitions
 * Copyright (c) 2013-2014 CESNET
 * Author(s): Martin Spinler <spinler@cesnet.cz>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#ifndef SZE2CV3_H_FILE
#define SZE2CV3_H_FILE

#include <linux/bitops.h>

#define SZE2CV3_DMA_SIZE	0x40
#define SZE2CV3_DIR_SIZE	0x1000

#define SZE2CV3_DIR_RX		0
#define SZE2CV3_DIR_TX		1

#define SZE2CV3_ADDR_BASE 	0xC000

#define SZE2CV3_CTL			0x00
#define SZE2CV3_CTL_STOP	0x0
#define SZE2CV3_CTL_START	0x1
#define SZE2CV3_CTL_DISCARD	0x2
#define SZE2CV3_CTL_STARTD	0x3

#define SZE2CV3_STAT		0x04
#define SZE2CV3_STAT_UNDEF	0x0
#define SZE2CV3_STAT_IDLE	0x1
#define SZE2CV3_STAT_RUNNING	0x2
#define SZE2CV3_STAT_PAUSE	0x4
#define SZE2CV3_STARTPTR	0x08
#define SZE2CV3_ENDPTR		0x0c
#define SZE2CV3_BUFSIZE		0x10
#define SZE2CV3_IRQ		0x14
#define SZE2CV3_IRQ_TIMEOUTE	0x1
#define SZE2CV3_IRQ_PTRE	0x2
#define SZE2CV3_IRQ_PTR(p)	((p) & ~0x3)
#define SZE2CV3_TIMEOUT		0x18
#define SZE2CV3_TIMEOUT_NS(ns)	((ns) / 5)
#define SZE2CV3_MAXSIZE		0x1C

#define SZE2CV3_DESCS_BASE	0x00003000
#define SZE2CV3_DESCS_SIZE	0x8

#define SZE2CV3_DESCS(dir, unit) \
	((((dir) * SZE2CV3_DESCS_SIZE) + \
	  ((unit) * 2 * SZE2CV3_DESCS_SIZE)) | \
	 SZE2CV3_DESCS_BASE)
#define SZE2CV3_DESCS_PTR	0x1

#define SZE2CV3_RX_IRQ		0x02280000
#define SZE2CV3_TX_IRQ		0x02280008

#define SZE2CV3_STATUS_SPACE 0

#define SZE2CV3_CONFIG_PHYS 0x3000

struct szedata2cv3 {
	struct szedata2 *sd;
	struct combo6 *combo;
	struct szedata2_block *desc;
	unsigned long base;
	unsigned int interfaces[2];
	unsigned int desc_pgs;
	unsigned int uzone2_valid[2];
	void * statusarea_virt;
	resource_size_t statusarea_phys;
	u8 uzone2[2][32];

	unsigned long swptr[2][32];
	unsigned long hwptr[2][32];
};

static inline unsigned long szedata2cv3_dma(struct szedata2cv3 *sdhw,
		unsigned int dir, unsigned int unit, unsigned long addr)
{
	return (dir * SZE2CV3_DIR_SIZE + unit * SZE2CV3_DMA_SIZE) |
		addr | sdhw->base;
}

#endif
