
#ifndef _SPACE_H_
#define _SPACE_H_

#define SPACE_MAGIC       's'
#define SPACE_IOC_MAX     8

typedef struct transaction {
	int pos;	/*position*/
	int len;
	char *data;
} t_transaction;	

#ifndef __iomem
	#define __iomem
#endif
typedef struct bio_transaction { /* burst io */
	void __iomem *addr;	/*address*/
	size_t len;
	char *data;
} t_biotransaction;	

typedef struct pac_transaction { /* burst io */
	u32 ifc_index;
} t_pactransaction;	


#define SPACE_IOC_GETPHYSADDR       _IO(SPACE_MAGIC, 1)      /*return mmaped phys page */
#define SPACE_IOC_WRITE				_IOWR(SPACE_MAGIC, 2, t_transaction*)
#define SPACE_IOC_READ				_IOWR(SPACE_MAGIC, 3, t_transaction*)
#define SPACE_IOC_BIOWRITE			_IOWR(SPACE_MAGIC, 4, t_biotransaction*)
#define SPACE_IOC_BIOREAD			_IOWR(SPACE_MAGIC, 5, t_biotransaction*)
#define SPACE_IOC_PACINIT			_IOWR(SPACE_MAGIC, 6, t_pactransaction*)
#define SPACE_IOC_PACSTR			_IOWR(SPACE_MAGIC, 7, t_pactransaction*)
#define SPACE_IOC_PACSTP			_IOWR(SPACE_MAGIC, 8, t_pactransaction*)

#endif
