#
# This file contains rules which are shared between multiple Makefiles.
#

# clean obsolete definitions
export-objs :=

# apply patches beforehand
prepare: $(clean-files)
	@for d in $(patsubst %/,%,$(filter %/, $(obj-y))) \
	          $(patsubst %/,%,$(filter %/, $(obj-m))) DUMMY; do \
	 if [ $$d != DUMMY ]; then $(MAKE) -C $$d prepare; fi; \
	done

ALL_MOBJS := $(filter-out $(obj-y), $(obj-m))
ALL_MOBJS := $(filter-out %/, $(ALL_MOBJS))
modules_install:
ifneq "$(strip $(ALL_MOBJS))" ""
	mkdir -p $(DESTDIR)$(moddir)/$(MODCURDIR)
	cp $(sort $(ALL_MOBJS:.o=.ko)) $(DESTDIR)$(moddir)/$(MODCURDIR)
endif
	@for d in $(patsubst %/,%,$(filter %/, $(obj-y))) \
	          $(patsubst %/,%,$(filter %/, $(obj-m))) DUMMY; do \
	 if [ $$d != DUMMY ]; then $(MAKE) -C $$d modules_install; fi; \
	done

# apply patches beforehand
cleanup:
	rm -f *.[oas] *.ko .*.cmd .*.d .*.tmp *.mod.c modules.order \
		$(clean-files)
	rm -rf .tmp_versions/
	@for d in $(patsubst %/,%,$(filter %/, $(obj-y))) \
	          $(patsubst %/,%,$(filter %/, $(obj-m))) DUMMY; do \
	 if [ $$d != DUMMY ]; then $(MAKE) -C $$d cleanup; fi; \
	done

.PHONY: mrproper
mrproper: cleanup
	rm -f *~ out.txt *.orig *.rej .#* .gdb_history
	@for d in $(patsubst %/,%,$(filter %/, $(obj-y))) \
	          $(patsubst %/,%,$(filter %/, $(obj-m))) DUMMY; do \
	 if [ $$d != DUMMY ]; then $(MAKE) -C $$d mrproper; fi; \
	done
