--!
--! sync_pgen.vhd: Synchronized enable pulse generator
--! Copyright (C) 2014 CESNET
--! Author(s): Jakub Cabal <jakubcabal@gmail.com>
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!
--! $Id$
--!
--! TODO:

library IEEE;	
use IEEE.std_logic_1164.all;	
use IEEE.std_logic_unsigned.all;	
use IEEE.std_logic_arith.all;

--! pragma translate_off
library UNISIM;
use UNISIM.vcomponents.all;
--! pragma translate_on

   --! -------------------------------------------------------------------------
   --!                      Entity declaration
   --! -------------------------------------------------------------------------

entity SYNC_PGEN is    
   Port (
      --! A clock domain           
      ACLK      : in  STD_LOGIC;   --! Source CLK
      ARST      : in  STD_LOGIC;   --! Source reset 
      ADATAIN   : in  STD_LOGIC;   --! Data input
      
      --! B clock domain 
      BCLK      : in  STD_LOGIC;   --! Target CLK
      BRST      : in  STD_LOGIC;   --! Target reset
      BEN       : out STD_LOGIC;   --! Enable pulse
      BDATAOUT  : out STD_LOGIC    --! Data output
   );
end SYNC_PGEN;

   --! -------------------------------------------------------------------------
   --!                      Architecture declaration
   --! -------------------------------------------------------------------------

architecture FULL of SYNC_PGEN is
   
   signal signal_D1    : std_logic;
   signal signal_Q1    : std_logic := '0';   
   
   --! ------------------------------------------------------------------------- 
begin
   --! -------------------------------------------------------------------------   
   
   --! Open-loop
   ASYNC_OPEN_LOOP: entity work.ASYNC_OPEN_LOOP
   generic map(
      IN_REG  => false,    --! We do not use!
      TWO_REG => false     --! Set three sync registers
   )  
   port map(
      ACLK     => ACLK,
      BCLK     => BCLK,
      ARST     => ARST,
      BRST     => BRST,
      ADATAIN  => ADATAIN,                
      BDATAOUT => signal_D1 
   ); 
   
   --! ------------------------------------------------------------------------- 
   
   process(BCLK)
   begin
      if (rising_edge(BCLK)) then
         if (BRST = '1') then
            signal_Q1 <= '0';
         else
            signal_Q1 <= signal_D1;  
         end if;             
      end if;
   end process;
  
   BDATAOUT <= signal_Q1;
   BEN      <= signal_D1 XOR signal_Q1;
   
   --! -------------------------------------------------------------------------

end architecture FULL;
