-- rc_int_ent.vhd: Requester Completion Interface connection - entity
-- Copyright (C) 2013 CESNET
-- Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------

entity rc_int is
   port(
      -- Common signals -------------------------------------------------------
      -- Clock signal
      CLK              : in  std_logic;
      -- Synchronous reset
      RESET            : in  std_logic;

      -- Requester Completion Interface (RC) - reduced version -------------------
      -- Data bus
      RC_DATA          : in  std_logic_vector(255 downto 0);
      -- Start of transaction
      RC_USER_SOF      : in  std_logic;
      -- Indication of the last word of a transaction
      RC_LAST          : in  std_logic;
      -- Indication of valid data
      -- each bit determines validity of different Dword (1 Dword = 4 Bytes)
      RC_KEEP          : in  std_logic_vector(7 downto 0);
      -- PCIe core sends valid data
      RC_VALID         : in  std_logic;
      -- User application is ready to receive a transaction
      RC_READY         : out std_logic;

      -- DMA-like interface to dma_down_int component ------------------------
      -- Transaction data
      DMA_DATA         : out std_logic_vector(255 downto 0);
      ----- Parts of transaction header (valid when SOP is valid) -----
      -- Number of dwords in the transaction
      DMA_HDR_DWORDS   : out std_logic_vector(10 downto 0);
      -- Start of transaction (valid when DMA_SRC_RDY = DMA_DST_RDY = 1)
      DMA_SOP          : out std_logic;
      -- End of transaction (valid when DMA_SRC_RDY = DMA_DST_RDY = 1)
      DMA_EOP          : out std_logic;
      -- Source is ready to transmit data
      DMA_SRC_RDY      : out std_logic;
      -- Destination is ready to receive data
      DMA_DST_RDY      : in  std_logic;
      -- PCIe transaction tag (valid when SOP is valid)
      PCIE_TAG         : out std_logic_vector(4 downto 0);
      -- Release command for PCIe tag mapping in tag_manager component
      -- (valid when SOP is valid)
      PCIE_TAG_RELEASE : out std_logic
   );
end entity rc_int;

