-- process_ent.vhd: CGMII_PROCESS entity.
-- Copyright (C) 2012 CESNET
-- Author(s): Vaclav Hummel <xhumme00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
--! Process component for CGMII OBUF
entity cgmii_obuf_process is
   generic (
      --! \brief FIFO Distributed RAM type
      --! \details Only 16,32,64 bits
      CRC32_FIFO_DISTMEM_TYPE : integer := 16;
      --! A number of items in the FIFO
      CRC32_FIFO_ITEMS        : integer := 16
   );
   port (
      -----------------------------------------------------
      --! \ name Common interface
      -----------------------------------------------------
      --! Input clock
      CLK         : in std_logic;
      --! Synchronous reset
      RESET       : in std_logic;

      -----------------------------------------------------
      --! \name FLU RX interface
      -----------------------------------------------------
      --! Write side data
      RX_DATA       	: in std_logic_vector(511 downto 0);
      --! Start of packet position
      RX_SOP_POS    	: in std_logic_vector(2 downto 0);
      --! End of packet position
      RX_EOP_POS    	: in std_logic_vector(5 downto 0);
      --! Start of packet valid
      RX_SOP        	: in std_logic;
      --! End of packet valid
      RX_EOP        	: in std_logic;
      --! Source ready
      RX_SRC_RDY    	: in std_logic;
      --! Destination ready
      RX_DST_RDY    	: out std_logic;
      
      -----------------------------------------------------
      --! \name TX output interface 
      -----------------------------------------------------
      --! Read side ready
      TX_DATA        : out std_logic_vector(511 downto 0);
      --! SOP block indication (one-hot)
      TX_SOP_V       : out std_logic_vector(7 downto 0);
      --! EOP block indication (one-hot)
      TX_EOP_V       : out std_logic_vector(7 downto 0);
      --! End in block position
      TX_EOP_POS     : out std_logic_vector(2 downto 0);

      -----------------------------------------------------
      --! \name CRC32 FIFO interface
      -----------------------------------------------------
      --! CRC32 FIFO output
      CRC32_DATA_OUT : out std_logic_vector(31 downto 0);
      --! CRC32 FIFO read request
      CRC32_READ_REQ : in std_logic
      
   );
end entity cgmii_obuf_process;
