-- led_ctrl_ent.vhd: LED controler - entity declaration
-- Copyright (C) 2009 CESNET
-- Author(s): Libor Polcak <polcak_l@liberouter.org>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

-- ----------------------------------------------------------------------------
--                      Entity declaration
-- ----------------------------------------------------------------------------
entity led_ctrl is

   generic (
      -- Length of the internal counter, determines period of blinks
      CNTR_SIZE            : integer := 25
   );

   port (
      -- Clock signal
      CLK                  : in std_logic;
      -- Global synchronous reset
      RESET                : in  std_logic;

      -- '1' when coresponding line is up, '0' otherwise
      LINE_UP              : in std_logic;
      -- '1' when packet is being processed, '0' otherwise
      PACKET               : in std_logic;

      -- Determines if the LED should be on '0' or not '1'
      LED                  : out std_logic;
      -- Determines if the LED is currently blinking
      -- (because of activity on PACKET port)
      BLINKING             : out std_logic

   );

end entity led_ctrl;
