-- crc16_152.vhd: A 16-bit CRC table for processing 152 bits in parallel
-- Copyright (C) 2012 Brno University of Technology
-- Author(s): Lukas Kekely <xkekel00@stud.fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: crc16_152.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity crc16_152 is
   port(
      DI    : in  std_logic_vector(152-1 downto 0);
      DO    : out std_logic_vector(15 downto 0)
   );
end entity;

-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ansi of crc16_152 is
begin
-- 16-bit CRC equations processing 152 bits in parallel (VHDL code)
-- Generator polynomial: 0x18005
   DO(0) <= DI(49) XOR DI(25) XOR DI(53) XOR DI(81) XOR DI(109) XOR DI(10) XOR DI(66) XOR DI(51) XOR DI(2) XOR DI(17) XOR DI(32) XOR DI(47) XOR DI(62) XOR DI(77) XOR DI(92) XOR DI(107) XOR DI(122) XOR DI(137) XOR DI(24) XOR DI(80) XOR DI(9) XOR DI(65) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(61) XOR DI(76) XOR DI(91) XOR DI(106) XOR DI(121) XOR DI(136) XOR DI(23) XOR DI(79) XOR DI(8) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(60) XOR DI(75) XOR DI(90) XOR DI(105) XOR DI(120) XOR DI(135) XOR DI(22) XOR DI(7) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(59) XOR DI(74) XOR DI(89) XOR DI(104) XOR DI(119) XOR DI(134) XOR DI(21) XOR DI(6) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(73) XOR DI(88) XOR DI(103) XOR DI(118) XOR DI(133) XOR DI(20) XOR DI(5) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(102) XOR DI(117) XOR DI(132) XOR DI(19) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(101) XOR DI(116) XOR DI(131) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(100) XOR DI(115) XOR DI(130) XOR DI(69) XOR DI(84) XOR DI(99) XOR DI(114) XOR DI(129) XOR DI(83) XOR DI(98) XOR DI(113) XOR DI(128) XOR DI(97) XOR DI(112) XOR DI(127) XOR DI(111) XOR DI(126) XOR DI(125) XOR DI(139) XOR DI(140) XOR DI(141) XOR DI(142) XOR DI(143) XOR DI(144) XOR DI(145) XOR DI(146) XOR DI(147) XOR DI(148) XOR DI(149) XOR DI(150) XOR DI(151);
   DO(1) <= DI(51) XOR DI(65) XOR DI(50) XOR DI(13) XOR DI(5) XOR DI(27) XOR DI(26) XOR DI(41) XOR DI(55) XOR DI(54) XOR DI(69) XOR DI(83) XOR DI(82) XOR DI(97) XOR DI(111) XOR DI(110) XOR DI(125) XOR DI(53) XOR DI(19) XOR DI(49) XOR DI(79) XOR DI(109) XOR DI(11) XOR DI(67) XOR DI(52) XOR DI(3) XOR DI(18) XOR DI(33) XOR DI(48) XOR DI(63) XOR DI(78) XOR DI(93) XOR DI(108) XOR DI(123) XOR DI(138) XOR DI(139);
   DO(2) <= DI(52) XOR DI(66) XOR DI(51) XOR DI(0) XOR DI(14) XOR DI(6) XOR DI(28) XOR DI(27) XOR DI(42) XOR DI(56) XOR DI(55) XOR DI(70) XOR DI(84) XOR DI(83) XOR DI(98) XOR DI(112) XOR DI(111) XOR DI(126) XOR DI(54) XOR DI(20) XOR DI(50) XOR DI(80) XOR DI(110) XOR DI(12) XOR DI(68) XOR DI(53) XOR DI(4) XOR DI(19) XOR DI(34) XOR DI(49) XOR DI(64) XOR DI(79) XOR DI(94) XOR DI(109) XOR DI(124) XOR DI(139) XOR DI(140);
   DO(3) <= DI(53) XOR DI(67) XOR DI(52) XOR DI(1) XOR DI(0) XOR DI(15) XOR DI(7) XOR DI(29) XOR DI(28) XOR DI(43) XOR DI(57) XOR DI(56) XOR DI(71) XOR DI(85) XOR DI(84) XOR DI(99) XOR DI(113) XOR DI(112) XOR DI(127) XOR DI(55) XOR DI(21) XOR DI(51) XOR DI(81) XOR DI(111) XOR DI(13) XOR DI(69) XOR DI(54) XOR DI(5) XOR DI(20) XOR DI(35) XOR DI(50) XOR DI(65) XOR DI(80) XOR DI(95) XOR DI(110) XOR DI(125) XOR DI(140) XOR DI(141);
   DO(4) <= DI(54) XOR DI(68) XOR DI(53) XOR DI(2) XOR DI(1) XOR DI(16) XOR DI(8) XOR DI(30) XOR DI(29) XOR DI(44) XOR DI(58) XOR DI(57) XOR DI(72) XOR DI(86) XOR DI(85) XOR DI(100) XOR DI(114) XOR DI(113) XOR DI(128) XOR DI(0) XOR DI(56) XOR DI(22) XOR DI(52) XOR DI(82) XOR DI(112) XOR DI(14) XOR DI(70) XOR DI(55) XOR DI(6) XOR DI(21) XOR DI(36) XOR DI(51) XOR DI(66) XOR DI(81) XOR DI(96) XOR DI(111) XOR DI(126) XOR DI(141) XOR DI(142);
   DO(5) <= DI(55) XOR DI(69) XOR DI(54) XOR DI(3) XOR DI(2) XOR DI(17) XOR DI(9) XOR DI(31) XOR DI(30) XOR DI(45) XOR DI(59) XOR DI(58) XOR DI(73) XOR DI(87) XOR DI(86) XOR DI(101) XOR DI(115) XOR DI(114) XOR DI(129) XOR DI(1) XOR DI(57) XOR DI(23) XOR DI(53) XOR DI(83) XOR DI(113) XOR DI(15) XOR DI(71) XOR DI(0) XOR DI(56) XOR DI(7) XOR DI(22) XOR DI(37) XOR DI(52) XOR DI(67) XOR DI(82) XOR DI(97) XOR DI(112) XOR DI(127) XOR DI(142) XOR DI(143);
   DO(6) <= DI(56) XOR DI(70) XOR DI(55) XOR DI(4) XOR DI(3) XOR DI(18) XOR DI(10) XOR DI(32) XOR DI(31) XOR DI(46) XOR DI(60) XOR DI(59) XOR DI(74) XOR DI(88) XOR DI(87) XOR DI(102) XOR DI(116) XOR DI(115) XOR DI(130) XOR DI(2) XOR DI(58) XOR DI(24) XOR DI(54) XOR DI(84) XOR DI(114) XOR DI(16) XOR DI(72) XOR DI(1) XOR DI(57) XOR DI(8) XOR DI(23) XOR DI(38) XOR DI(53) XOR DI(68) XOR DI(83) XOR DI(98) XOR DI(113) XOR DI(128) XOR DI(143) XOR DI(144);
   DO(7) <= DI(57) XOR DI(71) XOR DI(56) XOR DI(5) XOR DI(4) XOR DI(19) XOR DI(11) XOR DI(33) XOR DI(32) XOR DI(47) XOR DI(61) XOR DI(60) XOR DI(75) XOR DI(89) XOR DI(88) XOR DI(103) XOR DI(117) XOR DI(116) XOR DI(131) XOR DI(3) XOR DI(59) XOR DI(25) XOR DI(55) XOR DI(85) XOR DI(115) XOR DI(17) XOR DI(73) XOR DI(2) XOR DI(58) XOR DI(9) XOR DI(24) XOR DI(39) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(99) XOR DI(114) XOR DI(129) XOR DI(144) XOR DI(145);
   DO(8) <= DI(58) XOR DI(72) XOR DI(57) XOR DI(6) XOR DI(5) XOR DI(20) XOR DI(12) XOR DI(34) XOR DI(33) XOR DI(48) XOR DI(62) XOR DI(61) XOR DI(76) XOR DI(90) XOR DI(89) XOR DI(104) XOR DI(118) XOR DI(117) XOR DI(132) XOR DI(4) XOR DI(60) XOR DI(26) XOR DI(56) XOR DI(86) XOR DI(116) XOR DI(18) XOR DI(74) XOR DI(3) XOR DI(59) XOR DI(10) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(100) XOR DI(115) XOR DI(130) XOR DI(145) XOR DI(146);
   DO(9) <= DI(59) XOR DI(73) XOR DI(58) XOR DI(7) XOR DI(6) XOR DI(21) XOR DI(13) XOR DI(35) XOR DI(34) XOR DI(49) XOR DI(63) XOR DI(62) XOR DI(77) XOR DI(91) XOR DI(90) XOR DI(105) XOR DI(119) XOR DI(118) XOR DI(133) XOR DI(5) XOR DI(61) XOR DI(27) XOR DI(57) XOR DI(87) XOR DI(117) XOR DI(19) XOR DI(75) XOR DI(4) XOR DI(60) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(101) XOR DI(116) XOR DI(131) XOR DI(146) XOR DI(147);
   DO(10) <= DI(60) XOR DI(74) XOR DI(59) XOR DI(8) XOR DI(0) XOR DI(7) XOR DI(22) XOR DI(14) XOR DI(36) XOR DI(35) XOR DI(50) XOR DI(64) XOR DI(63) XOR DI(78) XOR DI(92) XOR DI(91) XOR DI(106) XOR DI(120) XOR DI(119) XOR DI(134) XOR DI(6) XOR DI(62) XOR DI(28) XOR DI(58) XOR DI(88) XOR DI(118) XOR DI(20) XOR DI(76) XOR DI(5) XOR DI(61) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(102) XOR DI(117) XOR DI(132) XOR DI(147) XOR DI(148);
   DO(11) <= DI(61) XOR DI(75) XOR DI(60) XOR DI(9) XOR DI(1) XOR DI(8) XOR DI(23) XOR DI(15) XOR DI(0) XOR DI(37) XOR DI(36) XOR DI(51) XOR DI(65) XOR DI(64) XOR DI(79) XOR DI(93) XOR DI(92) XOR DI(107) XOR DI(121) XOR DI(120) XOR DI(135) XOR DI(7) XOR DI(63) XOR DI(29) XOR DI(59) XOR DI(89) XOR DI(119) XOR DI(21) XOR DI(77) XOR DI(6) XOR DI(62) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(73) XOR DI(88) XOR DI(103) XOR DI(118) XOR DI(133) XOR DI(148) XOR DI(149);
   DO(12) <= DI(62) XOR DI(76) XOR DI(61) XOR DI(10) XOR DI(2) XOR DI(9) XOR DI(24) XOR DI(16) XOR DI(1) XOR DI(38) XOR DI(37) XOR DI(52) XOR DI(66) XOR DI(65) XOR DI(80) XOR DI(94) XOR DI(93) XOR DI(108) XOR DI(122) XOR DI(121) XOR DI(136) XOR DI(8) XOR DI(64) XOR DI(0) XOR DI(30) XOR DI(60) XOR DI(90) XOR DI(120) XOR DI(22) XOR DI(78) XOR DI(7) XOR DI(63) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(59) XOR DI(74) XOR DI(89) XOR DI(104) XOR DI(119) XOR DI(134) XOR DI(149) XOR DI(150);
   DO(13) <= DI(63) XOR DI(77) XOR DI(62) XOR DI(11) XOR DI(3) XOR DI(10) XOR DI(25) XOR DI(17) XOR DI(2) XOR DI(39) XOR DI(38) XOR DI(53) XOR DI(67) XOR DI(66) XOR DI(81) XOR DI(95) XOR DI(94) XOR DI(109) XOR DI(123) XOR DI(122) XOR DI(137) XOR DI(9) XOR DI(65) XOR DI(1) XOR DI(31) XOR DI(61) XOR DI(91) XOR DI(121) XOR DI(23) XOR DI(79) XOR DI(8) XOR DI(64) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(60) XOR DI(75) XOR DI(90) XOR DI(105) XOR DI(120) XOR DI(135) XOR DI(150) XOR DI(151);
   DO(14) <= DI(47) XOR DI(23) XOR DI(51) XOR DI(79) XOR DI(107) XOR DI(8) XOR DI(64) XOR DI(49) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(60) XOR DI(75) XOR DI(90) XOR DI(105) XOR DI(120) XOR DI(135) XOR DI(22) XOR DI(78) XOR DI(7) XOR DI(63) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(59) XOR DI(74) XOR DI(89) XOR DI(104) XOR DI(119) XOR DI(134) XOR DI(21) XOR DI(77) XOR DI(6) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(73) XOR DI(88) XOR DI(103) XOR DI(118) XOR DI(133) XOR DI(20) XOR DI(5) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(102) XOR DI(117) XOR DI(132) XOR DI(19) XOR DI(4) XOR DI(11) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(101) XOR DI(116) XOR DI(131) XOR DI(18) XOR DI(3) XOR DI(25) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(100) XOR DI(115) XOR DI(130) XOR DI(17) XOR DI(39) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(99) XOR DI(114) XOR DI(129) XOR DI(53) XOR DI(68) XOR DI(83) XOR DI(98) XOR DI(113) XOR DI(128) XOR DI(67) XOR DI(82) XOR DI(97) XOR DI(112) XOR DI(127) XOR DI(81) XOR DI(96) XOR DI(111) XOR DI(126) XOR DI(95) XOR DI(110) XOR DI(125) XOR DI(109) XOR DI(124) XOR DI(123) XOR DI(137) XOR DI(138) XOR DI(139) XOR DI(140) XOR DI(141) XOR DI(142) XOR DI(143) XOR DI(144) XOR DI(145) XOR DI(146) XOR DI(147) XOR DI(148) XOR DI(149) XOR DI(150);
   DO(15) <= DI(48) XOR DI(24) XOR DI(52) XOR DI(80) XOR DI(108) XOR DI(9) XOR DI(65) XOR DI(50) XOR DI(1) XOR DI(16) XOR DI(31) XOR DI(46) XOR DI(61) XOR DI(76) XOR DI(91) XOR DI(106) XOR DI(121) XOR DI(136) XOR DI(23) XOR DI(79) XOR DI(8) XOR DI(64) XOR DI(0) XOR DI(15) XOR DI(30) XOR DI(45) XOR DI(60) XOR DI(75) XOR DI(90) XOR DI(105) XOR DI(120) XOR DI(135) XOR DI(22) XOR DI(78) XOR DI(7) XOR DI(14) XOR DI(29) XOR DI(44) XOR DI(59) XOR DI(74) XOR DI(89) XOR DI(104) XOR DI(119) XOR DI(134) XOR DI(21) XOR DI(6) XOR DI(13) XOR DI(28) XOR DI(43) XOR DI(58) XOR DI(73) XOR DI(88) XOR DI(103) XOR DI(118) XOR DI(133) XOR DI(20) XOR DI(5) XOR DI(12) XOR DI(27) XOR DI(42) XOR DI(57) XOR DI(72) XOR DI(87) XOR DI(102) XOR DI(117) XOR DI(132) XOR DI(19) XOR DI(4) XOR DI(26) XOR DI(41) XOR DI(56) XOR DI(71) XOR DI(86) XOR DI(101) XOR DI(116) XOR DI(131) XOR DI(18) XOR DI(40) XOR DI(55) XOR DI(70) XOR DI(85) XOR DI(100) XOR DI(115) XOR DI(130) XOR DI(54) XOR DI(69) XOR DI(84) XOR DI(99) XOR DI(114) XOR DI(129) XOR DI(68) XOR DI(83) XOR DI(98) XOR DI(113) XOR DI(128) XOR DI(82) XOR DI(97) XOR DI(112) XOR DI(127) XOR DI(96) XOR DI(111) XOR DI(126) XOR DI(110) XOR DI(125) XOR DI(124) XOR DI(138) XOR DI(139) XOR DI(140) XOR DI(141) XOR DI(142) XOR DI(143) XOR DI(144) XOR DI(145) XOR DI(146) XOR DI(147) XOR DI(148) XOR DI(149) XOR DI(150) XOR DI(151);
 
end architecture;




-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------
architecture arch_ccitt of crc16_152 is
begin
-- 16-bit CRC equations processing 152 bits in parallel (VHDL code)
-- Generator polynomial: 0x11021
   DO(0) <= DI(56) XOR DI(72) XOR DI(13) XOR DI(87) XOR DI(54) XOR DI(101) XOR DI(88) XOR DI(94) XOR DI(29) XOR DI(103) XOR DI(70) XOR DI(15) XOR DI(117) XOR DI(125) XOR DI(104) XOR DI(110) XOR DI(48) XOR DI(80) XOR DI(124) XOR DI(132) XOR DI(45) XOR DI(43) XOR DI(77) XOR DI(37) XOR DI(34) XOR DI(119) XOR DI(46) XOR DI(75) XOR DI(20) XOR DI(130) XOR DI(57) XOR DI(86) XOR DI(14) XOR DI(89) XOR DI(31) XOR DI(1) XOR DI(133) XOR DI(141) XOR DI(68) XOR DI(9) XOR DI(97) XOR DI(25) XOR DI(66) XOR DI(11) XOR DI(100) XOR DI(44) XOR DI(120) XOR DI(39) XOR DI(42) XOR DI(71) XOR DI(16) XOR DI(126) XOR DI(82) XOR DI(10) XOR DI(85) XOR DI(64) XOR DI(7) XOR DI(96) XOR DI(12) XOR DI(78) XOR DI(6) XOR DI(8) XOR DI(4) XOR DI(0) XOR DI(140) XOR DI(144) XOR DI(148);
   DO(1) <= DI(57) XOR DI(73) XOR DI(14) XOR DI(88) XOR DI(55) XOR DI(102) XOR DI(89) XOR DI(95) XOR DI(30) XOR DI(104) XOR DI(71) XOR DI(16) XOR DI(118) XOR DI(126) XOR DI(105) XOR DI(111) XOR DI(49) XOR DI(81) XOR DI(125) XOR DI(133) XOR DI(46) XOR DI(44) XOR DI(78) XOR DI(38) XOR DI(35) XOR DI(120) XOR DI(47) XOR DI(76) XOR DI(21) XOR DI(131) XOR DI(58) XOR DI(87) XOR DI(15) XOR DI(90) XOR DI(32) XOR DI(2) XOR DI(134) XOR DI(142) XOR DI(69) XOR DI(10) XOR DI(98) XOR DI(26) XOR DI(67) XOR DI(12) XOR DI(101) XOR DI(45) XOR DI(121) XOR DI(40) XOR DI(43) XOR DI(72) XOR DI(17) XOR DI(127) XOR DI(83) XOR DI(11) XOR DI(86) XOR DI(65) XOR DI(8) XOR DI(97) XOR DI(13) XOR DI(79) XOR DI(7) XOR DI(9) XOR DI(5) XOR DI(1) XOR DI(141) XOR DI(145) XOR DI(149);
   DO(2) <= DI(58) XOR DI(74) XOR DI(15) XOR DI(89) XOR DI(56) XOR DI(103) XOR DI(90) XOR DI(96) XOR DI(31) XOR DI(105) XOR DI(72) XOR DI(17) XOR DI(119) XOR DI(127) XOR DI(106) XOR DI(112) XOR DI(50) XOR DI(82) XOR DI(126) XOR DI(134) XOR DI(47) XOR DI(45) XOR DI(79) XOR DI(39) XOR DI(36) XOR DI(121) XOR DI(48) XOR DI(77) XOR DI(22) XOR DI(132) XOR DI(59) XOR DI(88) XOR DI(16) XOR DI(91) XOR DI(33) XOR DI(3) XOR DI(135) XOR DI(143) XOR DI(70) XOR DI(11) XOR DI(99) XOR DI(27) XOR DI(68) XOR DI(13) XOR DI(102) XOR DI(46) XOR DI(122) XOR DI(41) XOR DI(44) XOR DI(73) XOR DI(18) XOR DI(128) XOR DI(84) XOR DI(12) XOR DI(87) XOR DI(66) XOR DI(9) XOR DI(98) XOR DI(14) XOR DI(80) XOR DI(8) XOR DI(10) XOR DI(6) XOR DI(2) XOR DI(142) XOR DI(146) XOR DI(150);
   DO(3) <= DI(59) XOR DI(75) XOR DI(16) XOR DI(90) XOR DI(57) XOR DI(104) XOR DI(91) XOR DI(97) XOR DI(32) XOR DI(106) XOR DI(73) XOR DI(18) XOR DI(120) XOR DI(128) XOR DI(107) XOR DI(113) XOR DI(51) XOR DI(83) XOR DI(127) XOR DI(135) XOR DI(48) XOR DI(46) XOR DI(80) XOR DI(40) XOR DI(37) XOR DI(122) XOR DI(49) XOR DI(78) XOR DI(23) XOR DI(133) XOR DI(60) XOR DI(89) XOR DI(17) XOR DI(92) XOR DI(34) XOR DI(4) XOR DI(136) XOR DI(144) XOR DI(71) XOR DI(12) XOR DI(100) XOR DI(28) XOR DI(69) XOR DI(14) XOR DI(103) XOR DI(47) XOR DI(123) XOR DI(42) XOR DI(45) XOR DI(74) XOR DI(19) XOR DI(129) XOR DI(85) XOR DI(13) XOR DI(88) XOR DI(0) XOR DI(67) XOR DI(10) XOR DI(99) XOR DI(15) XOR DI(81) XOR DI(9) XOR DI(11) XOR DI(7) XOR DI(3) XOR DI(143) XOR DI(147) XOR DI(151);
   DO(4) <= DI(44) XOR DI(60) XOR DI(42) XOR DI(76) XOR DI(17) XOR DI(91) XOR DI(58) XOR DI(105) XOR DI(92) XOR DI(98) XOR DI(120) XOR DI(33) XOR DI(31) XOR DI(25) XOR DI(107) XOR DI(34) XOR DI(45) XOR DI(74) XOR DI(77) XOR DI(19) XOR DI(121) XOR DI(129) XOR DI(56) XOR DI(85) XOR DI(54) XOR DI(88) XOR DI(108) XOR DI(114) XOR DI(52) XOR DI(84) XOR DI(66) XOR DI(128) XOR DI(132) XOR DI(136) XOR DI(140) XOR DI(49) XOR DI(6) XOR DI(80) XOR DI(47) XOR DI(94) XOR DI(81) XOR DI(87) XOR DI(96) XOR DI(110) XOR DI(97) XOR DI(103) XOR DI(41) XOR DI(117) XOR DI(125) XOR DI(38) XOR DI(39) XOR DI(123) XOR DI(50) XOR DI(79) XOR DI(7) XOR DI(24) XOR DI(126) XOR DI(134) XOR DI(61) XOR DI(90) XOR DI(18) XOR DI(93) XOR DI(37) XOR DI(35) XOR DI(64) XOR DI(9) XOR DI(119) XOR DI(78) XOR DI(57) XOR DI(5) XOR DI(71) XOR DI(133) XOR DI(137) XOR DI(141) XOR DI(145);
   DO(5) <= DI(45) XOR DI(61) XOR DI(43) XOR DI(77) XOR DI(18) XOR DI(92) XOR DI(59) XOR DI(106) XOR DI(93) XOR DI(99) XOR DI(121) XOR DI(34) XOR DI(32) XOR DI(26) XOR DI(108) XOR DI(35) XOR DI(46) XOR DI(75) XOR DI(78) XOR DI(20) XOR DI(122) XOR DI(130) XOR DI(57) XOR DI(86) XOR DI(55) XOR DI(89) XOR DI(109) XOR DI(115) XOR DI(53) XOR DI(85) XOR DI(67) XOR DI(129) XOR DI(133) XOR DI(137) XOR DI(141) XOR DI(50) XOR DI(7) XOR DI(81) XOR DI(48) XOR DI(95) XOR DI(82) XOR DI(88) XOR DI(97) XOR DI(111) XOR DI(98) XOR DI(104) XOR DI(42) XOR DI(118) XOR DI(126) XOR DI(39) XOR DI(40) XOR DI(124) XOR DI(51) XOR DI(80) XOR DI(8) XOR DI(25) XOR DI(127) XOR DI(135) XOR DI(62) XOR DI(91) XOR DI(19) XOR DI(94) XOR DI(38) XOR DI(36) XOR DI(65) XOR DI(10) XOR DI(120) XOR DI(79) XOR DI(58) XOR DI(6) XOR DI(72) XOR DI(134) XOR DI(138) XOR DI(142) XOR DI(146);
   DO(6) <= DI(46) XOR DI(62) XOR DI(44) XOR DI(78) XOR DI(19) XOR DI(93) XOR DI(60) XOR DI(107) XOR DI(94) XOR DI(100) XOR DI(122) XOR DI(35) XOR DI(33) XOR DI(27) XOR DI(109) XOR DI(36) XOR DI(47) XOR DI(76) XOR DI(79) XOR DI(21) XOR DI(123) XOR DI(131) XOR DI(58) XOR DI(87) XOR DI(56) XOR DI(90) XOR DI(110) XOR DI(116) XOR DI(0) XOR DI(54) XOR DI(86) XOR DI(68) XOR DI(130) XOR DI(134) XOR DI(138) XOR DI(142) XOR DI(51) XOR DI(8) XOR DI(82) XOR DI(49) XOR DI(96) XOR DI(83) XOR DI(89) XOR DI(98) XOR DI(112) XOR DI(99) XOR DI(105) XOR DI(43) XOR DI(119) XOR DI(127) XOR DI(40) XOR DI(41) XOR DI(125) XOR DI(52) XOR DI(81) XOR DI(9) XOR DI(26) XOR DI(128) XOR DI(136) XOR DI(63) XOR DI(92) XOR DI(20) XOR DI(95) XOR DI(39) XOR DI(37) XOR DI(66) XOR DI(11) XOR DI(121) XOR DI(80) XOR DI(59) XOR DI(7) XOR DI(73) XOR DI(135) XOR DI(139) XOR DI(143) XOR DI(147);
   DO(7) <= DI(47) XOR DI(63) XOR DI(45) XOR DI(79) XOR DI(20) XOR DI(94) XOR DI(61) XOR DI(108) XOR DI(95) XOR DI(101) XOR DI(123) XOR DI(36) XOR DI(34) XOR DI(28) XOR DI(110) XOR DI(37) XOR DI(48) XOR DI(77) XOR DI(80) XOR DI(22) XOR DI(124) XOR DI(132) XOR DI(59) XOR DI(88) XOR DI(57) XOR DI(91) XOR DI(111) XOR DI(117) XOR DI(1) XOR DI(55) XOR DI(87) XOR DI(69) XOR DI(131) XOR DI(135) XOR DI(139) XOR DI(143) XOR DI(52) XOR DI(9) XOR DI(83) XOR DI(50) XOR DI(97) XOR DI(84) XOR DI(90) XOR DI(99) XOR DI(113) XOR DI(100) XOR DI(106) XOR DI(44) XOR DI(120) XOR DI(128) XOR DI(41) XOR DI(42) XOR DI(126) XOR DI(53) XOR DI(82) XOR DI(10) XOR DI(27) XOR DI(129) XOR DI(137) XOR DI(64) XOR DI(93) XOR DI(21) XOR DI(96) XOR DI(40) XOR DI(38) XOR DI(67) XOR DI(12) XOR DI(122) XOR DI(81) XOR DI(60) XOR DI(8) XOR DI(74) XOR DI(136) XOR DI(140) XOR DI(144) XOR DI(148);
   DO(8) <= DI(48) XOR DI(64) XOR DI(46) XOR DI(80) XOR DI(21) XOR DI(95) XOR DI(62) XOR DI(109) XOR DI(96) XOR DI(102) XOR DI(124) XOR DI(37) XOR DI(35) XOR DI(29) XOR DI(111) XOR DI(38) XOR DI(49) XOR DI(78) XOR DI(81) XOR DI(23) XOR DI(125) XOR DI(133) XOR DI(60) XOR DI(89) XOR DI(58) XOR DI(92) XOR DI(112) XOR DI(118) XOR DI(2) XOR DI(56) XOR DI(88) XOR DI(70) XOR DI(0) XOR DI(132) XOR DI(136) XOR DI(140) XOR DI(144) XOR DI(53) XOR DI(10) XOR DI(84) XOR DI(51) XOR DI(98) XOR DI(85) XOR DI(91) XOR DI(100) XOR DI(114) XOR DI(101) XOR DI(107) XOR DI(45) XOR DI(121) XOR DI(129) XOR DI(42) XOR DI(43) XOR DI(127) XOR DI(54) XOR DI(83) XOR DI(11) XOR DI(28) XOR DI(130) XOR DI(138) XOR DI(65) XOR DI(94) XOR DI(22) XOR DI(97) XOR DI(41) XOR DI(39) XOR DI(68) XOR DI(13) XOR DI(123) XOR DI(82) XOR DI(61) XOR DI(9) XOR DI(75) XOR DI(137) XOR DI(141) XOR DI(145) XOR DI(149);
   DO(9) <= DI(49) XOR DI(65) XOR DI(47) XOR DI(81) XOR DI(22) XOR DI(96) XOR DI(63) XOR DI(110) XOR DI(97) XOR DI(103) XOR DI(125) XOR DI(38) XOR DI(36) XOR DI(30) XOR DI(112) XOR DI(39) XOR DI(50) XOR DI(79) XOR DI(82) XOR DI(24) XOR DI(126) XOR DI(134) XOR DI(61) XOR DI(90) XOR DI(59) XOR DI(93) XOR DI(113) XOR DI(119) XOR DI(3) XOR DI(57) XOR DI(0) XOR DI(89) XOR DI(71) XOR DI(1) XOR DI(133) XOR DI(137) XOR DI(141) XOR DI(145) XOR DI(54) XOR DI(11) XOR DI(85) XOR DI(52) XOR DI(99) XOR DI(86) XOR DI(92) XOR DI(101) XOR DI(115) XOR DI(102) XOR DI(108) XOR DI(46) XOR DI(122) XOR DI(130) XOR DI(43) XOR DI(44) XOR DI(128) XOR DI(55) XOR DI(84) XOR DI(12) XOR DI(29) XOR DI(131) XOR DI(139) XOR DI(66) XOR DI(95) XOR DI(23) XOR DI(98) XOR DI(42) XOR DI(40) XOR DI(69) XOR DI(14) XOR DI(124) XOR DI(83) XOR DI(62) XOR DI(10) XOR DI(76) XOR DI(138) XOR DI(142) XOR DI(146) XOR DI(150);
   DO(10) <= DI(50) XOR DI(66) XOR DI(48) XOR DI(82) XOR DI(23) XOR DI(97) XOR DI(64) XOR DI(111) XOR DI(98) XOR DI(104) XOR DI(126) XOR DI(39) XOR DI(37) XOR DI(31) XOR DI(113) XOR DI(40) XOR DI(51) XOR DI(80) XOR DI(83) XOR DI(25) XOR DI(127) XOR DI(135) XOR DI(62) XOR DI(91) XOR DI(60) XOR DI(94) XOR DI(114) XOR DI(120) XOR DI(4) XOR DI(58) XOR DI(1) XOR DI(90) XOR DI(72) XOR DI(2) XOR DI(134) XOR DI(138) XOR DI(142) XOR DI(146) XOR DI(55) XOR DI(12) XOR DI(86) XOR DI(53) XOR DI(100) XOR DI(87) XOR DI(93) XOR DI(102) XOR DI(116) XOR DI(103) XOR DI(109) XOR DI(47) XOR DI(123) XOR DI(131) XOR DI(44) XOR DI(45) XOR DI(129) XOR DI(56) XOR DI(85) XOR DI(13) XOR DI(30) XOR DI(132) XOR DI(140) XOR DI(67) XOR DI(96) XOR DI(24) XOR DI(99) XOR DI(43) XOR DI(41) XOR DI(70) XOR DI(15) XOR DI(125) XOR DI(84) XOR DI(63) XOR DI(11) XOR DI(77) XOR DI(139) XOR DI(143) XOR DI(147) XOR DI(151);
   DO(11) <= DI(51) XOR DI(67) XOR DI(8) XOR DI(82) XOR DI(49) XOR DI(96) XOR DI(83) XOR DI(89) XOR DI(24) XOR DI(98) XOR DI(65) XOR DI(10) XOR DI(112) XOR DI(120) XOR DI(99) XOR DI(105) XOR DI(43) XOR DI(75) XOR DI(119) XOR DI(127) XOR DI(40) XOR DI(38) XOR DI(72) XOR DI(32) XOR DI(29) XOR DI(114) XOR DI(41) XOR DI(70) XOR DI(15) XOR DI(125) XOR DI(52) XOR DI(81) XOR DI(9) XOR DI(84) XOR DI(26) XOR DI(128) XOR DI(136) XOR DI(63) XOR DI(4) XOR DI(92) XOR DI(20) XOR DI(61) XOR DI(6) XOR DI(95) XOR DI(39) XOR DI(115) XOR DI(34) XOR DI(37) XOR DI(66) XOR DI(11) XOR DI(121) XOR DI(77) XOR DI(5) XOR DI(80) XOR DI(59) XOR DI(2) XOR DI(91) XOR DI(7) XOR DI(73) XOR DI(1) XOR DI(3) XOR DI(135) XOR DI(139) XOR DI(143) XOR DI(147);
   DO(12) <= DI(52) XOR DI(68) XOR DI(9) XOR DI(83) XOR DI(50) XOR DI(97) XOR DI(84) XOR DI(90) XOR DI(25) XOR DI(99) XOR DI(66) XOR DI(11) XOR DI(113) XOR DI(121) XOR DI(100) XOR DI(106) XOR DI(44) XOR DI(76) XOR DI(120) XOR DI(128) XOR DI(41) XOR DI(39) XOR DI(73) XOR DI(33) XOR DI(30) XOR DI(115) XOR DI(42) XOR DI(71) XOR DI(16) XOR DI(126) XOR DI(53) XOR DI(82) XOR DI(10) XOR DI(85) XOR DI(27) XOR DI(129) XOR DI(137) XOR DI(64) XOR DI(5) XOR DI(93) XOR DI(21) XOR DI(62) XOR DI(7) XOR DI(96) XOR DI(40) XOR DI(116) XOR DI(35) XOR DI(38) XOR DI(67) XOR DI(12) XOR DI(122) XOR DI(78) XOR DI(6) XOR DI(81) XOR DI(60) XOR DI(3) XOR DI(92) XOR DI(8) XOR DI(74) XOR DI(2) XOR DI(4) XOR DI(0) XOR DI(136) XOR DI(140) XOR DI(144) XOR DI(148);
   DO(13) <= DI(53) XOR DI(69) XOR DI(10) XOR DI(84) XOR DI(51) XOR DI(98) XOR DI(85) XOR DI(91) XOR DI(26) XOR DI(100) XOR DI(67) XOR DI(12) XOR DI(114) XOR DI(122) XOR DI(101) XOR DI(107) XOR DI(45) XOR DI(77) XOR DI(121) XOR DI(129) XOR DI(42) XOR DI(40) XOR DI(74) XOR DI(34) XOR DI(31) XOR DI(116) XOR DI(43) XOR DI(72) XOR DI(17) XOR DI(127) XOR DI(54) XOR DI(83) XOR DI(11) XOR DI(86) XOR DI(28) XOR DI(130) XOR DI(138) XOR DI(65) XOR DI(6) XOR DI(94) XOR DI(22) XOR DI(63) XOR DI(8) XOR DI(97) XOR DI(41) XOR DI(117) XOR DI(36) XOR DI(39) XOR DI(68) XOR DI(13) XOR DI(123) XOR DI(79) XOR DI(7) XOR DI(82) XOR DI(61) XOR DI(4) XOR DI(93) XOR DI(9) XOR DI(75) XOR DI(3) XOR DI(5) XOR DI(1) XOR DI(137) XOR DI(141) XOR DI(145) XOR DI(149);
   DO(14) <= DI(54) XOR DI(70) XOR DI(11) XOR DI(85) XOR DI(52) XOR DI(99) XOR DI(86) XOR DI(92) XOR DI(27) XOR DI(101) XOR DI(68) XOR DI(13) XOR DI(115) XOR DI(123) XOR DI(102) XOR DI(108) XOR DI(46) XOR DI(78) XOR DI(122) XOR DI(130) XOR DI(43) XOR DI(41) XOR DI(75) XOR DI(35) XOR DI(32) XOR DI(117) XOR DI(44) XOR DI(73) XOR DI(18) XOR DI(128) XOR DI(55) XOR DI(84) XOR DI(12) XOR DI(87) XOR DI(29) XOR DI(131) XOR DI(139) XOR DI(66) XOR DI(7) XOR DI(95) XOR DI(23) XOR DI(64) XOR DI(9) XOR DI(98) XOR DI(42) XOR DI(118) XOR DI(37) XOR DI(40) XOR DI(69) XOR DI(14) XOR DI(124) XOR DI(80) XOR DI(8) XOR DI(83) XOR DI(62) XOR DI(5) XOR DI(94) XOR DI(10) XOR DI(76) XOR DI(4) XOR DI(6) XOR DI(2) XOR DI(138) XOR DI(142) XOR DI(146) XOR DI(150);
   DO(15) <= DI(55) XOR DI(71) XOR DI(12) XOR DI(86) XOR DI(53) XOR DI(100) XOR DI(87) XOR DI(93) XOR DI(28) XOR DI(102) XOR DI(69) XOR DI(14) XOR DI(116) XOR DI(124) XOR DI(103) XOR DI(109) XOR DI(47) XOR DI(79) XOR DI(123) XOR DI(131) XOR DI(44) XOR DI(42) XOR DI(76) XOR DI(36) XOR DI(33) XOR DI(118) XOR DI(45) XOR DI(74) XOR DI(19) XOR DI(129) XOR DI(56) XOR DI(85) XOR DI(13) XOR DI(88) XOR DI(30) XOR DI(0) XOR DI(132) XOR DI(140) XOR DI(67) XOR DI(8) XOR DI(96) XOR DI(24) XOR DI(65) XOR DI(10) XOR DI(99) XOR DI(43) XOR DI(119) XOR DI(38) XOR DI(41) XOR DI(70) XOR DI(15) XOR DI(125) XOR DI(81) XOR DI(9) XOR DI(84) XOR DI(63) XOR DI(6) XOR DI(95) XOR DI(11) XOR DI(77) XOR DI(5) XOR DI(7) XOR DI(3) XOR DI(139) XOR DI(143) XOR DI(147) XOR DI(151);
  
end architecture;