# host_int_general.xdc: General constraints for Host interface IP core
# Copyright (C) 2014 CESNET
# Author: Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the Company nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# This software is provided ``as is'', and any express or implied
# warranties, including, but not limited to, the implied warranties of
# merchantability and fitness for a particular purpose are disclaimed.
# In no event shall the company or contributors be liable for any
# direct, indirect, incidental, special, exemplary, or consequential
# damages (including, but not limited to, procurement of substitute
# goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether
# in contract, strict liability, or tort (including negligence or
# otherwise) arising in any way out of the use of this software, even
# if advised of the possibility of such damage.
#
# $Id$
#


# PCIE_SYS_RESET_N port constraints
###############################################################################

set_property PACKAGE_PIN T9           [get_ports {PCIE_SYS_RESET_N}]
set_property IOSTANDARD  LVCMOS12     [get_ports {PCIE_SYS_RESET_N}]
set_property PULLUP      TRUE         [get_ports {PCIE_SYS_RESET_N}]


# Constraints for differential clock input @ 125 MHz
###############################################################################

# ports placement
set_property PACKAGE_PIN AV18         [get_ports {CLK125_P}]
set_property PACKAGE_PIN AV17         [get_ports {CLK125_N}]

# ports I/O standard 
set_property IOSTANDARD  DIFF_SSTL135 [get_ports {CLK125_P}]
set_property IOSTANDARD  DIFF_SSTL135 [get_ports {CLK125_N}]

# clock definition
create_clock -name clk125 -period 8 [get_ports {CLK125_P}]
