-- host_int_const.vhd : Package with constants for host interface IP core
--!
--! \file
--! \brief Host interface IP core constants
--! \author Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--! \date 2014
--!
--! \section License
--!
--! Copyright (C) 2014 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!


library IEEE;
use IEEE.std_logic_1164.all;


-- ----------------------------------------------------------------------------
--                           Package declaration
-- ----------------------------------------------------------------------------

package host_int_const is

   --! Constants declaration
   -- -------------------------------------------------------------------------

   --! PCIe identification 
   constant PCIE_VENDOR_ID      : std_logic_vector(15 downto 0) := X"18EC";
   constant PCIE0_DEVICE_ID     : std_logic_vector(15 downto 0) := X"FBC0";
   constant PCIE1_DEVICE_ID     : std_logic_vector(15 downto 0) := X"FBC1";
   constant PCIE_SUB_VENDOR_ID  : std_logic_vector(15 downto 0) := X"18EC";
   constant PCIE0_SUB_DEVICE_ID : std_logic_vector(15 downto 0) := X"0800";
   constant PCIE1_SUB_DEVICE_ID : std_logic_vector(15 downto 0) := X"0800";

   --! Pipelines in the MI32 bus infrastructure
   constant ADC_IN_PIPE         : boolean := true;
   constant ADC_ID_PIPE         : boolean := true;
   constant ADC_BOOT_PIPE       : boolean := true;
   constant ADC_NET_PIPE        : boolean := true;
   constant ADC_DMA_PIPE        : boolean := true;
   constant ADC_ETH_PIPE        : boolean := true;
   constant ADC_USER_PIPE       : boolean := true;

   --! ID component constants
   constant ID_PROJECT          : std_logic_vector(15 downto 0)  := X"41C1";
   constant ID_SW_MAJOR         : std_logic_vector(7 downto 0)   := X"07";
   constant ID_SW_MINOR         : std_logic_vector(7 downto 0)   := X"01";
   constant ID_HW_MAJOR         : std_logic_vector(15 downto 0)  := X"0001";
   constant ID_HW_MINOR         : std_logic_vector(15 downto 0)  := X"0000";
   constant ID_TX_CHANNELS      : std_logic_vector(7 downto 0)   := X"02";
   constant ID_RX_CHANNELS      : std_logic_vector(7 downto 0)   := X"02";

   --! Maximum packets' MTU size
   constant MAX_MTU_RX          : std_logic_vector(31 downto 0) := X"00000FE0";
   constant MAX_MTU_TX          : std_logic_vector(31 downto 0) := X"00000FE0";

   --! Select whether single (false) or double (true) PCIe cores are used
   --! Synchronize your choice with definition of DOUBLE_PCIE variable in
   --! ./synth/Vivado.tcl (line 38)
   constant DOUBLE_PCIE         : boolean := false;

end host_int_const;


-- ----------------------------------------------------------------------------
--                              Package body
-- ----------------------------------------------------------------------------

package body host_int_const is
end host_int_const;
