-- dma_pkg.vhd: DMA Bus Package
-- Copyright (C) 2013 CESNET
-- Author: Martin Spinler <spinler@cesnet.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_textio.all;
use IEEE.numeric_std.all;
use std.textio.all;
use work.math_pack.all;

-- ----------------------------------------------------------------------------
--                        DMA Package
-- ----------------------------------------------------------------------------
package dma_pkg is

   subtype DMA_REQUEST_LENGTH is natural range 10 downto  0;
   subtype DMA_REQUEST_TYPE   is natural range 15 downto 11;
   subtype DMA_REQUEST_TAG    is natural range 23 downto 16;
   subtype DMA_REQUEST_UNITID is natural range 31 downto 24;
   subtype DMA_REQUEST_GLOBAL is natural range 95 downto 32;

   constant DMA_TYPE_WRITE    : std_logic_vector(4 downto 0) := "00001";
   constant DMA_TYPE_READ     : std_logic_vector(4 downto 0) := "00000";
   constant DMA_TYPE_FLUSH    : std_logic_vector(4 downto 0) := "10000";

   constant DMA_RXHDR_WIDTH   : integer := 32;
   constant DMA_TXHDR_WIDTH   : integer := 96;
   constant DMA_DOWNHDR_WIDTH : integer := 32;
   constant DMA_UPHDR_WIDTH   : integer := 96;

   constant DMA_ADDR_WIDTH    : integer := 64;
   constant DMA_DESC_WIDTH    : integer := DMA_ADDR_WIDTH;

   constant PAGE_SIZE         : integer := 4096;
   constant PAGE_WIDTH        : integer := log2(PAGE_SIZE);

end dma_pkg;


-- ----------------------------------------------------------------------------
--                        DMA Package
-- ----------------------------------------------------------------------------
package body dma_pkg is

end dma_pkg;

