-- tree_final_stage_fixed_ent.vhd: The last stage (level) of binary search tree fixed for atomic configuration changes 
-- Copyright (C) 2013 Brno University of Technology
-- Author(s): Lukas Kekely <ikekely@fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: tree_final_stage_fixed_ent.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
use WORK.tree_func.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity tree_final_stage_fixed is
  generic(
    -- number of non-leaf tree stages (levels) (capacity is 2**(TS-1) prefixes)
    TREE_STAGES    : integer := 10;
    -- width of keys inside tree nodes
    KEY_WIDTH      : integer := 128;
    -- width of data inside leaf nodes
    DATA_WIDTH     : integer := 32;
    -- type of memory used in implementation of basic final stage of tree
    MEM_TYPE       : MEMORY_TYPE := mem_bmem;
    -- use register on output interface?
    OUTPUT_REG        : boolean := true
  );
  port(
    CLK           : in  std_logic;
    RESET         : in  std_logic;
    
    -- input interface
    IN_ADDR       : in  std_logic_vector(TREE_STAGES-1 downto 0);
    IN_KEY        : in  std_logic_vector(KEY_WIDTH-1 downto 0);
    IN_FOUNDABLE  : in  std_logic;
    IN_VLD        : in  std_logic;
    IN_CHANGE_EN  : in  std_logic;
    
    -- output interface
    OUT_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
    OUT_LENGTH    : out std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    OUT_FOUND     : out std_logic;
    OUT_VLD       : out std_logic;
    
    -- configuration interface for actual final stage of the tree
    CFG_DI        : in  std_logic_vector(DATA_WIDTH+log2(KEY_WIDTH) downto 0);
    CFG_DO        : out std_logic_vector(DATA_WIDTH+log2(KEY_WIDTH) downto 0);
    CFG_DRDY      : out std_logic;
    CFG_ADDR      : in  std_logic_vector(max(0,TREE_STAGES-1) downto 0);
    CFG_WE        : in  std_logic; -- '1' for write, '0' for read
    CFG_EN        : in  std_logic; -- '1' to enabled operation specified by WE on item ADDR
  
    -- result fixing input information    
    FIX_KEY_START : in  std_logic_vector(KEY_WIDTH-1 downto 0); 
    FIX_KEY_END   : in  std_logic_vector(KEY_WIDTH-1 downto 0);
    FIX_LEN       : in  std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    FIX_DATALEN   : in  std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    FIX_DATA      : in  std_logic_vector(DATA_WIDTH-1 downto 0);
    FIX_FOUND     : in  std_logic;
    FIX_ACTIVE    : in  std_logic;
    FIX_IS_ADD    : in  std_logic;
    FIX_ACTIVATE  : out std_logic
  );
end entity;