-- tree_ent.vhd: Interfaces of binary search tree over prefixes
-- Copyright (C) 2013 Brno University of Technology
-- Author(s): Lukas Kekely <ikekely@fit.vutbr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id: tree_ent.vhd 4531 2013-12-20 16:29:12Z xkekel00 $
--
-- TODO:
--
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;
use WORK.math_pack.all;
use WORK.tree_func.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity tree is
  generic(
    -- number of non-leaf tree stages (levels) (capacity is 2**(TS-1) prefixes)
    TREE_STAGES    : integer := 10;
    -- width of keys inside tree nodes
    KEY_WIDTH      : integer := 128;
    -- width of data inside leaf nodes
    DATA_WIDTH     : integer := 32;
    -- types of memories used for stages (from root)
    USE_STAGES     : STAGE_TYPE_ARRAY(0 to 31) := (STAGE_TYPE_REGARRAY, STAGE_TYPE_REGARRAY, STAGE_TYPE_REGARRAY, STAGE_TYPE_DIST3MEM, STAGE_TYPE_NOTHING, 
                                                   STAGE_TYPE_NOTHING,  STAGE_TYPE_DISTMEM,  STAGE_TYPE_DISTMEM,  STAGE_TYPE_BMEM,     STAGE_TYPE_BMEM,
                                                   STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                   STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                   STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                   STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING,
                                                   STAGE_TYPE_NOTHING,  STAGE_TYPE_NOTHING);
    -- memory type used in leaf stage
    USE_STAGE_LEAF : MEMORY_TYPE := mem_bmem;
    -- bitmap of register usage inside processing pipeline (width is TS*3+1)
    USE_REGS       : std_logic_vector(0 to 32*3) := "001" & "001" & "001" & "001" & "001" &
                                                    "001" & "001" & "001" & "001" & "001" &
                                                    "1"   &
                                                    "000" & "000" & "000" & "000" & "000" &
                                                    "000" & "000" & "000" & "000" & "000" &
                                                    "000" & "000" & "000" & "000" & "000" &
                                                    "000" & "000" & "000" & "000" & "000" &
                                                    "000" & "000"
  );
  port(
    CLK           : in  std_logic;
    RESET         : in  std_logic;
    
    -- input interface
    IN_KEY        : in  std_logic_vector(KEY_WIDTH-1 downto 0);
    IN_FOUNDABLE  : in  std_logic;
    IN_VLD        : in  std_logic;
    IN_CHANGE_EN  : in  std_logic;
    
    -- output interface
    OUT_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
    OUT_LENGTH    : out std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    OUT_FOUND     : out std_logic;
    OUT_VLD       : out std_logic;
    
    -- configuration interface
    CFG_KEY       : in  std_logic_vector(KEY_WIDTH-1 downto 0);
    CFG_KEYLEN    : in  std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    CFG_DATA      : in  std_logic_vector(DATA_WIDTH-1 downto 0);
    CFG_ADD_VLD   : in  std_logic;
    CFG_REM_VLD   : in  std_logic;
    CFG_CLR_VLD   : in  std_logic;
    CFG_BUSY      : out std_logic;
    CFG_FULL      : out std_logic;
    DIR_ADDR      : in  std_logic_vector(TREE_STAGES-1 downto 0);
    DIR_RD        : in  std_logic;
    DIR_KEY       : out std_logic_vector(KEY_WIDTH-1 downto 0);
    DIR_KEYLEN    : out std_logic_vector(log2(KEY_WIDTH)-1 downto 0);
    DIR_ISEND     : out std_logic;
    DIR_KEYVLD    : out std_logic;
    DIR_DATA      : out std_logic_vector(DATA_WIDTH-1 downto 0);
    DIR_DRDY      : out std_logic
  );
end entity;