////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 3.0
//  \   \         Application : 7 Series FPGAs Transceivers Wizard 
//  /   /         Filename : gtz_caui4_v3_0_top.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module gtz_caui4_v3_0_top
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
// 
// 
// (c) Copyright 2010-2012 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`timescale 1ns / 1ps
`define DLY #1


//***********************************Entity Declaration************************
(* CORE_GENERATION_INFO = "gtz_caui4_v3_0,gtwizard_v3_0,{protocol_file=Start_from_scratch}" *)
module gtz_caui4_v3_0_top #
  (
   parameter SIM_GTZRESET_SPEEDUP = "FALSE",       // Set to "TRUE" to speed up sim reset
   parameter SIM_VERSION = "1.0",
   parameter EXAMPLE_SIMULATION = 0  // set to 1 to bypass ctle tuning code for simulations
  )
  (
     (* CLOCK_BUFFER_TYPE = "NONE" *) input wire REFCLK_N_IN, //ok
     (* CLOCK_BUFFER_TYPE = "NONE" *) input wire REFCLK_P_IN, //ok
  	 
     output wire TXCLK_OUT, //ok - 161.13 MHz TX local clock
     output wire RXCLK_OUT, //ok - 161.13 MHz RX recovered clock
     output wire RXINTCLK_OUT, // 201.42 MHz for internal RX PCS logic
     output wire RXCLK_STABLE, // RX MMCM locked
     output wire [3:0] RX_OK_OUT,  // RX startup done   
  	 
     input wire DRPCLK_IN,
     input wire DRPSEL,
     input wire DRPEN,
     input wire DRPWE,
     input wire [31:0] DRPDI,
     input wire [15:0] DRPADDR,
     output wire [31:0] DRPDO,
     output wire DRPRDY,
     output wire [2:0] DRPSTATUS,
     output wire DRPWDTERR, 
  
     input wire RESET_IN, //ok
     output wire TXRESETDONE_OUT, // TX PMA ready, TXCLK_OUT synchronous  
     output wire RXRESETDONE_OUT, // RX PMA ready, RXCLK_OUT synchronous 
  
     input wire [20*66-1:0] TXDATA_IN, //ok
     output wire [19:0] TXREADY_OUT, //ok
     
     output wire [20*66-1:0] RXDATA_OUT, //ok
     output wire [19:0] RXVALID_OUT, //ok
     input  wire        RXDATA_OK_IN,// = data decoded corectly
     output wire [19:0] BLK_LOCK_OUT,//ok
  
     input wire [3:0] SIGNAL_DET, //open
  
     input wire POWERDOWN_IN, //ok
  
     input wire FARLOOPBACKEN_IN, //ok
     input wire NEARLOOPBACKEN_IN, //ok
  
     input wire TXPRBSEN_IN, //ok
     input wire [2:0] TXPRBSSEL_IN, //ok
     input wire RXPRBSEN_IN, //ok
     input wire [2:0] RXPRBSSEL_IN, //ok
     output wire [3:0] RXPRBSPASS_OUT, //ok
     
     input wire CTLE_RETUNE,
     
     input wire  [3:0] RXPOLARITY_IN,
     input wire  [3:0] TXPOLARITY_IN, 
      
     output wire [3:0] TXN_OUT, //ok
     output wire [3:0] TXP_OUT, //ok
  
     input wire [3:0] RXN_IN, //ok
     input wire [3:0] RXP_IN, //ok
     output wire [31:0] dbg_state     
  
   );

   //wire DRPCLK_IN;
   
   wire OCT0_GT0_TXP_OUT;
   wire OCT0_GT0_TXN_OUT;
   wire OCT0_GT0_RXP_IN;
   wire OCT0_GT0_RXN_IN;
   				  
   wire OCT0_GT1_TXP_OUT;
   wire OCT0_GT1_TXN_OUT;
   wire OCT0_GT1_RXP_IN;
   wire OCT0_GT1_RXN_IN;
   				  
   wire OCT0_GT2_TXP_OUT;
   wire OCT0_GT2_TXN_OUT;
   wire OCT0_GT2_RXP_IN;
   wire OCT0_GT2_RXN_IN;
   				  
   wire OCT0_GT3_TXP_OUT;
   wire OCT0_GT3_TXN_OUT;
   wire OCT0_GT3_RXP_IN;
   wire OCT0_GT3_RXN_IN;

   wire powerup;
			 
   wire         mmcm_locked;
   wire         oct0_gt0_txresetdone;
   wire         oct0_gt0_rxresetdone;
   wire         oct0_gt0_txrdy;
   wire         oct0_gt0_rxrdy;
   wire [159:0] oct0_gt0_txdata; 
   wire [159:0] oct0_gt0_rxdata;
   wire [9:0]   oct0_gt0_txheader;
   wire [4:0]   oct0_gt0_rxdatavalid;
   wire [9:0]   oct0_gt0_rxheader;
   wire [4:0]   oct0_gt0_rxheadervalid;
   wire [4:0]   oct0_gt0_rxgearboxslip;
   wire [6:0]   txsequence;
   wire         oct0_gt0_tx_system_reset_c;
   wire         oct0_gt0_rx_system_reset_c;   
   wire         txdataready;
				  
   reg 	        oct0_gt0_txresetdone_r;
   reg 	        oct0_gt0_rxresetdone_r;
   reg 	        oct0_gt0_txresetdone_r2;
   reg 	        oct0_gt0_rxresetdone_r2;
   wire         oct0_gt0_rxresetdone_phaseshift;
			 
   wire         oct0_gt1_txresetdone;
   wire         oct0_gt1_rxresetdone;
   wire         oct0_gt1_txrdy;
   wire         oct0_gt1_rxrdy;
   wire [159:0] oct0_gt1_txdata; 
   wire [159:0] oct0_gt1_rxdata;
   wire [9:0]   oct0_gt1_txheader;
   wire [4:0]   oct0_gt1_rxdatavalid;
   wire [9:0]   oct0_gt1_rxheader;
   wire [4:0]   oct0_gt1_rxheadervalid;
   wire [4:0]   oct0_gt1_rxgearboxslip;
   wire         oct0_gt1_tx_system_reset_c;
   wire         oct0_gt1_rx_system_reset_c;   
				  
   reg 	        oct0_gt1_txresetdone_r;
   reg 	        oct0_gt1_rxresetdone_r;
   reg 	        oct0_gt1_txresetdone_r2;
   reg 	        oct0_gt1_rxresetdone_r2;
   wire         oct0_gt1_rxresetdone_phaseshift;
			 
   wire         oct0_gt2_txresetdone;
   wire         oct0_gt2_rxresetdone;
   wire         oct0_gt2_txrdy;
   wire         oct0_gt2_rxrdy;
   wire [159:0] oct0_gt2_txdata; 
   wire [159:0] oct0_gt2_rxdata;
   wire [9:0]   oct0_gt2_txheader;
   wire [4:0]   oct0_gt2_rxdatavalid;
   wire [9:0]   oct0_gt2_rxheader;
   wire [4:0]   oct0_gt2_rxheadervalid;
   wire [4:0]   oct0_gt2_rxgearboxslip;
   wire         oct0_gt2_tx_system_reset_c;
   wire         oct0_gt2_rx_system_reset_c;   
				  
   reg 	        oct0_gt2_txresetdone_r;
   reg 	        oct0_gt2_rxresetdone_r;
   reg 	        oct0_gt2_txresetdone_r2;
   reg 	        oct0_gt2_rxresetdone_r2;
   wire         oct0_gt2_rxresetdone_phaseshift;
			 
   wire         oct0_gt3_txresetdone;
   wire         oct0_gt3_rxresetdone;
   wire         oct0_gt3_txrdy;
   wire         oct0_gt3_rxrdy;
   wire [159:0] oct0_gt3_txdata; 
   wire [159:0] oct0_gt3_rxdata;
   wire [9:0]   oct0_gt3_txheader;
   wire [4:0]   oct0_gt3_rxdatavalid;
   wire [9:0]   oct0_gt3_rxheader;
   wire [4:0]   oct0_gt3_rxheadervalid;
   wire [4:0]   oct0_gt3_rxgearboxslip;
   wire         oct0_gt3_tx_system_reset_c;
   wire         oct0_gt3_rx_system_reset_c;   
				  
   reg 	        oct0_gt3_txresetdone_r;
   reg 	        oct0_gt3_rxresetdone_r;
   reg 	        oct0_gt3_txresetdone_r2;
   reg 	        oct0_gt3_rxresetdone_r2;
   
//    reg [14:0]   lock_cntr_gt0;
//    reg [14:0]   lock_cntr_gt1;
//    reg [14:0]   lock_cntr_gt2;
//    reg [14:0]   lock_cntr_gt3;
   wire         gt3_rxd_ok;
   wire         gt2_rxd_ok;
   wire         gt1_rxd_ok;
   wire         gt0_rxd_ok;
   
   wire         oct0_gt3_rxresetdone_phaseshift;
   wire         oct0_txoutclk0;
   wire         oct0_txoutclk1;
   wire         oct0_rxoutclk0;
   wire         oct0_rxoutclk1;
   wire         oct0_rxoutclk2;
   wire         oct0_rxoutclk3;

   wire [7:0]   oct0_txresetdone;
   wire [7:0]   oct0_rxresetdone;
				   
   wire         oct0_gtzinitdoneb;
   wire         oct0_gtzinit_i;
   	        
   wire         txusrclk0;
   wire         txusrclk1;
   wire         txusrclk2;
   wire         txusrclk3;
   wire         txusrclk4;
   wire         txusrclk5;
   wire         txusrclk6;
   wire         txusrclk7;
      
   wire         rxusrclk0;
   wire         rxusrclk1;
   wire         rxusrclk2;
   wire         rxusrclk3;
   wire         rxusrclk4;
   wire         rxusrclk5;
   wire         rxusrclk6;
   wire         rxusrclk7;

 
   wire         gt0_rx_system_clk;
   wire         gt0_tx_system_clk;
				
 
   wire         gt1_rx_system_clk;
   wire         gt1_tx_system_clk;
				
 
   wire         gt2_rx_system_clk;
   wire         gt2_tx_system_clk;
				
 
   wire         gt3_rx_system_clk;
   wire         gt3_tx_system_clk;
				
				
				
				
				
	        
   wire         mmcm_reset_in;
   wire         mmcm_reset;   
   wire         phase_shift_done;
   wire         resetdone_all;
   //--------------------- Chipscope Signals ---------------------------------  
   
   wire [35:0] 	vio_control_i;
   wire [35:0] 	ila_control_i;

   
   wire [255:0] data_vio_in_i;
   wire [255:0] data_vio_out_i;
   wire [255:0] ila_in0_i;
   
   wire 	tied_to_ground_i;
   wire [255:0] tied_to_ground_vec_i;
   wire 	tied_to_vcc_i;
   wire [7:0] 	tied_to_vcc_vec_i;
			 
   
   wire [7:0] 	oct0_gt0_error_count;
   wire 	oct0_gt0_nearend_lpbk_en_i;
   wire 	oct0_gt0_txreset_i;
   wire 	oct0_gt0_rxreset_i;

			 
   
   wire [7:0] 	oct0_gt1_error_count;
   wire 	oct0_gt1_nearend_lpbk_en_i;
   wire 	oct0_gt1_txreset_i;
   wire 	oct0_gt1_rxreset_i;

			 
   
   wire [7:0] 	oct0_gt2_error_count;
   wire 	oct0_gt2_nearend_lpbk_en_i;
   wire 	oct0_gt2_txreset_i;
   wire 	oct0_gt2_rxreset_i;

			 
   
   wire [7:0] 	oct0_gt3_error_count;
   wire 	oct0_gt3_nearend_lpbk_en_i;
   wire 	oct0_gt3_txreset_i;
   wire 	oct0_gt3_rxreset_i;

				  

   wire 	oct0_redo_channel_tuning;
   
   wire [3:0] 	oct0_read_chan_id;
   wire [3:0] 	oct0_chan_id;
   
   wire [19:0] 	 blk_lock_i;

   //wire sysclk;
   wire soft_reset_i;
   wire oct0_drpclksel_i;
   wire oct1_drpclksel_i;
   
   assign oct0_drpclksel_i = 1'b0;
   assign oct1_drpclksel_i = 1'b0;
   
   assign tied_to_ground_i             = 1'b0;
   assign tied_to_ground_vec_i         = 256'h0000000000000000000000000000000000000000000000000000000000000000;
   assign tied_to_vcc_i                = 1'b1;
   assign tied_to_vcc_vec_i            = 8'hff;
   
   gtz_caui4_v3_0_init #
     (
      // Simulation attributes
      .SIM_GTZRESET_SPEEDUP(SIM_GTZRESET_SPEEDUP),       // Set to "TRUE" to speed up sim reset;
      .SIM_VERSION(SIM_VERSION),
      .EXAMPLE_SIMULATION(EXAMPLE_SIMULATION)
     )
   gtz_caui4_v3_0_init_i
     (
      .sysclk_in(DRPCLK_IN),
      .soft_reset_in(soft_reset_i),
      .mmcm_locked(mmcm_locked),
      .mmcm_reset(mmcm_reset),
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset0_in(1'b0),      
      .oct0_txresetdone0_out(oct0_gt0_txresetdone),      
      .oct0_txrdy0_out(oct0_gt0_txrdy),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset0_in(oct0_gt0_rxreset_i),
      .oct0_rxresetdone0_out(oct0_gt0_rxresetdone),
      .oct0_rxrdy0_out(oct0_gt0_rxrdy),
      .oct0_rxok0_in(gt0_rxd_ok),
      
      .oct0_gtzrxpolarity_in(RXPOLARITY_IN),
      .oct0_gtztxpolarity_in(TXPOLARITY_IN),      
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp0_out(OCT0_GT0_TXP_OUT),
      .oct0_gtztxn0_out(OCT0_GT0_TXN_OUT),
      .oct0_gtzrxp0_in(OCT0_GT0_RXP_IN),
      .oct0_gtzrxn0_in(OCT0_GT0_RXN_IN),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata0_out(oct0_gt0_rxdata),
								
      .oct0_rxdatavalid0_out(oct0_gt0_rxdatavalid),
      .oct0_rxheader0_out(oct0_gt0_rxheader),
      .oct0_rxheadervalid0_out(oct0_gt0_rxheadervalid),
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata0_in(oct0_gt0_txdata),					
		
      .oct0_txheader0_in(oct0_gt0_txheader),
      //---------------------------- PCS Ports ---------------------------------
		
      .oct0_rxgearboxslip0_in(oct0_gt0_rxgearboxslip),
      .oct0_txsequence0_in(txsequence),
	  
      .oct0_refclksel0_in ( 1'b0),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxprbsen0_in(RXPRBSEN_IN),
      .oct0_rxprbssel0_in(RXPRBSSEL_IN),
      .oct0_rxprbspass0_out(RXPRBSPASS_OUT[0]),
      .oct0_txprbsen0_in(TXPRBSEN_IN),
      .oct0_txprbssel0_in(TXPRBSSEL_IN),
      .oct0_nearloopbacken0_in(oct0_gt0_nearend_lpbk_en_i),
      .oct0_farloopbacken0_in(FARLOOPBACKEN_IN),
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset1_in(1'b0),      
      .oct0_txresetdone1_out(oct0_gt1_txresetdone),      
      .oct0_txrdy1_out(oct0_gt1_txrdy),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset1_in(oct0_gt1_rxreset_i),
      .oct0_rxresetdone1_out(oct0_gt1_rxresetdone),
      .oct0_rxrdy1_out(oct0_gt1_rxrdy),
      .oct0_rxok1_in(gt1_rxd_ok),
      
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp1_out(OCT0_GT1_TXP_OUT),
      .oct0_gtztxn1_out(OCT0_GT1_TXN_OUT),
      .oct0_gtzrxp1_in(OCT0_GT1_RXP_IN),
      .oct0_gtzrxn1_in(OCT0_GT1_RXN_IN),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata1_out(oct0_gt1_rxdata),
								
      .oct0_rxdatavalid1_out(oct0_gt1_rxdatavalid),
      .oct0_rxheader1_out(oct0_gt1_rxheader),
      .oct0_rxheadervalid1_out(oct0_gt1_rxheadervalid),
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata1_in(oct0_gt1_txdata),					
		
      .oct0_txheader1_in(oct0_gt1_txheader),
      //---------------------------- PCS Ports ---------------------------------
		
      .oct0_rxgearboxslip1_in(oct0_gt1_rxgearboxslip),
      .oct0_txsequence1_in(txsequence),
	  
      .oct0_refclksel1_in ( 1'b0),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxprbsen1_in(RXPRBSEN_IN),
      .oct0_rxprbssel1_in(RXPRBSSEL_IN),
      .oct0_rxprbspass1_out(RXPRBSPASS_OUT[1]),
      .oct0_txprbsen1_in(TXPRBSEN_IN),
      .oct0_txprbssel1_in(TXPRBSSEL_IN),
      .oct0_nearloopbacken1_in(oct0_gt1_nearend_lpbk_en_i),
      .oct0_farloopbacken1_in(FARLOOPBACKEN_IN),
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset2_in(1'b0),      
      .oct0_txresetdone2_out(oct0_gt2_txresetdone),      
      .oct0_txrdy2_out(oct0_gt2_txrdy),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset2_in(oct0_gt2_rxreset_i),
      .oct0_rxresetdone2_out(oct0_gt2_rxresetdone),
      .oct0_rxrdy2_out(oct0_gt2_rxrdy),
      .oct0_rxok2_in(gt2_rxd_ok),
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp2_out(OCT0_GT2_TXP_OUT),
      .oct0_gtztxn2_out(OCT0_GT2_TXN_OUT),
      .oct0_gtzrxp2_in(OCT0_GT2_RXP_IN),
      .oct0_gtzrxn2_in(OCT0_GT2_RXN_IN),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata2_out(oct0_gt2_rxdata),
								
      .oct0_rxdatavalid2_out(oct0_gt2_rxdatavalid),
      .oct0_rxheader2_out(oct0_gt2_rxheader),
      .oct0_rxheadervalid2_out(oct0_gt2_rxheadervalid),
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata2_in(oct0_gt2_txdata),					
		
      .oct0_txheader2_in(oct0_gt2_txheader),
      //---------------------------- PCS Ports ---------------------------------
		
      .oct0_rxgearboxslip2_in(oct0_gt2_rxgearboxslip),
      .oct0_txsequence2_in(txsequence),
	  
      .oct0_refclksel2_in ( 1'b0),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxprbsen2_in(RXPRBSEN_IN),
      .oct0_rxprbssel2_in(RXPRBSSEL_IN),
      .oct0_rxprbspass2_out(RXPRBSPASS_OUT[2]),
      .oct0_txprbsen2_in(TXPRBSEN_IN),
      .oct0_txprbssel2_in(TXPRBSSEL_IN),
      .oct0_nearloopbacken2_in(oct0_gt2_nearend_lpbk_en_i),
      .oct0_farloopbacken2_in(FARLOOPBACKEN_IN),
					
      //-------------------------------- TX Reset Controller Ports ---------------------------------
      .oct0_gtztxreset3_in(1'b0),      
      .oct0_txresetdone3_out(oct0_gt3_txresetdone),      
      .oct0_txrdy3_out(oct0_gt3_txrdy),
      
      //-------------------------------- RX Reset Controller Ports ---------------------------------
      .oct0_gtzrxreset3_in(oct0_gt3_rxreset_i),
      .oct0_rxresetdone3_out(oct0_gt3_rxresetdone),
      .oct0_rxrdy3_out(oct0_gt3_rxrdy),
      .oct0_rxok3_in(gt3_rxd_ok),
      
      //-------------------------------- Serial Ports ---------------------------------
      .oct0_gtztxp3_out(OCT0_GT3_TXP_OUT),
      .oct0_gtztxn3_out(OCT0_GT3_TXN_OUT),
      .oct0_gtzrxp3_in(OCT0_GT3_RXP_IN),
      .oct0_gtzrxn3_in(OCT0_GT3_RXN_IN),
      
      //-------------------------------- Rx Fabric Interface Ports ---------------------------------
      .oct0_rxdata3_out(oct0_gt3_rxdata),
								
      .oct0_rxdatavalid3_out(oct0_gt3_rxdatavalid),
      .oct0_rxheader3_out(oct0_gt3_rxheader),
      .oct0_rxheadervalid3_out(oct0_gt3_rxheadervalid),
      //-------------------------------- Tx Fabric Interface Ports ---------------------------------
      .oct0_txdata3_in(oct0_gt3_txdata),					
		
      .oct0_txheader3_in(oct0_gt3_txheader),
      //---------------------------- PCS Ports ---------------------------------
		
      .oct0_rxgearboxslip3_in(oct0_gt3_rxgearboxslip),
      .oct0_txsequence3_in(txsequence),
	  
      .oct0_refclksel3_in ( 1'b0),

      //--------------------------- Optional Ports ------------------------------
      .oct0_rxprbsen3_in(RXPRBSEN_IN),
      .oct0_rxprbssel3_in(RXPRBSSEL_IN),
      .oct0_rxprbspass3_out(RXPRBSPASS_OUT[3]),
      .oct0_txprbsen3_in(TXPRBSEN_IN),
      .oct0_txprbssel3_in(TXPRBSSEL_IN),
      .oct0_nearloopbacken3_in(oct0_gt3_nearend_lpbk_en_i),
      .oct0_farloopbacken3_in(FARLOOPBACKEN_IN),

      //--------------------------- Clocking Ports ------------------------------
      
      .oct0_txoutclk0_out(oct0_txoutclk0),
      .oct0_txoutclk1_out(oct0_txoutclk1),      
      .oct0_rxoutclk0_out(oct0_rxoutclk0),
      .oct0_rxoutclk1_out(oct0_rxoutclk1),
      .oct0_rxoutclk2_out(oct0_rxoutclk2),
      .oct0_rxoutclk3_out(oct0_rxoutclk3),

      .oct0_txcoreclk0_out (txusrclk0),
      .oct0_txcoreclk1_out(),
      .oct0_rxcoreclk0_out (rxusrclk0),
      .oct0_rxcoreclk1_out(),
      .oct0_rxcoreclk2_out(),
      .oct0_rxcoreclk3_out(),
      
      .oct0_gtzinit_in(oct0_gtzinit_i),
      .oct0_gtzinitdoneb_out(oct0_gtzinitdoneb),
      
      .oct0_txlatclk_in(1'b0),
      .oct0_rxlatclk_in(1'b0),

      .oct0_gtrefclk0p_in(REFCLK_P_IN),
      .oct0_gtrefclk0n_in(REFCLK_N_IN),
      .oct0_gtrefclk1p_in(1'b0),
      .oct0_gtrefclk1n_in(1'b0),
      .oct0_drpclksel_in(oct0_drpclksel_i),
      .oct0_chan_id_in(oct0_chan_id),
      .oct0_redo_ch_tuning(oct0_redo_channel_tuning),
      
      .oct0_drpsel_in(DRPSEL),
      .oct0_drpen_in(DRPEN),
      .oct0_drpwe_in(DRPWE),
      .oct0_drpdi_in(DRPDI),
      .oct0_drpaddr_in(DRPADDR),
      .oct0_drpdo_out(DRPDO),
      .oct0_drprdy_out(DRPRDY),
      .oct0_drpstatus_out(DRPSTATUS),
      .oct0_drpwdterr_out(DRPWDTERR),
      .drpclk0_in(DRPCLK_IN),
      .drpclk1_in(),
      .drpclk_in(DRPCLK_IN),
      .txusrclk0_in(txusrclk0),
      .txusrclk1_in(txusrclk1),
      .txusrclk2_in(txusrclk2),
      .txusrclk3_in(txusrclk3),
      .txusrclk4_in(txusrclk4),
      .txusrclk5_in(txusrclk5),
      .txusrclk6_in(txusrclk6),
      .txusrclk7_in(txusrclk7),

      .rxusrclk0_in(rxusrclk0),
      .rxusrclk1_in(rxusrclk1),
      .rxusrclk2_in(rxusrclk2),
      .rxusrclk3_in(rxusrclk3),
      .rxusrclk4_in(rxusrclk4),
      .rxusrclk5_in(rxusrclk5),
      .rxusrclk6_in(rxusrclk6),
      .rxusrclk7_in(rxusrclk7),
      // 
      .dbg_state(dbg_state)
      );

   always @(posedge gt0_tx_system_clk or negedge oct0_gt0_txresetdone)
     begin
        if (!oct0_gt0_txresetdone)
          begin
             oct0_gt0_txresetdone_r    <=   `DLY 1'b0;
             oct0_gt0_txresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt0_txresetdone_r    <=   `DLY oct0_gt0_txresetdone;
             oct0_gt0_txresetdone_r2   <=   `DLY oct0_gt0_txresetdone_r; // txusrclk0
          end
     end

   always @(posedge gt0_rx_system_clk or negedge oct0_gt0_rxresetdone)
     begin
        if (!oct0_gt0_rxresetdone)
          begin
             oct0_gt0_rxresetdone_r    <=   `DLY 1'b0;
             oct0_gt0_rxresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt0_rxresetdone_r    <=   `DLY oct0_gt0_rxresetdone;
             oct0_gt0_rxresetdone_r2   <=   `DLY oct0_gt0_rxresetdone_r;
             
          end
     end
     
   assign oct0_gt0_tx_system_reset_c = !oct0_gt0_txresetdone_r2;
   assign oct0_gt0_rx_system_reset_c = !oct0_gt0_rxresetdone_r2 || !phase_shift_done;
						
   gtz_caui4_v3_0_tx_seq_counter gtz_caui4_v3_0_tx_seq_counter_oct0_gt0_i
     (
      .tx_usrclk_in (gt0_tx_system_clk),
      .tx_system_reset_in (oct0_gt0_tx_system_reset_c),
      .tx_sequence_out (txsequence),
      .tx_dataready_out (txdataready)
     );
      
   gtz_caui4_v3_0_tx_interface gtz_caui4_v3_0_tx_interface_oct0_gt0_i
      (
       .tx_usrclk_in (gt0_tx_system_clk),
       .tx_system_reset_in (oct0_gt0_tx_system_reset_c),
       .tx_data_in (TXDATA_IN[329:0]),
       .tx_dataready_in (txdataready),
       .tx_data_out (oct0_gt0_txdata),
       .tx_header_out (oct0_gt0_txheader),
       .tx_dataready_out (TXREADY_OUT[4:0])
      );

   gtz_caui4_v3_0_rx_block_sync #
     (
      .SH_CNT_MAX(1024),
      .SH_INVALID_CNT_MAX(65)
     )
   gtz_caui4_v3_0_rx_block_sync_oct0_gt0_i
     (
      .rx_usrclk_in (gt0_rx_system_clk),
      .rx_system_reset_in (oct0_gt0_rx_system_reset_c),
      .rx_header_in (oct0_gt0_rxheader),
      .rx_headervalid_in (oct0_gt0_rxheadervalid),
      .rx_gearboxslip_out (oct0_gt0_rxgearboxslip),
      .rx_block_lock_out (blk_lock_i[4:0])
     );
      
    gtz_caui4_v3_0_rx_interface gtz_caui4_v3_0_rx_interface_oct0_gt0_i
      (
       .rx_usrclk_in (gt0_rx_system_clk),
       .rx_header_in (oct0_gt0_rxheader),
       .rx_headervalid_in (oct0_gt0_rxheadervalid),
       .rx_data_in (oct0_gt0_rxdata),
       .rx_datavalid_in (oct0_gt0_rxdatavalid),
       .rx_data_out (RXDATA_OUT[329:0]),   
       .rx_datavalid_out (RXVALID_OUT[4:0])
      );
				
   always @(posedge gt1_tx_system_clk or negedge oct0_gt1_txresetdone)
     begin
        if (!oct0_gt1_txresetdone)
          begin
             oct0_gt1_txresetdone_r    <=   `DLY 1'b0;
             oct0_gt1_txresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt1_txresetdone_r    <=   `DLY oct0_gt1_txresetdone;
             oct0_gt1_txresetdone_r2   <=   `DLY oct0_gt1_txresetdone_r;
          end
     end

   always @(posedge gt1_rx_system_clk or negedge oct0_gt1_rxresetdone)
     begin
        if (!oct0_gt1_rxresetdone)
          begin
             oct0_gt1_rxresetdone_r    <=   `DLY 1'b0;
             oct0_gt1_rxresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt1_rxresetdone_r    <=   `DLY oct0_gt1_rxresetdone;
             oct0_gt1_rxresetdone_r2   <=   `DLY oct0_gt1_rxresetdone_r;
             
          end
     end

   assign oct0_gt1_tx_system_reset_c = !oct0_gt1_txresetdone_r2;
   assign oct0_gt1_rx_system_reset_c = !oct0_gt1_rxresetdone_r2 || !phase_shift_done;
						
     
   gtz_caui4_v3_0_tx_interface gtz_caui4_v3_0_tx_interface_oct0_gt1_i
     (
      .tx_usrclk_in (gt1_tx_system_clk),
      .tx_system_reset_in (oct0_gt1_tx_system_reset_c),
      .tx_data_in (TXDATA_IN[659:330]),
      .tx_dataready_in (txdataready),
      .tx_data_out (oct0_gt1_txdata),
      .tx_header_out (oct0_gt1_txheader),
      .tx_dataready_out (TXREADY_OUT[9:5])
     );

   gtz_caui4_v3_0_rx_block_sync #
     (
      .SH_CNT_MAX(1024),
      .SH_INVALID_CNT_MAX(65)
     )
   gtz_caui4_v3_0_rx_block_sync_oct0_gt1_i
     (
      .rx_usrclk_in (gt1_rx_system_clk),
      .rx_system_reset_in (oct0_gt1_rx_system_reset_c),
      .rx_header_in (oct0_gt1_rxheader),
      .rx_headervalid_in (oct0_gt1_rxheadervalid),
      .rx_gearboxslip_out (oct0_gt1_rxgearboxslip),
      .rx_block_lock_out (blk_lock_i[9:5])
     );
      
   gtz_caui4_v3_0_rx_interface gtz_caui4_v3_0_rx_interface_oct0_gt1_i
     (
      .rx_usrclk_in (gt1_rx_system_clk),
      .rx_header_in (oct0_gt1_rxheader),
      .rx_headervalid_in (oct0_gt1_rxheadervalid),
      .rx_data_in (oct0_gt1_rxdata),
      .rx_datavalid_in (oct0_gt1_rxdatavalid),
      .rx_data_out (RXDATA_OUT[659:330]),   
      .rx_datavalid_out (RXVALID_OUT[9:5])
     );
				
   always @(posedge gt2_tx_system_clk or negedge oct0_gt2_txresetdone)
     begin
        if (!oct0_gt2_txresetdone)
          begin
             oct0_gt2_txresetdone_r    <=   `DLY 1'b0;
             oct0_gt2_txresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt2_txresetdone_r    <=   `DLY oct0_gt2_txresetdone;
             oct0_gt2_txresetdone_r2   <=   `DLY oct0_gt2_txresetdone_r;
          end
     end

   always @(posedge gt2_rx_system_clk or negedge oct0_gt2_rxresetdone)
     begin
        if (!oct0_gt2_rxresetdone)
          begin
             oct0_gt2_rxresetdone_r    <=   `DLY 1'b0;
             oct0_gt2_rxresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt2_rxresetdone_r    <=   `DLY oct0_gt2_rxresetdone;
             oct0_gt2_rxresetdone_r2   <=   `DLY oct0_gt2_rxresetdone_r;
             
          end
     end

   assign oct0_gt2_tx_system_reset_c = !oct0_gt2_txresetdone_r2;
   assign oct0_gt2_rx_system_reset_c = !oct0_gt2_rxresetdone_r2 || !phase_shift_done;
						
     
   gtz_caui4_v3_0_tx_interface gtz_caui4_v3_0_tx_interface_oct0_gt2_i
     (
      .tx_usrclk_in (gt2_tx_system_clk),
      .tx_system_reset_in (oct0_gt2_tx_system_reset_c),
      .tx_data_in (TXDATA_IN[989:660]),
      .tx_dataready_in (txdataready),
      .tx_data_out (oct0_gt2_txdata),
      .tx_header_out (oct0_gt2_txheader),
      .tx_dataready_out (TXREADY_OUT[14:10])
     );

   gtz_caui4_v3_0_rx_block_sync #
     (
      .SH_CNT_MAX(1024),
      .SH_INVALID_CNT_MAX(65)
     )
   gtz_caui4_v3_0_rx_block_sync_oct0_gt2_i
     (
      .rx_usrclk_in (gt2_rx_system_clk),
      .rx_system_reset_in (oct0_gt2_rx_system_reset_c),
      .rx_header_in (oct0_gt2_rxheader),
      .rx_headervalid_in (oct0_gt2_rxheadervalid),
      .rx_gearboxslip_out (oct0_gt2_rxgearboxslip),
      .rx_block_lock_out (blk_lock_i[14:10])
     );
      
   gtz_caui4_v3_0_rx_interface gtz_caui4_v3_0_rx_interface_oct0_gt2_i
     (
      .rx_usrclk_in (gt2_rx_system_clk),
      .rx_header_in (oct0_gt2_rxheader),
      .rx_headervalid_in (oct0_gt2_rxheadervalid),
      .rx_data_in (oct0_gt2_rxdata),
      .rx_datavalid_in (oct0_gt2_rxdatavalid),
      .rx_data_out (RXDATA_OUT[989:660]),   
      .rx_datavalid_out (RXVALID_OUT[14:10])
     );
				
   always @(posedge gt3_tx_system_clk or negedge oct0_gt3_txresetdone)
     begin
        if (!oct0_gt3_txresetdone)
          begin
             oct0_gt3_txresetdone_r    <=   `DLY 1'b0;
             oct0_gt3_txresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt3_txresetdone_r    <=   `DLY oct0_gt3_txresetdone;
             oct0_gt3_txresetdone_r2   <=   `DLY oct0_gt3_txresetdone_r;
          end
     end

   always @(posedge gt3_rx_system_clk or negedge oct0_gt3_rxresetdone)
     begin
        if (!oct0_gt3_rxresetdone)
          begin
             oct0_gt3_rxresetdone_r    <=   `DLY 1'b0;
             oct0_gt3_rxresetdone_r2   <=   `DLY 1'b0;
          end
        else
          begin
             oct0_gt3_rxresetdone_r    <=   `DLY oct0_gt3_rxresetdone;
             oct0_gt3_rxresetdone_r2   <=   `DLY oct0_gt3_rxresetdone_r;
             
          end
     end
     
   assign gt3_rxd_ok = ((& blk_lock_i[19:15]) && (RXDATA_OK_IN));
   assign gt2_rxd_ok = ((& blk_lock_i[14:10]) && (RXDATA_OK_IN));
   assign gt1_rxd_ok = ((& blk_lock_i[ 9: 5]) && (RXDATA_OK_IN));
   assign gt0_rxd_ok = ((& blk_lock_i[ 4: 0]) && (RXDATA_OK_IN));

   assign oct0_gt3_tx_system_reset_c = !oct0_gt3_txresetdone_r2;
   assign oct0_gt3_rx_system_reset_c = !oct0_gt3_rxresetdone_r2 || !phase_shift_done;
						
     
   gtz_caui4_v3_0_tx_interface gtz_caui4_v3_0_tx_interface_oct0_gt3_i
     (
      .tx_usrclk_in (gt3_tx_system_clk),
      .tx_system_reset_in (oct0_gt3_tx_system_reset_c),
      .tx_data_in (TXDATA_IN[1319:990]),
      .tx_dataready_in (txdataready),
      .tx_data_out (oct0_gt3_txdata),
      .tx_header_out (oct0_gt3_txheader),
      .tx_dataready_out (TXREADY_OUT[19:15])
     );

   gtz_caui4_v3_0_rx_block_sync #
     (
      .SH_CNT_MAX(1024),
      .SH_INVALID_CNT_MAX(65)
     )
   gtz_caui4_v3_0_rx_block_sync_oct0_gt3_i
     (
      .rx_usrclk_in (gt3_rx_system_clk),
      .rx_system_reset_in (oct0_gt3_rx_system_reset_c),
      .rx_header_in (oct0_gt3_rxheader),
      .rx_headervalid_in (oct0_gt3_rxheadervalid),
      .rx_gearboxslip_out (oct0_gt3_rxgearboxslip),
      .rx_block_lock_out (blk_lock_i[19:15])
     );
				
   gtz_caui4_v3_0_rx_interface gtz_caui4_v3_0_rx_interface_oct0_gt3_i
     (
      .rx_usrclk_in (gt3_rx_system_clk),
      .rx_header_in (oct0_gt3_rxheader),
      .rx_headervalid_in (oct0_gt3_rxheadervalid),
      .rx_data_in (oct0_gt3_rxdata),
      .rx_datavalid_in (oct0_gt3_rxdatavalid),
      .rx_data_out (RXDATA_OUT[1319:990]),   
      .rx_datavalid_out (RXVALID_OUT[19:15])
     );				

   assign gt0_rx_system_clk = rxusrclk1;
   assign gt0_tx_system_clk = txusrclk0;
   assign gt1_rx_system_clk = rxusrclk1;
   assign gt1_tx_system_clk = txusrclk0;
   assign gt2_rx_system_clk = rxusrclk1;
   assign gt2_tx_system_clk = txusrclk0;
   assign gt3_rx_system_clk = rxusrclk1;
   assign gt3_tx_system_clk = txusrclk0;
   assign mmcm_reset_in = (oct0_gt0_rxreset_i || soft_reset_i || mmcm_reset);
   
   assign TXCLK_OUT = txusrclk0;
   assign RXCLK_OUT = rxusrclk1;
   
   assign TXRESETDONE_OUT = !oct0_gt3_tx_system_reset_c &
                            !oct0_gt2_tx_system_reset_c &
                            !oct0_gt1_tx_system_reset_c &
                            !oct0_gt0_tx_system_reset_c;
                            
   assign RXRESETDONE_OUT = !oct0_gt3_rx_system_reset_c &
                            !oct0_gt2_rx_system_reset_c &
                            !oct0_gt1_rx_system_reset_c &
                            !oct0_gt0_rx_system_reset_c;                            

//   assign resetdone_all = 
//                                oct0_gt0_rxresetdone &
//                                oct0_gt1_rxresetdone &
//                                oct0_gt2_rxresetdone &
//                                oct0_gt3_rxresetdone ;

   assign resetdone_all = oct0_gt0_rxresetdone;  
                                     
   gtz_caui4_v3_0_GT_USRCLK_SOURCE 
   gt_usrclk_source_i
     (
      //deskew ports
      .PSCLK(DRPCLK_IN),//tie to DRPCLK
      .PSDONE(),
      .MMCM_LOCKED(mmcm_locked), 
      .DISABLE_PHASE_ADJUSTMENT(1'b0),
      .RESETDONE(resetdone_all),
      .PHASE_SHIFT_DONE(phase_shift_done),
      .MMCM_RST(mmcm_reset_in),
      .OCTAL0_TXOUTCLK0(oct0_txoutclk0),
      .OCTAL0_TXOUTCLK1(oct0_txoutclk1),
      .OCTAL0_RXOUTCLK0(oct0_rxoutclk0), 
      .OCTAL0_RXOUTCLK1(oct0_rxoutclk1), 
      .OCTAL0_RXOUTCLK2(oct0_rxoutclk2), 
      .OCTAL0_RXOUTCLK3(oct0_rxoutclk3),

      .TXUSRCLK0(),//will be driven by BUFG_LB inside the beachfront
      .TXUSRCLK1(txusrclk1),
      .TXUSRCLK2(txusrclk2),
      .TXUSRCLK3(txusrclk3),
      .TXUSRCLK4(txusrclk4),
      .TXUSRCLK5(txusrclk5),
      .TXUSRCLK6(txusrclk6),
      .TXUSRCLK7(txusrclk7),
      
      .RXINTCLK(RXINTCLK_OUT),

      .RXUSRCLK0(),//will be driven by BUFG_LB inside the beachfront
      .RXUSRCLK1(rxusrclk1),
      .RXUSRCLK2(rxusrclk2),
      .RXUSRCLK3(rxusrclk3),
      .RXUSRCLK4(rxusrclk4),
      .RXUSRCLK5(rxusrclk5),
      .RXUSRCLK6(rxusrclk6),
      .RXUSRCLK7(rxusrclk7)
      
      );
       assign  RXCLK_STABLE                     = (phase_shift_done && mmcm_locked);
	   assign  soft_reset_i                     = RESET_IN ;
	   assign  oct0_gt0_rxreset_i               = !SIGNAL_DET[0];
	   assign  oct0_gt1_rxreset_i               = (!SIGNAL_DET[1] || !oct0_gt0_rxresetdone);
	   assign  oct0_gt2_rxreset_i               = (!SIGNAL_DET[2] || !oct0_gt1_rxresetdone);
	   assign  oct0_gt3_rxreset_i               = (!SIGNAL_DET[3] || !oct0_gt2_rxresetdone);
	                                                
	   assign  oct0_gtzinit_i                   =  1'b0;
	   assign  oct0_chan_id                     =  4'b1000;
	   //assign  oct0_redo_channel_tuning         =  1'b0;
	   assign  oct0_redo_channel_tuning         =  CTLE_RETUNE;
	   assign  oct0_gt0_nearend_lpbk_en_i       =  NEARLOOPBACKEN_IN;
	   assign  oct0_gt1_nearend_lpbk_en_i       =  NEARLOOPBACKEN_IN;
	   assign  oct0_gt2_nearend_lpbk_en_i       =  NEARLOOPBACKEN_IN;
	   assign  oct0_gt3_nearend_lpbk_en_i       =  NEARLOOPBACKEN_IN;
	   
	   
	   assign TXP_OUT = {OCT0_GT3_TXP_OUT,OCT0_GT2_TXP_OUT,OCT0_GT1_TXP_OUT,OCT0_GT0_TXP_OUT};
	   assign TXN_OUT = {OCT0_GT3_TXN_OUT,OCT0_GT2_TXN_OUT,OCT0_GT1_TXN_OUT,OCT0_GT0_TXN_OUT};
	   
	   assign {OCT0_GT3_RXP_IN,OCT0_GT2_RXP_IN,OCT0_GT1_RXP_IN,OCT0_GT0_RXP_IN} = RXP_IN;
	   assign {OCT0_GT3_RXN_IN,OCT0_GT2_RXN_IN,OCT0_GT1_RXN_IN,OCT0_GT0_RXN_IN} = RXN_IN;
	   
	   assign powerup = !POWERDOWN_IN;
	   
	   assign RX_OK_OUT = {oct0_gt3_rxresetdone & SIGNAL_DET[3], 
	                       oct0_gt2_rxresetdone & SIGNAL_DET[2],
	                       oct0_gt1_rxresetdone & SIGNAL_DET[1], 
	                       oct0_gt0_rxresetdone & SIGNAL_DET[0]};
	                       
	  assign BLK_LOCK_OUT = blk_lock_i;

endmodule

