-- eth_phy_ent.vhd : Ethernet PHY layer (PCS and PMA sublayers) implementation
--                   for Fiberblaze FB1CG card
--!
--! \file
--! \brief Ethernet PHY layer implementation for Fiberblaze FB1CG card
--! \author Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--! \date 2014
--!
--! \section License
--!
--! Copyright (C) 2014 CESNET
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!


library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;


-- ----------------------------------------------------------------------------
--                             Entity declaration
-- ----------------------------------------------------------------------------

entity eth_phy is
generic (
   --! \brief Short Range 10 mode of Ethernet enabled.
   --! \details When true SR10 mode is used; when false LR4 mode is used.
   SR10_MODE : boolean := false
);
port (
   --! \name Clock and reset signals
   -- -------------------------------------------------------------------------
   --! \brief Asynchronous reset
   RESET         : in  std_logic;
   --! \brief DRP clock signal
   --! \details maximum 125 MHz
   DRPCLK        : in  std_logic;

   --! \name CGMII interface
   -- -------------------------------------------------------------------------
   --! \brief RX clock (195.3125 MHz) 
   CGMII_RXCLK   : out std_logic;
   --! \brief RX data
   CGMII_RXD     : out std_logic_vector(511 downto 0);
   --! \brief RX control
   CGMII_RXC     : out std_logic_vector( 63 downto 0);
   --! \brief TX clock (195.3125 MHz) 
   CGMII_TXCLK   : out std_logic;
   --! \brief TX data
   CGMII_TXD     : in  std_logic_vector(511 downto 0);
   --! \brief TX control
   CGMII_TXC     : in  std_logic_vector( 63 downto 0);
   --! \brief CGMII RX and TX clock stable
   CLK_STABLE : out std_logic;

   --! \name Transceiver reference clock interface
   -- -------------------------------------------------------------------------
   CFP2_GTZ_REFCLK_P   : in std_logic; -- GTZ clock positive (322.266 MHz)
   CFP2_GTZ_REFCLK_N   : in std_logic; -- GTZ clock negative
   CFP2_GTH_REFCLK_P   : in std_logic; -- GTH clock positive (156.25 MHz)
   CFP2_GTH_REFCLK_N   : in std_logic; -- GTH clock negative

   --! \name Transceiver data interface
   -- -------------------------------------------------------------------------
   --! \brief RX data, positive
   CFP2_RX_P     : in  std_logic_vector(9 downto 0);
   --! \brief RX data, negative
   CFP2_RX_N     : in  std_logic_vector(9 downto 0);
   --! \brief TX data, positive
   CFP2_TX_P     : out std_logic_vector(9 downto 0);
   --! \brief TX data, negative
   CFP2_TX_N     : out std_logic_vector(9 downto 0);
   
   --! \name Signal detect
   -- -------------------------------------------------------------------------
   --! \brief Signal detect from the transceiver/PMD
   SIGNAL_DET    : in  std_logic_vector(3 downto 0);

   --! \name Transceiver management interface
   -- -------------------------------------------------------------------------
   --! \brief MDIO clock
   CFP2_MDC      : out std_logic;
   --! \brief MDIO input data
   CFP2_MDIO_I   : in  std_logic;
   --! \brief MDIO output data
   CFP2_MDIO_O   : out std_logic;
   --! \brief MDIO output enable, active low
   CFP2_MDIO_OE  : out  std_logic;
     
   --! \name Input MI32 interface
   -- -------------------------------------------------------------------------
   --! \brief Clock signal
   MI_CLK        : in  std_logic;
   --! \brief Reset signal
   MI_RESET      : in  std_logic;
   --! \brief Data to be written
   MI_DWR        : in  std_logic_vector(31 downto 0);
   --! \brief Address bus
   MI_ADDR       : in  std_logic_vector(31 downto 0);
   --! \brief Read request
   MI_RD         : in  std_logic;
   --! \brief Write request
   MI_WR         : in  std_logic;
   --! \brief Byte enable signals      
   MI_BE         : in  std_logic_vector(3 downto 0);
   --! \brief Read data
   MI_DRD        : out std_logic_vector(31 downto 0);
   --! \brief Address ready
   MI_ARDY       : out std_logic;
   --! \brief Read data ready
   MI_DRDY       : out std_logic
);
end entity eth_phy;
