library ieee;
use ieee.std_logic_1164.all;

entity crc32_fast8_tab is

	port (
		DI : in std_logic_vector(7 downto 0);
		DO : out std_logic_vector(31 downto 0)
	);

end entity;

architecture structural of crc32_fast8_tab is

	signal out1 : std_logic_vector(23 downto 0);

	signal out2 : std_logic_vector(28 downto 0);

	signal out3 : std_logic_vector(29 downto 0);

begin

	out1(0) <= DI(2);
	out1(1) <= DI(0) XOR DI(3);
	out1(2) <= DI(0) XOR DI(1);
	out1(3) <= DI(4);
	out1(4) <= DI(2) XOR DI(5);
	out1(5) <= DI(1);
	out1(6) <= DI(3) XOR DI(6);
	out1(7) <= DI(0) XOR DI(2);
	out1(8) <= DI(4) XOR DI(7);
	out1(9) <= DI(1) XOR DI(3);
	out1(10) <= DI(4) XOR DI(5);
	out1(11) <= DI(0) XOR DI(6);
	out1(12) <= DI(5);
	out1(13) <= DI(1) XOR DI(7);
	out1(14) <= DI(6);
	out1(15) <= DI(7);
	out1(16) <= DI(3);
	out1(17) <= DI(0) XOR DI(4);
	out1(18) <= DI(1) XOR DI(2);
	out1(19) <= DI(2) XOR DI(3);
	out1(20) <= DI(2) XOR DI(4);
	out1(21) <= DI(4) XOR DI(6);
	out1(22) <= DI(0);
	out1(23) <= DI(6) XOR DI(7);

	out2(0) <= out1(0);
	out2(1) <= out1(1);
	out2(2) <= out1(2) XOR out1(3);
	out2(3) <= out1(4) XOR out1(5);
	out2(4) <= out1(6) XOR out1(7);
	out2(5) <= out1(8) XOR out1(9);
	out2(6) <= out1(10);
	out2(7) <= out1(11) XOR out1(12);
	out2(8) <= out1(13) XOR out1(14);
	out2(9) <= out1(15);
	out2(10) <= out1(16);
	out2(11) <= out1(17);
	out2(12) <= out1(2) XOR out1(12);
	out2(13) <= out1(18) XOR out1(14);
	out2(14) <= out1(19) XOR out1(15);
	out2(15) <= out1(1) XOR out1(20);
	out2(16) <= out1(2) XOR out1(10);
	out2(17) <= out1(2) XOR out1(4);
	out2(18) <= out1(21);
	out2(19) <= out1(4) XOR out1(6);
	out2(20) <= out1(13);
	out2(21) <= out1(6) XOR out1(8);
	out2(22) <= out1(4) XOR out1(8);
	out2(23) <= out1(22);
	out2(24) <= out1(2);
	out2(25) <= out1(2) XOR out1(0);
	out2(26) <= out1(12);
	out2(27) <= out1(10) XOR out1(11);
	out2(28) <= out1(2) XOR out1(23);

	out3(0) <= out2(0);
	out3(1) <= out2(1);
	out3(2) <= out2(2);
	out3(3) <= out2(3);
	out3(4) <= out2(4);
	out3(5) <= out2(5);
	out3(6) <= out2(6);
	out3(7) <= out2(7);
	out3(8) <= out2(8);
	out3(9) <= out2(9);
	out3(10) <= out2(10);
	out3(11) <= out2(11);
	out3(12) <= out2(12);
	out3(13) <= out2(13);
	out3(14) <= out2(14);
	out3(15) <= out2(15);
	out3(16) <= out2(16) XOR out2(10);
	out3(17) <= out2(17) XOR out2(18);
	out3(18) <= out2(19) XOR out2(20);
	out3(19) <= out2(21);
	out3(20) <= out2(22);
	out3(21) <= out2(19);
	out3(22) <= out2(22) XOR out2(23);
	out3(23) <= out2(19) XOR out2(24);
	out3(24) <= out2(21) XOR out2(25);
	out3(25) <= out2(5) XOR out2(26);
	out3(26) <= out2(27);
	out3(27) <= out2(28) XOR out2(26);
	out3(28) <= out2(28);
	out3(29) <= out2(20);

	DO(0) <= out3(0);
	DO(1) <= out3(1);
	DO(2) <= out3(2);
	DO(3) <= out3(3);
	DO(4) <= out3(4);
	DO(5) <= out3(5);
	DO(6) <= out3(6);
	DO(7) <= out3(7);
	DO(8) <= out3(8);
	DO(9) <= out3(9);
	DO(10) <= out3(0);
	DO(11) <= out3(10);
	DO(12) <= out3(11);
	DO(13) <= out3(12);
	DO(14) <= out3(13);
	DO(15) <= out3(14);
	DO(16) <= out3(15);
	DO(17) <= out3(16);
	DO(18) <= out3(17);
	DO(19) <= out3(18);
	DO(20) <= out3(19);
	DO(21) <= out3(20);
	DO(22) <= out3(21);
	DO(23) <= out3(19);
	DO(24) <= out3(22);
	DO(25) <= out3(23);
	DO(26) <= out3(24);
	DO(27) <= out3(25);
	DO(28) <= out3(26);
	DO(29) <= out3(27);
	DO(30) <= out3(28);
	DO(31) <= out3(29);

end architecture;
