-- buf_ent.vhd: Entity of buf part of CGMII OBUF
-- Copyright (C) 2012 CESNET
-- Author(s): Vaclav Hummel <xhumme00@stud.fit.vubr.cz>
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in
--    the documentation and/or other materials provided with the
--    distribution.
-- 3. Neither the name of the Company nor the names of its contributors
--    may be used to endorse or promote products derived from this
--    software without specific prior written permission.
--
-- This software is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
--
-- $Id$
--
-- TODO:
--
--


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

-- ----------------------------------------------------------------------------
--                        Entity declaration
-- ----------------------------------------------------------------------------
entity buf is
   generic (
      --Number of items in data buffer
      DFIFO_ITEMS    : integer := 512;
      --Number of items in helper fifo
      HFIFO_ITEMS    : integer := 128;
      --Counters in DSP (false -> no, true -> yes)  
      CNT_DSP        : boolean := true
   );
   port (
      --Clock & Reset -------------------------------------
      FLU_CLK        : in std_logic;
      FLU_RESET      : in std_logic;

      CGMII_CLK      : in std_logic;
      CGMII_RESET    : in std_logic;

      MI_CLK         : in std_logic;
      MI_RESET       : in std_logic;
      
      --FLU RX --------------------------------------------
      RX_DATA       	: in std_logic_vector(511 downto 0);
      RX_SOP_POS    	: in std_logic_vector(2 downto 0);
      RX_EOP_POS    	: in std_logic_vector(5 downto 0);
      RX_SOP        	: in std_logic;
      RX_EOP        	: in std_logic;
      RX_SRC_RDY    	: in std_logic;
      RX_DST_RDY    	: out std_logic;
      
      -- FLU TX -------------------------------------------
      TX_DATA       	: out std_logic_vector(511 downto 0);
      TX_SOP_POS    	: out std_logic_vector(2 downto 0);
      TX_EOP_POS    	: out std_logic_vector(5 downto 0);
      TX_SOP        	: out std_logic;
      TX_EOP        	: out std_logic;
      TX_SRC_RDY    	: out std_logic;
      TX_DST_RDY    	: in std_logic;
      
      -- OBUF MI32 interface ------------------------------
      MI_DWR      	   : in  std_logic_vector(31 downto 0); -- Input Data
      MI_ADDR     	   : in  std_logic_vector(31 downto 0); -- Address
      MI_RD       	   : in  std_logic;                     -- Read Request
      MI_WR       	   : in  std_logic;                     -- Write Request
      MI_BE       	   : in  std_logic_vector(3  downto 0); -- Byte Enable
      MI_DRD      	   : out std_logic_vector(31 downto 0); -- Output Data
      MI_ARDY     	   : out std_logic;                     -- Address Ready
      MI_DRDY     	   : out std_logic                      -- Data Ready

   );
end entity buf;
