--!
--! asfifo_wrapper.vhd: Wrapper for asynchronous FIFO from LUTs
--! Copyright (C) 2014 CESNET
--! Author(s): Jiri Matousek <xmatou06@stud.fit.vutbr.cz>
--!
--! Redistribution and use in source and binary forms, with or without
--! modification, are permitted provided that the following conditions
--! are met:
--! 1. Redistributions of source code must retain the above copyright
--!    notice, this list of conditions and the following disclaimer.
--! 2. Redistributions in binary form must reproduce the above copyright
--!    notice, this list of conditions and the following disclaimer in
--!    the documentation and/or other materials provided with the
--!    distribution.
--! 3. Neither the name of the Company nor the names of its contributors
--!    may be used to endorse or promote products derived from this
--!    software without specific prior written permission.
--!
--! This software is provided ``as is'', and any express or implied
--! warranties, including, but not limited to, the implied warranties of
--! merchantability and fitness for a particular purpose are disclaimed.
--! In no event shall the company or contributors be liable for any
--! direct, indirect, incidental, special, exemplary, or consequential
--! damages (including, but not limited to, procurement of substitute
--! goods or services; loss of use, data, or profits; or business
--! interruption) however caused and on any theory of liability, whether
--! in contract, strict liability, or tort (including negligence or
--! otherwise) arising in any way out of the use of this software, even
--! if advised of the possibility of such damage.
--!
--! $Id$
--!
--! TODO:
--!


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;


-- ----------------------------------------------------------------------------
--                          Entity declaration
-- ----------------------------------------------------------------------------

entity asfifo is
generic (
   --! Data Width
   DATA_WIDTH   : integer := 16;
   --! Item in memory needed, one item size is DATA_WIDTH
   ITEMS        : integer := 16;
   --! Distributed Ram Type(capacity) only 16, 32, 64 bits
   DISTMEM_TYPE : integer := 16;

   --! Width of status information of fifo fullness
   --! Note: 2**STATUS_WIDTH MUST BE!! less or equal
   --!       than ITEMS
   STATUS_WIDTH : integer := 4
);
port (
   --! Write interface
   CLK_WR   : in  std_logic;
   RST_WR   : in  std_logic;
   DI       : in  std_logic_vector(DATA_WIDTH-1 downto 0);
   WR       : in  std_logic;
   FULL     : out std_logic;
   STATUS   : out std_logic_vector(STATUS_WIDTH-1 downto 0);

   --! Read interface
   CLK_RD   : in  std_logic;
   RST_RD   : in  std_logic;
   DO       : out std_logic_vector(DATA_WIDTH-1 downto 0);
   RD       : in  std_logic;
   EMPTY    : out std_logic
);
end entity asfifo;


-- ----------------------------------------------------------------------------
--                      Architecture declaration
-- ----------------------------------------------------------------------------

architecture behavioral of asfifo is

begin

   asfifo_i : entity work.asfifo_top
   generic map (
      DATA_WIDTH   => DATA_WIDTH,
      ITEMS        => ITEMS,
      DISTMEM_TYPE => DISTMEM_TYPE,

      STATUS_WIDTH => STATUS_WIDTH
   )
   port map (
      --! Write interface
      CLK_WR   => CLK_WR,
      RST_WR   => RST_WR,
      DI       => DI,
      WR       => WR,
      FULL     => FULL,
      STATUS   => STATUS,

      --! Read interface
      CLK_RD   => CLK_RD,
      RST_RD   => RST_RD,
      DO       => DO,
      RD       => RD,
      EMPTY    => EMPTY
   );

end architecture behavioral;
